<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOtherPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('other_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('other_fee_id')->unsigned()->nullable();
            $table->string('name')->nullable();
            $table->string('phone_number')->nullable();
            $table->integer('fee_type_id')->unsigned()->nullable();
            $table->string('reference')->nullable();
            $table->float('amount')->nullable();
            $table->string('transaction_ref')->nullable();
            $table->integer('bank_id')->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('other_payments');
    }
}
