<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentCardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_cards', function (Blueprint $table) {
            $table->id();
            $table->string('student_id')->nullable();

            $table->string('student_name')->nullable();
            $table->string('college_name')->nullable();
            $table->string('section_name')->nullable();

            $table->string('notes')->nullable()->nullable()->default(null);

            $table->integer('number_of_print')->unsigned()->nullable()->default(0);
            $table->integer('front_prints')->unsigned()->nullable()->default(0);
            $table->integer('back_prints')->unsigned()->nullable()->default(0);
            
            $table->tinyInteger('status')->nullable()->default(0);

            $table->timestamp('expire_date')->nullable()->nullable()->default(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_cards');
    }
}
