<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegistrationConstraintsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registration_constraints', function (Blueprint $table) {
            $table->id();
            $table->integer('college_id')->unsigned()->nullable();
            $table->integer('batch_id')->unsigned()->nullable();
            $table->timestamp('start')->nullable();
            $table->timestamp('end')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registration_constraints');
    }
}
