<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexesToTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            // Adding indexes safely
            Schema::table('students', function (Blueprint $table) {
                $table->index('college_id');
            });

            Schema::table('payments', function (Blueprint $table) {
                $table->index('student_id');
                $table->index('payment_reference');
                $table->index('bank_id');
            });

            Schema::table('registrations', function (Blueprint $table) {
                $table->index('student_id');
                $table->index('payment_reference');
            });
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            // Dropping indexes if needed
            Schema::table('students', function (Blueprint $table) {
                $table->dropIndex(['college_id']);
            });

            Schema::table('payments', function (Blueprint $table) {
                $table->index('student_id');
                $table->index('payment_reference');
                $table->index('bank_id');
            });

            Schema::table('registrations', function (Blueprint $table) {
                $table->index('student_id');
                $table->index('payment_reference');
            });
        });
    }
}
