<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFeeInstalmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fee_instalments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('fee_id')->constrained('registrations')->onDelete('cascade'); // link to students table
            $table->decimal('amount', 10, 2);
            $table->date('due_date');
            $table->tinyInteger('is_paid');
            $table->date('paid_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fee_instalments');
    }
}
