document.addEventListener('DOMContentLoaded', function () {
    function initAjaxTableSearch(el) {
        const $el = $(el);
        const url = $el.data('url');
        const target = $($el.data('target'));
        const searchInput = $($el.data('search'));
        const paramKeys = ($el.data('params') || '').split(',').map(k => k.trim()).filter(Boolean);
        const urlParams = new URLSearchParams(window.location.search);

        function buildQuery(keyword = '') {
            const query = { keyword: keyword };
            paramKeys.forEach(key => {
                const value = urlParams.get(key);
                if (value !== null) {
                    query[key] = value;
                }
            });
            return query;
        }

        function fetchData(keyword = '', fetchUrl = url) {
            $.ajax({
                url: fetchUrl,
                data: buildQuery(keyword),
                success: function (data) {
                    target.html(data.html);
                }
            });
        }

        // Initial load
        fetchData();

        // On search input keyup
        searchInput.on('keyup', function () {
            fetchData($(this).val());
        });

        // On pagination click
        $(document).on('click', `${$el.data('target')} .pagination a`, function (e) {
            e.preventDefault();
            const keyword = searchInput.val();
            fetchData(keyword, $(this).attr('href'));
        });
    }

    // Auto-init
    $('.ajax-search-table').each(function () {
        initAjaxTableSearch(this);
    });
});
