@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
    <link rel="stylesheet" href="{{ asset('css/custom-style.css') }}">

    <style>
        .html5buttons {
            direction: ltr;
            position: absolute;
            top: -45px;
            left: 10px;
        }

        .html5buttons .btn-secondary {
            color: #ffffff;
            background-color: #295694;
        }

        .html5buttons .buttons-print {
            background-color: rgb(167, 32, 53);
            color: white;
        }

        .dataTables_filter {
            margin: 20px 0px 20px;
        }

        #min,
        #max {
            max-width: 150px;
            min-width: unset;
            font-size: 12px;
            font-weight: 400;
            text-align: center;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: none !important;
            min-height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
        }

        .dt-datetime-year,
        .dt-datetime-month {
            min-width: unset !important;
            width: 50px !important;
            max-height: 22px !important;
        }

        .dropdown-menu .dropdown-item {
            text-align: right !important;
        }

        tfoot p {
            color: white !important;
            font-size: 12px !important;
            font-weight: 100 !important;
        }

        input[type='text'],
        input[type='date'],
        input[type='number'],
        select,
        input[type='text']:focus,
        input[type='date']:focus,
        input[type='number']:focus,
        input[type='text']:focus-visible,
        input[type='date']:focus-visible {
            width: unset;
        }

        #printRevenuesModal img {
            width: 1122.5px;
            height: 135px;
        }

        #printRevenuesModal .student-name {
            width: 40%;
            text-align: right;
            padding-right: 20px;
        }

        tbody tr {
            color: black;
        }

        .custom-table {
            border: none !important;
        }

        .custom-table .col-1,
        .custom-table .col-2,
        .custom-table .col-3,
        .custom-table .col-4,
        .custom-table .col-5,
        .custom-table .col-6,
        .custom-table .attendance-title {
            border: none !important;
            border-collapse: collapse;
        }

        .custom-table .no {
            border-right: none !important;
        }

        .custom-table .attendance-cell .col-1-10,
        .custom-table .attendance-cell .col-10-10 {
            position: relative;
            min-height: 1px;
            border: none !important;
            border-collapse: collapse;
            float: left;
        }

        .custom-table .attendance-cell .col-1-10 {
            width: 10%;
        }

        .custom-table .attendance-cell .col-10-10 {
            width: 100%;
        }

        .excluded:focus {
            box-shadow: unset !important;
        }

        .sorting_disabled::before,
        .sorting_disabled::after {
            display: none !important;
        }

        /* Update all table cell borders to none and background to grey */
        table td,
        table th,
        .table td,
        .table th,
        .border-2 {
            border-width: 0 !important;
            border-style: none !important;
            border-color: transparent !important;
            background-color: #f0f0f0 !important; /* Light grey background */
        }

        table, .table {
            border-collapse: separate !important;
            border-spacing: 1px !important; /* Add 1px gap between cells */
        }

        table, .table {
            background-color: #ccc; /* color of the 1px gaps */
        }

        tfoot {
            background-color: #36304a !important;
        }
    </style>

    <link rel="stylesheet" href="{{ asset('plugins/datatable/css/dateTime.min.css') }}">
@endsection

@section('content')
    <div class="container-fluid main-container">
        <div class="row justify-content-center">
            <div class="col-md-12">

                <div class="card" id="content">
                    <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                        {{ __('home.exams-attendance-sheet') }}

                        <button class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none" id="printRevenuesBtn">
                            طباعة
                        </button>
                    </div>

                    <div class="card-body">
                        <!-- filter -->
                        @include('layouts.filter')

                        <div class="row flex justify-center pt-8">
                            <div class="grid grid-cols-1 gap-4 col-9">
                                <div>
                                    <table class="text-right text-sm w-full">
                                        <tr>
                                            <td class="col-6 font-bold p-2 px-3 text-right">
                                                <div class="flex justify-around row">
                                                    <div class="col-6">الكلية</div>
                                                    <div class="col-6">
                                                        {{ isset($college) ? $college->name : '' }}
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="col-6 font-bold p-2 px-3 text-right">
                                                <div class="flex justify-around row">
                                                    <div class="col-6">الدفعة</div>
                                                    <div class="col-6">
                                                        {{ isset($batch) ? $batch->value : '' }}
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="col-6 font-bold p-2 px-3 text-right">
                                                <div class="flex justify-around row">
                                                    <div class="col-6">القسم</div>
                                                    <div class="col-6">
                                                        {{ isset($section) ? $section->name : '' }}
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="col-6 font-bold p-2 px-3 text-right">
                                                <div class="flex justify-around row">
                                                    <div class="col-6">البرنامج</div>
                                                    <div class="col-6">
                                                        {{ isset($program) ? $program->name : '' }}
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>

                                <div id="studentsListTable" class="mt-4">
                                    <table class="table" id="studentsTable2">
                                        <thead>
                                        <tr>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">#</th>
                                            <th class="col-2 font-bold p-2 text-center text-white" style="background-color: #36304a !important">رقم الطالب</th>
                                            <th class="col-3 font-bold p-2 text-center text-white" style="background-color: #36304a !important">اسم الطالب</th>
                                            <th class="col-2 font-bold p-2 text-center text-white" style="background-color: #36304a !important">التوقيع</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">أعمال سنة</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">نصفي</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">نهائي</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">المجموع</th>
                                            <th class="col-1 font-bold p-1 text-center text-white" style="background-color: #36304a !important">استبعاد</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if ( isset($students) )
                                                <?php $no = 1;  ?>
                                            @foreach ($students as $student)
                                                <tr>
                                                    <td class="text-center">
                                                        {{ $no }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $student->student_id }}
                                                    </td>
                                                    <td class="text-right pr-5">
                                                        {{ $student->student_name }}
                                                    </td>
                                                    <td class="col-2 text-center px-3" style="width: 10px;">&nbsp;</td>
                                                    <td class="col-2 text-center px-3" style="width: 10px;">&nbsp;</td>
                                                    <td class="col-2 text-center px-3" style="width: 10px;">&nbsp;</td>
                                                    <td class="col-2 text-center px-3" style="width: 10px;">&nbsp;</td>
                                                    <td class="col-2 text-center px-3" style="width: 10px;">&nbsp;</td>
                                                    <td class="text-center">
                                                        <input type="checkbox"
                                                               class="excluded w-4 h-4 text-blue-600 bg-gray-300 rounded"
                                                               value="{{ $student->student_id }}"
                                                            {{ $student->excluded == 1 ? 'checked' : '' }}>
                                                    </td>
                                                </tr>
                                                    <?php $no++; ?>
                                            @endforeach
                                        @endif
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">#</th>
                                            <th class="col-2 font-bold text-center text-white" style="background-color: #36304a !important">رقم الطالب</th>
                                            <th class="col-3 font-bold p-2 text-center text-white" style="background-color: #36304a !important">اسم الطالب</th>
                                            <th class="col-2 font-bold p-2 text-center text-white" style="background-color: #36304a !important">التوقيع</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">أعمال سنة</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">نصفي</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">نهائي</th>
                                            <th class="col-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">المجموع</th>
                                            <th class="col-1 font-bold p-1 text-center text-white" style="background-color: #36304a !important">استبعاد</th>
                                        </tr>
                                        </tfoot>
                                    </table>

                                    <div>
                                        {{ $students->withQueryString()->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- modal --}}
        <div hidden>
            <div class="flex justify-center" id="printRevenuesModal">
                <div class="grid grid-cols-1 gap-4">
                    <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="">

                    <h1 class="font-bold text-2xl text-center">قوائم إجلاس الطلاب</h1>

                    <div class="student-name">
                        <p class="p-2 pr-5">اسم الطالب: <span class="text-2xl">اسم الطالب هنا</span></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- modal --}}
    <div hidden>
        <div class="flex justify-center" id="printRevenuesModal">
            <div class="grid grid-cols-1 gap-4">
                <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="">

                <h1 class="font-bold text-2xl text-center">قوائم إجلاس الطلاب</h1>

                <div class="custom-table">
                    <div class="row" dir="rtl">
                        <div class="col-6 flex justify-between">
                            <span class="text-right mr-4 font-bold">الكلية : </span>
                            <span class="text-right mr-4">
                            {{ isset($college) ? $college->name : '' }}
                        </span>
                        </div>
                        <div class="col-6 flex justify-between">
                            <span class="text-right mr-4 font-bold">الدفعة : </span>
                            <span class="text-right mr-4">
                            {{ isset($batch) ? $batch->value : '' }}
                        </span>
                        </div>
                    </div>
                    <div class="row" dir="rtl">
                        <div class="col-6 flex justify-between">
                            <span class="text-right mr-4 font-bold">القسم : </span>
                            <span class="text-right mr-4">
                            {{ isset($section) ? $section->name : '' }}
                        </span>
                        </div>
                        <div class="col-6 flex justify-between">
                            <span class="text-right mr-4 font-bold">البرنامج : </span>
                            <span class="text-right mr-4">
                            {{ isset($program) ? $program->name : '' }}
                        </span>
                        </div>
                    </div>
                </div>
                <div class="custom-table">
                    <div class="row" dir="rtl">
                        <div class="col-1 text-center px-1">#</div>
                        <div class="col-2 text-center px-0" style="width: 12.499999995%;
                    flex: 0 0 12.499%;max-width: 12.499%;">رقم الطالب</div>
                        <div class="col-4 text-center px-1">اسم الطالب</div>
                        <div class="col-2 text-center px-1" style="width: 12.499999995%;
                    flex: 0 0 12.499%;max-width: 12.499%;">التوقيع</div>
                        <div class="col-1 text-center px-1">اعمال سنة</div>
                        <div class="col-1 text-center px-1">نصفي</div>
                        <div class="col-1 text-center px-1">نهائي</div>
                        <div class="col-1 text-center px-1">المجموع</div>
                    </div>
                    @if ( isset($students) )
                            <?php $no = 1; ?>
                        @foreach ($students as $student)
                            <div class="row allPrintedStudents" dir="rtl" data-id="{{ $student->student_id }}">
                                <div class="col-1 text-center no px-1">{{ $no }}</div>
                                <div class="col-2 text-center px-0" style="width: 12.499999995%;
                            flex: 0 0 12.499%;max-width: 12.499%;">{{ $student->student_id }}</div>
                                <div class="col-4 text-right px-1">{{ $student->student_name }}</div>
                                <div class="col-2 text-center px-1" style="width: 12.499999995%;
                            flex: 0 0 12.499%;max-width: 12.499%;">&nbsp;</div>
                                <div class="col-1 text-center px-1">&nbsp;</div>
                                <div class="col-1 text-center px-1">&nbsp;</div>
                                <div class="col-1 text-center px-1">&nbsp;</div>
                                <div class="col-1 text-center px-1">&nbsp;</div>
                            </div>
                                <?php $no += 1; ?>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>

    </div>
@endsection


@section('scripts')
    <script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>
    <script src="{{ asset('plugins/datatable/js/moment.min.js') }}"></script>
    <script src="{{ asset('plugins/datatable/js/dateTime.min.js') }}"></script>
    <script src="{{ asset('js/divjs.js') }}"></script>

    <script>
        $(document).ready(function () {
            let _students = $('.allPrintedStudents');
            let _excludedStudents = new Array();

            dataTable = $("#studentsTable").DataTable({
                "responsive": false,
                "lengthChange": false,
                "autoWidth": false,
                "searching": false,
                "paging": false,
                "ordering": false,
                "info": false,
                "deferRender": true,
                // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

                "oLanguage": {
                    "sSearch": "بحث ",
                    "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
                },
                "aoColumnDefs": [
                    { "bSortable": false, "targets": [0,3,4,5,6,7,8] },
                    { "sClass": "studentId", "aTargets": [1] },
                    { "sClass": "studentName", "aTargets": [2] }
                ],
            });

            $('#college, #section, #program, #batch, #bank, #admission, #constraint').each( function (){
                $(this).change(function (e) {
                    e.preventDefault();

                    $('#studentFilter').click();
                });
            });

            $('#printRevenuesBtn2').click(function(){
                let _no = 1;

                $('.excluded:checkbox:checked').each(function () {
                    _excludedStudents.push((this.checked ? $(this).val() : ""));
                });

                _students.each(function () {
                    if($.inArray($(this).data("id"), _excludedStudents) > -1) {
                        $($(this)).attr("hidden", true);
                    } else {
                        $(this).find(".no").html(_no);
                        _no++;
                    }
                });

                $('#printRevenuesModal').printElement();
            });

            $('.studentId').click(function (e) {
                e.preventDefault();

                _sortById = $(this).attr('aria-sort') == 'ascending' ? 'asc' : 'desc';
                _sortByName = null;

                $.ajax({
                    type: "POST",
                    url: "{{ route('sort.table.by') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        table_name: 'students',
                        sort_by_name: _sortByName,
                        sort_by_id: _sortById,
                    },
                    success: function (response) {
                        location.reload();
                    },
                    error: function (response) {
                        // console.log(response);
                    }
                });

                // console.log(" sortByName: " + _sortById + " sortByName: " + _sortByName);
            });

            $('.studentName').click(function (e) {
                e.preventDefault();

                _sortById = null;
                _sortByName = $(this).attr('aria-sort') == 'ascending' ? 'asc' : 'desc';

                $.ajax({
                    type: "POST",
                    url: "{{ route('sort.table.by') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        table_name: 'students',
                        sort_by_name: _sortByName,
                        sort_by_id: _sortById,
                    },
                    success: function (response) {
                        location.reload();
                    },
                    error: function (response) {
                        // console.log(response);
                    }
                });
            });

            $('.excluded').change(function (e) {
                e.preventDefault();
                let id = $(this).val();

                $.ajax({
                    type: "POST",
                    url: "{{ route('exclude.student') }}",
                    data: {
                        studentId: id,
                        _token: "{{ csrf_token() }}",
                    },
                    success: function (response) {
                    },
                    error: function (response) {
                        // console.log(response);
                    }
                });
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            $('#printRevenuesBtn').click(function(){
                const url = new URL("{{ route('print.exams.sheet') }}", window.location.origin);

                // optionally append filters or parameters
                // Pass filter values, not students
                url.searchParams.append('college_id', '{{ request()->get("college_id") }}');
                url.searchParams.append('batch_id', '{{ request()->get("batch_id") }}');
                url.searchParams.append('section_id', '{{ request()->get("section_id") }}');
                url.searchParams.append('program_id', '{{ request()->get("program_id") }}');
                {{--url.searchParams.append('students', {{ json_encode($students) }} );--}}

                window.open(url.toString(), '_blank');
            });
        });



        {{--document.getElementById('printRevenuesBtn').addEventListener('click', function () {--}}
        {{--    console.log('printRevenuesBtn');--}}
        {{--    const url = new URL("{{ route('attendance.print') }}", window.location.origin);--}}

        {{--    // optionally append filters or parameters--}}
        {{--    // url.searchParams.append('college_id', ...);--}}

        {{--    window.open(url.toString(), '_blank');--}}
        {{--});--}}
    </script>
@endsection
