<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">



    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">

    <link href="{{ asset('css/tailwind.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/flowbite.min.css') }}" rel="stylesheet" />
    
    <style>
        .login-logo {
            max-width: 138px;
        }

        .login-button {
            width: 150px;
            background-color: #4543dc;
            ;
        }

        .login-button:hover {
            background-color: #4543dc;
            ;
        }

        label {
            color: #4543dc;
            font-size: 15px;
            font-weight: 600;
        }

        input[type="email"],
        input[type="password"] {
            background-color: rgba(0, 0, 0, 0.1);
            border-radius: 6px;
        }
    </style>

</head>

<body dir="{{ App::isLocale('ar') ? 'rtl' : 'ltr' }}">
    <div id="app">
        <main class="py-4">
            <div class="container h-screen">

                <section>
                    <div class="col-md-12 py-2">
                        <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="uofs-logo" class="mx-auto">
                    </div>
                </section>

                <section class="bg-gray-50 dark:bg-gray-900">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf
                        <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto lg:py-0 mt-12">
                            <div
                                class="w-full bg-white rounded-lg shadow dark:border md:mt-0 sm:max-w-md xl:p-0 dark:bg-gray-800 dark:border-gray-700">
                                <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                                    <h1 class="text-xl font-bold leading-tight tracking-tight text-gray-900 md:text-2xl dark:text-white">
                                    </h1>
                                    <form class="space-y-4 md:space-y-6" action="#">
                                        <div>
                                            @error('email')
                                                <span class="alert text-sm text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                            <label for="email" class="block mb-2 text-sm font-medium dark:text-white">
                                                {{ __('login.email-address') }}
                                            </label>
                                            <input type="text" name="email" id="email" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="name@company.com" required="">
                                            
                                        </div>
                                        <div>
                                            <label for="password" class="block mb-2 text-sm font-medium dark:text-white">
                                                {{ __('login.password') }}
                                            </label>
                                            <input type="password" name="password" id="password" placeholder="••••••••" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"required="">

                                            @error('password')
                                                <span class="text-red-600 text-sm" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <div class="flex items-start">
                                                <div class="flex items-center h-5">
                                                    <input id="remember" aria-describedby="remember" type="checkbox" class="w-4 h-4 border border-gray-300 rounded bg-gray-50 focus:ring-3 focus:ring-primary-300 dark:bg-gray-700 dark:border-gray-600 dark:focus:ring-primary-600 dark:ring-offset-gray-800">
                                                </div>
                                                <div class="ml-3 text-sm">
                                                    <label for="remember" class="text-gray-500 dark:text-gray-300 mr-2" style="color: #4543dc;">تذكرني</label>
                                                </div>
                                            </div>
                                            <a href="#"
                                                class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500" style="color: #4543dc;">نسيت كلمة المرور?</a>
                                        </div>
                                        {{-- <button type="submit" class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"> --}}
                                        <button type="submit" class="bg-primary btn btn-primary w-full mb-3">
                                            {{ __('login.login') }}
                                        </button>
                                        {{-- <p class="text-sm font-light text-gray-500 dark:text-gray-400" style="color: #4543dc;">
                                            ليس لديك حساب بعد?
                                            <a href="#" class="font-medium text-primary-600 hover:underline dark:text-primary-500" style="color: rgb(42, 88, 150);">
                                                تسجيل جديد
                                            </a>
                                        </p> --}}
                                    </form>
                                </div>
                            </div>
                        </div>
                    </form>
                </section>
            </div>
        </main>
    </div>

    <!-- jQuery -->
    <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button)
    </script>

    <!-- DataTables  & Plugins -->
    <script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/vfs_fonts.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="{{ asset('js/flowbite.js') }}"></script>

</body>

</html>