@props([
    'name' => '',
    'id' => null,
    'label' => '',
    'accept' => '',
    'required' => false,
])

<div class="flex items-center justify-center gap-3 w-full">
    <!-- Label -->
    <div class="w-1/4 text-right font-medium field-label">
        {{ $label }}
    </div>

    <!-- File Input -->
    <div class="field-input shadow-xl w-1/2">
        <label for="{{ $id ?? $name }}" class="custom-file-label px-4 py-2 rounded bg-gray-100 border border-gray-300 text-gray-700 cursor-pointer hover:bg-gray-200">
            {{ $label }}
        </label>

        <input
            type="file"
            name="{{ $name }}"
            id="{{ $id ?? $name }}"
            @if($accept) accept="{{ $accept }}" @endif
            @if($required) required @endif
            {{ $attributes->merge([
                'class' => 'block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer focus:outline-none mt-1'
            ]) }}
        >

        @error($name)
        <div class="text-red-600 text-sm mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>
