@props([
    'label' => '',
    'name' => '',
    'options' => null,
    'selected' => false,
    'required' => false,
])

<div class="flex items-center gap-3 w-full">
    <!-- Label -->
    <div class="w-1/4 text-right font-medium field-label">
        {{ $label }}
    </div>

    <!-- Radio buttons -->
    <div class="flex items-center justify-center field-input shadow-xl" style="width: 240px; height: 40px;">
        <div class="flex gap-6">
            @foreach($options as $value => $text)
                <label for="{{ $name }}-{{ $value }}" class="flex items-center cursor-pointer">
                    <input
                        id="{{ $name }}-{{ $value }}"
                        type="radio"
                        value="{{ $value }}"
                        name="{{ $name }}"
                        class="w-4 h-4 text-blue-600 border-gray-300 focus:ring focus:ring-blue-500"
                        {{ (string) old($name, $selected) === (string) $value ? 'checked' : '' }}
                    >
                    <span class="mx-2 text-sm font-medium field-radio-input">{{ $text }}</span>
                </label>
            @endforeach
        </div>

        @error($name)
        <div class="text-red-600 text-sm mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>
