@props([
    'name' => '',
    'id' => null,
    'options' => [],
    'selected' => null,
    'required' => false,
    'label' => '',
])

<div class="flex items-center gap-3 w-full">
    <!-- Label -->
    <div class="w-1/4 text-right font-medium field-label">
        {{ $label }}
    </div>

    <!-- Select -->
    <div class="field-input shadow-xl" style="width: 240px; color: #ced4da">
        <select
            name="{{ $name }}"
            id="{{ $id ?? $name }}"
            @if($required) required @endif
            {{ $attributes->merge(['class' => 'rounded-md shadow-sm w-full border-gray-300 focus:ring focus:ring-indigo-200 focus:border-indigo-500']) }}
        >
            <option value="">-- اختر --</option>
            @foreach ($options as $option)
                <option value="{{ $option->id }}" {{ (string) old($name, $selected) === (string) $option->id ? 'selected' : '' }}>
                    @if( isset($option->start) )
                        {{ $option->start .' - '. $option->end}}
                    @endif

                    @if( isset($option->name) )
                        {{ $option->name }}
                    @endif

                    @if( isset($option->value) )
                        {{ $option->value }}
                    @endif
                </option>
            @endforeach
        </select>

        @error($name)
        <div class="text-danger small mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>
