@props([
    'name' => '',
    'id' => null,
    'value' => '',
    'label' => '',
    'placeholder' => '',
    'rows' => 2,
    'required' => false,
])

<div class="flex items-start justify-center gap-3 w-full">
    <!-- Label -->
    <div class="w-1/12 text-right font-medium field-label my-auto text-center">
        {{ $label }}
    </div>

    <!-- Textarea -->
    <div class="field-input w-1/2">
        <textarea
            name="{{ $name }}"
            id="{{ $id }}"
            rows="{{ $rows }}"
            placeholder="{{ $label }}"
            {{ $attributes->merge(['class' => 'form-textarea rounded-md shadow-sm w-full border-gray-300 focus:ring focus:ring-indigo-200 focus:border-indigo-500']) }}
        >{{ old($name, $value) }}</textarea>

        @error($name)
        <div class="text-danger small mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>
