@props([
    'type' => 'text',
    'name' => '',
    'id' => null,
    'value' => '',
    'placeholder' => '',
    'required' => false,
])

@php
    $finalValue = old($name, $value);
    if (is_array($finalValue)) {
        $finalValue = implode(', ', $finalValue);
    }
@endphp
<div class="flex items-center gap-3 w-full">
    <div class="w-1/4 text-right font-medium field-label">
        {{ $label }}
    </div>
    <div class="field-input shadow-xl">
        <input
            type="{{ $type }}"
            name="{{ $name }}"
            id="{{ $id ?? $name }}"
            value="{{ old($name, $value) }}"
            placeholder="{{ $placeholder }}"
            @if($required) required @endif
            {{ $attributes->merge(['class' => 'form-input rounded-md shadow-sm w-full']) }}
        >

        @error($name)
        <div class="text-danger small mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>

