@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    input:read-only {
        background-color: rgba(0, 0, 0, 0.1);
    }
</style>

@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('fee.add-student-fee') }}
                <br />
                {{ $student->student_name}}
            </h3>
        </div>
        <div class="p-6 space-y-6">
            <form method="post" action="{{ route('fee.store') }}" enctype="multipart/form-data" id="studentForm">
                @csrf
                <input type="hidden" name="student_name" value="{{ $student->student_name }}">
                <input type="hidden" name="studentId" value="{{ $student->id }}">
                <div class="p-6 space-y-6">
                    {{-- <div class="row">
                        <div class="col-2 pt-2">نوع الدفعية</div>
                        <div class="col-4">
                            <select id="feeType" name="fee_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0">إختار نوع الدفعية</option>
                                @if ( isset($feeTypes) )
                                @foreach ($feeTypes as $feeType)
                                <option value="{{ $feeType->id }}">
                                    {{ $feeType->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2"></div>
                        <div class="col-4"></div>
                    </div> --}}

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.id') }}</div>
                        <div class="col-4">
                            <input type="text" name="student_id" id="studentId"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="{{ $student->student_id }}" readonly placeholder="{{ __('student.id') }}">
                        </div>

                        <div class="col-2 pt-2 registrationFee">{{ __('fee.registration-fees') }}</div>
                        <div class="col-4 registrationFee">
                            <input type="text" name="registration_fees"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.registration-fees') }}"
                                value="{{ $student->registration_fees }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.serial_number') }}</div>
                        <div class="col-4">
                            <input type="text" name="student_number" id="studentNumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="{{ $student->student_number }}" readonly
                                placeholder="{{ __('student.serial_number') }}">
                        </div>

                        <div class="col-2 pt-2 studyFee">{{ __('fee.tuition-fees') }}</div>
                        <div class="col-4 studyFee">
                            <input type="text" name="study_fees"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.tuition-fees') }}" value="{{ $student->program_fees }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.national-id') }}</div>
                        <div class="col-4">
                            <input type="text" name="national_id" id="nationalId"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="{{ $student->national_id }}" readonly
                                placeholder="{{ __('student.national-id') }}">
                        </div>

                        <div class="col-2 pt-2 insuranceFee">{{ __('fee.insurance-fees') }}</div>
                        <div class="col-4 insuranceFee">
                            <input type="text" name="insurance_fees"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.insurance-fees') }}" value="{{ $student->insurance_fees }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('fee.payment-amount') }}</div>
                        <div class="col-4">
                            <input type="text" name="payment_amount"
                                class="paymentAmount bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                readonly placeholder="{{ __('fee.payment-amount') }}">
                        </div>

                        <div class="col-2 pt-2 discount">{{ __('fee.discount') }}</div>
                        <div class="col-4 discount">
                            <input type="text" name="discount"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.discount') }}" value="{{ $student->discount }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2 dueAmount">{{ __('fee.due-amount') }}</div>
                        <div class="col-4 dueAmount">
                            <input type="text" name="due_amount"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.due-amount') }}">
                        </div>

                        <div class="col-2 pt-2">نوع العملة</div>
                        <div class="col-4">
                            <select id="paymentCurrency" name="payment_currency"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>

                                <option value="0" disabled>إختار نوع العملة</option>
                                <option value="SDG" selected>جنية سوداني</option>
                                <option value="USD">دولار امريكي</option>

                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2 dueAmount"></div>
                        <div class="col-4 dueAmount"></div>

                        <div class="col-2 pt-2">مقدار الدمغة</div>
                        <div class="col-4">
                            <input type="text" name="stamp"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="50">
                        </div>
                    </div>

                    <div class="row"></div>
                    <hr>
                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.semester') }}</div>
                        <div class="col-4">
                            <select id="semester" name="semester_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0">{{ __('student.choose-semester') }}</option>
                                @if ( isset($semesters) )
                                @foreach ($semesters as $semester)
                                <option value="{{ $semester->id }}">
                                    {{ $semester->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">عدد الدفعيات</div>
                        <div class="col-4">
                            <input type="text" name="payments_number" id="paymentsNumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="عدد الدفعيات" value="0" readonly>
                        </div>
                    </div>

                    <div class="row registrationDetails">
                        <div class="col-2 pt-2">{{ __('settings.registration-start') }}</div>
                        <div class="col-4">
                            <input type="date" name="registration_start" id="registrationStart"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                        </div>

                        <div class="col-2 pt-2">{{ __('settings.registration-end') }}</div>
                        <div class="col-4">
                            <input type="date" name="registration_end" id="registrationEnd"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        </div>
                    </div>
                </div>

                <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600">
                    <button type="submit"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        {{ __('student.add') }}
                    </button>
                    <a href="{{ route('fee.index') }}" type="button"
                        class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                        {{ __('student.cancel') }}
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        $("#addStudentForm").validate({
            rules: {
                student_name: "required",
                program_fees: {
                    required: true,
                    number: true
                },
                registration_fees: {
                    required: true,
                    number: true
                },
                national_id: {
                    required: true,
                    number: true,
                    minlength: 8,
                },
                registration_start: "required",
                registration_end: "required",
            },
            messages: {
                student_name: ".هذا الحقل مطلوب",
                program_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                registration_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                national_id: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                    minlength: "يجب ان لايقل عن ٨ خانات",
                },
                registration_start: {
                    required: ".هذا الحقل مطلوب",
                },
                registration_end: {
                    required: ".هذا الحقل مطلوب",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                // $(input).next('img').attr('src', e.target.result);
                $(input).next('img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]); // convert to base64 string
        }
    }


    $("#studentImageInput").change(function() {
        // $('#studentImageNoImage').css('display','none');
        // $('#studentImageOld').css('display','none');
        $('#studentImageLabel').css('display','none');
        $('#studentImage').css('display','block');
        readURL(this);
    });

    // custmize invalid input
    document.addEventListener("DOMContentLoaded", function() {
        var elements = document.getElementsByTagName("INPUT");
        for (var i = 0; i < elements.length; i++) {
            elements[i].oninvalid = function(e) {
                e.target.setCustomValidity("");
                if (!e.target.validity.valid) {
                    e.target.setCustomValidity("هذا الحقل مطلوب");
                }
            };
            elements[i].oninput = function(e) {
                e.target.setCustomValidity("");
            };
        }
    });

    $(document).ready(function () {
        $('#fee').change(function () {
            let parent = $('#fee').find(":selected").val();
            if (parent == 1) {
                $('#certificates').css('display', 'flex');
                $('#tuition').css('display', 'none');
                $('#others').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            } else if(parent == 2){
                $('#tuition').css('display', 'flex');
                $('#certificates').css('display', 'none');
                $('#others').css('display', 'none');
                $('#feeAmount').css('display', 'none');
            } else if(parent == 3){
                $('#others').css('display', 'flex');
                $('#certificates').css('display', 'none');
                $('#tuition').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            } else{
                $('#tuition').css('display', 'none');
                $('#certificates').css('display', 'none');
                $('#others').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            }
        });

        $('#semester').change(function (e) {
            e.preventDefault();

            let semesterId = $(this).find(":selected").val();
            let studentId = $('#studentId').val();
            $.ajax({
                type: "get",
                url: "{{ route('semester.payments.number') }}",
                data: {
                    semester_id: semesterId,
                    student_id: studentId,
                },

                success: function (response) {
                    $('#paymentsNumber').val(response);
                }
            });
        });

        $('#feeType').change(function (e) {
            e.preventDefault();

            let feeTypeId = $(this).find(":selected").val();

            $('.registrationFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.studyFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.insuranceFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.discount').attr('hidden', feeTypeId > 1 ? true : false);
            $('.dueAmount').attr('hidden', feeTypeId > 1 ? true : false);
            $('.paymentAmount').attr('readonly', feeTypeId > 1 ? false : true);
            $('.registrationDetails').attr('hidden', feeTypeId > 1 ? true : false);
        });
    });
</script>
@endsection
