@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    input:read-only {
        background-color: rgba(0, 0, 0, 0.1);
    }
</style>
@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white text-center">
                {{ __('fee.edit-student-fee') }}
            </h3>
        </div>
        <div class="p-6 space-y-6">
            <form method="post" action="{{ route('fee.update', $studentFee->payment_reference) }}" enctype="multipart/form-data" id="studentFeeForm">
                @csrf
                @method('put')
                <input type="hidden" name="payment_reference" value="{{ $studentFee->payment_reference }}">
                <input type="hidden" name="std_id" value="{{ $student->id ?? -1  }}">
                <input type="hidden" name="fee_type_id" value="{{ $studentFee->fee_type_id ?? -1  }}">

                <div class="p-6 space-y-1">
                    {{-- <div class="row">
                        <div class="col-2 pt-2">نوع الدفعية</div>
                        <div class="col-4">
                            <select id="feeType" name="fee_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0">إختار نوع الدفعية</option>
                                @if ( isset($feeTypes) )
                                @foreach ($feeTypes as $feeType)
                                <option value="{{ $feeType->id }}" {{ $studentFee->fee_type_id == $feeType->id ? 'selected' : ''}}>
                                    {{ $feeType->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>
                    </div> --}}
                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('student.name') }}"
                                name="student_name"
                                id="studentName"
                                :value="$studentFee->student_name ?? ''"
                                :placeholder="__('student.name')"
                                required
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('fee.registration-fees') }}"
                                name="registration_fees"
                                id="registrationFees"
                                :value="$studentFee->registration_fees ?? 0.00"
                                :placeholder="__('fee.registration-fees')"
                                required
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{  __('student.id') }}"
                                name="student_id"
                                id="studentId"
                                :value="$studentFee->student_id ?? ''"
                                :placeholder="__('student.id')"
                                required
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('fee.tuition-fees') }}"
                                name="study_fees"
                                id="studyFees"
                                :value="$studentFee->study_fees ?? 0.00"
                                :placeholder="__('fee.tuition-fees')"
                                required
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('student.serial_number') }}"
                                name="student_number"
                                id="studentNumber"
                                :value="$studentFee->student_number ?? ''"
                                :placeholder="__('student.serial_number')"
                                required
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('fee.insurance-fees') }}"
                                name="insurance_fees"
                                id="insuranceFees"
                                :value="$studentFee->insurance_fees ?? 0.00"
                                :placeholder="__('fee.insurance-fees')"
                                required
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field-select
                                label="{{ __('student.semester') }}"
                                name="semester_id"
                                id="semester"
                                :options="$semesters"
                                :selected="$studentFee->semester_id"
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                label="{{  __('fee.discount') }}"
                                name="discount"
                                id="discount"
                                :value="$studentFee->discount ?? 0.00"
                                :placeholder=" __('fee.discount')"
                                required
                            />
                        </div>
                    </div>

{{--                    <div class="row">--}}
{{--                        <div class="col-2 pt-2">{{ __('student.semester') }}</div>--}}
{{--                        <div class="col-4">--}}
{{--                            <select id="semester" name="semester_id"--}}
{{--                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"--}}
{{--                                required>--}}
{{--                                <option value="0">{{ __('student.choose-semester') }}</option>--}}
{{--                                @if ( isset($semesters) )--}}
{{--                                @foreach ($semesters as $semester)--}}
{{--                                <option value="{{ $semester->id }}" {{ $studentFee->semester_id == $semester->id ? 'selected' : ''}}>--}}
{{--                                    {{ $semester->name }}--}}
{{--                                </option>--}}
{{--                                @endforeach--}}
{{--                                @endif--}}
{{--                            </select>--}}
{{--                        </div>--}}

{{--                        <div class="col-2 pt-2 discount">{{ __('fee.discount') }}</div>--}}
{{--                        <div class="col-4 discount">--}}
{{--                            <input type="text" name="discount" placeholder="{{ __('fee.discount') }}"--}}
{{--                            value="{{ $studentFee->discount}}">--}}
{{--                        </div>--}}
{{--                    </div>--}}

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('student.national-id') }}"
                                name="national_id"
                                id="nationalId"
                                :value="$studentFee->national_id ?? ''"
                                :placeholder="__('student.national-id')"
                                required
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                type="date"
                                name="registration_end"
                                id="registrationEnd"
                                :value="Carbon\Carbon::parse($studentFee->end)->format('Y-m-d')"
                                label="{{ __('settings.registration-end') }}"
                                placeholder="{{ __('settings.registration-end') }}"
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('student.national-id') }}"
                                name="national_id"
                                id="nationalId"
                                :value="$studentFee->national_id ?? ''"
                                :placeholder="__('student.national-id')"
                                required
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                type="date"
                                name="registration_end"
                                id="registrationEnd"
                                :value="Carbon\Carbon::parse($studentFee->end)->format('Y-m-d')"
                                label="{{ __('settings.registration-end') }}"
                                placeholder="{{ __('settings.registration-end') }}"
                            />
                        </div>
                    </div>

                    <div class="row"></div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                type="date"
                                name="start"
                                id="start"
                                :value="Carbon\Carbon::parse($studentFee->start)->format('Y-m-d')"
                                label="{{ __('settings.registration-start') }}"
                                placeholder="{{ __('settings.registration-start') }}"
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('fee.due-amount') }}"
                                name="due_amount"
                                id="dueAmount"
                                :value="$studentFee->due_amount ?? ''"
                                :placeholder="__('fee.due-amount')"
                                required
                                readonly
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                label="{{ __('fee.fee-amount') }}"
                                name="payment_amount"
                                id="paymentAmount"
                                class="paymentAmount"
                                :value="$studentFee->payment_amount ?? ''"
                                :placeholder="__('fee.fee-amount')"
                                required
                                readonly
                            />
                        </div>

                        <div class="w-1/3">
                            <x-input-field-select
                                label="نوع العملة"
                                name="accommodation_type"
                                id="accommodationType"
                                :options="[
                                            (object)['id' => 'SDG', 'name' => 'جنية سوداني'],
                                            (object)['id' => 'USD', 'name' => 'دولار امريكي'],
                                        ]"
                                :selected="$studentFee->payment_currency"
                            >
                                <option value="0" disabled>إختار نوع السكن</option>
                            </x-input-field-select>
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3"></div>

                        <div class="w-1/3">
                            <x-input-field
                                name="stamp"
                                id="stamp"
                                :value="$studentFee->stamp ?? 0.00"
                                label="مقدار الدمغة"
                                placeholder="0.00"
                            />
                        </div>
                    </div>

                    <div class="flex py-1 justify-center gap-2">
                        <div class="w-1/3">
                            <x-input-field
                                name="installments"
                                id="installments"
                                :value="$studentFee->instalments?->count() ?? 0"
                                label="عدد الاقساط"
                                placeholder="0"
                                readonly
                            />
                        </div>

                        <div class="w-1/3"></div>
                    </div>

                    @if($studentFee->instalments?->count() > 0)
{{--                        @foreach ($studentFee->instalments as $instalment)--}}
{{--                            <div class="flex py-1 justify-center gap-2">--}}
{{--                                <div class="w-1/4">--}}
{{--                                    <x-input-field--}}
{{--                                        name="instalment"--}}
{{--                                        id="instalment"--}}
{{--                                        :value="$instalment->amount ?? 0.00"--}}
{{--                                        label="مقدار الاقساط"--}}
{{--                                        placeholder="0.00"--}}
{{--                                        style="width: 100px"--}}
{{--                                    />--}}
{{--                                </div>--}}

{{--                                <div class="w-1/4">--}}
{{--                                    <x-input-field--}}
{{--                                        name="instalment"--}}
{{--                                        id="instalment"--}}
{{--                                        :value="$instalment->amount ?? 0.00"--}}
{{--                                        label="مقدار الاقساط"--}}
{{--                                        placeholder="0.00"--}}
{{--                                        style="width: 100px"--}}
{{--                                    />--}}
{{--                                </div>--}}

{{--                                <div class="w-1/4">--}}
{{--                                    <x-input-field--}}
{{--                                        name="instalment"--}}
{{--                                        id="instalment"--}}
{{--                                        :value="$instalment->amount ?? 0.00"--}}
{{--                                        label="مقدار الاقساط"--}}
{{--                                        placeholder="0.00"--}}
{{--                                        style="width: 100px"--}}
{{--                                    />--}}
{{--                                </div>--}}

{{--                                <div class="w-1/4">--}}
{{--                                    @if($instalment->is_paid)--}}
{{--                                        <span>تم الدفع</span>--}}
{{--                                    @else--}}
{{--                                        <span>لم يتم الدفع</span>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        @endforeach--}}

                        <table class="min-w-full border border-gray-300">
                            <thead>
                            <tr class="bg-gray-100">
                                <th class="border px-2 py-1">مقدار القسط</th>
                                <th class="border px-2 py-1">تاريخ الاستحقاق</th>
                                <th class="border px-2 py-1">تاريخ الدفع</th>
                                <th class="border px-2 py-1">الحالة</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($studentFee->instalments as $instalment)
                                <tr class="text-center">
                                    <td class="border px-2 py-1">
                                        <x-input-field
                                            label=""
                                            name="instalment_amount[]"
                                            id="instalment_amount_{{ $loop->index }}"
                                            :value="$instalment->amount ?? 0.00"
                                            placeholder="0.00"
                                            style="width: 100px"
                                        />
{{--                                        <x-input-field--}}
{{--                                            name="instalment"--}}
{{--                                            id="instalment"--}}
{{--                                            :value="$instalment->amount ?? 0.00"--}}
{{--                                            label="مقدار الاقساط"--}}
{{--                                            placeholder="0.00"--}}
{{--                                            style="width: 100px"--}}
{{--                                        />--}}
                                    </td>

                                    <td class="border px-2 py-1">
                                        <x-input-field
                                            label=""
                                            name="instalment_due[]"
                                            id="instalment_due_{{ $loop->index }}"
                                            :value="$instalment->due_date ?? ''"
                                            placeholder="YYYY-MM-DD"
                                            style="width: 120px"
                                        />
                                    </td>

                                    <td class="border px-2 py-1">
                                        <x-input-field
                                            label=""
                                            name="instalment_paid[]"
                                            id="instalment_paid_{{ $loop->index }}"
                                            :value="$instalment->paid_date ?? ''"
                                            placeholder="YYYY-MM-DD"
                                            style="width: 120px"
                                        />
                                    </td>

                                    <td class="border px-2 py-1">
                                        @if($instalment->is_paid)
                                            <span class="text-green-600 font-medium">تم الدفع</span>
                                        @else
                                            <span class="text-red-600 font-medium">لم يتم الدفع</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                    @endif

                </div>

                <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600">
                    <button type="submit"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        {{ __('student.save') }}
                    </button>
                    <a href="{{ route('fee.index') }}" type="button"
                        class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                        {{ __('student.cancel') }}
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>


<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        $("#addStudentForm").validate({
            rules: {
                student_name: "required",
                program_fees: {
                    required: true,
                    number: true
                },
                registration_fees: {
                    required: true,
                    number: true
                },
                national_id: {
                    required: true,
                    number: true,
                    minlength: 8,
                },
            },
            messages: {
                student_name: ".هذا الحقل مطلوب",
                program_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                registration_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                national_id: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                    minlength: "يجب ان لايقل عن ٨ خانات",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                // $(input).next('img').attr('src', e.target.result);
                $(input).next('img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]); // convert to base64 string
        }
    }


    $("#studentImageInput").change(function() {
        alert('changed');
        // $('#studentImageNoImage').css('display','none');
        // $('#studentImageOld').css('display','none');
        $('#studentImageLabel').css('display','none');
        $('#studentImage').css('display','block');
        readURL(this);
    });

    // custmize invalid input
    document.addEventListener("DOMContentLoaded", function() {
        var elements = document.getElementsByTagName("INPUT");
        for (var i = 0; i < elements.length; i++) {
            elements[i].oninvalid = function(e) {
                e.target.setCustomValidity("");
                if (!e.target.validity.valid) {
                    e.target.setCustomValidity("هذا الحقل مطلوب");
                }
            };
            elements[i].oninput = function(e) {
                e.target.setCustomValidity("");
            };
        }
    });

    $(document).ready(function () {
        $('#fee').change(function () {
            let parent = $('#fee').find(":selected").val();
            if (parent == 1) {
                $('#certificates').css('display', 'flex');
                $('#tuition').css('display', 'none');
                $('#others').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            } else if(parent == 2){
                $('#tuition').css('display', 'flex');
                $('#certificates').css('display', 'none');
                $('#others').css('display', 'none');

                $('#tuitionFee').css('display', 'flex');
                $('#feeAmount').css('display', 'none');
            } else if(parent == 3){
                $('#others').css('display', 'flex');
                $('#certificates').css('display', 'none');
                $('#tuition').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            } else{
                $('#tuition').css('display', 'none');
                $('#certificates').css('display', 'none');
                $('#others').css('display', 'none');

                $('#tuitionFee').css('display', 'none');
                $('#feeAmount').css('display', 'flex');
            }
        });


        let feeTypeId = {{ $studentFee->fee_type_id }};

        $('.registrationFee').attr('hidden', feeTypeId > 1 ? true : false);
        $('.studyFee').attr('hidden', feeTypeId > 1 ? true : false);
        $('.insuranceFee').attr('hidden', feeTypeId > 1 ? true : false);
        $('.discount').attr('hidden', feeTypeId > 1 ? true : false);
        $('.dueAmount').attr('hidden', feeTypeId > 1 ? true : false);
        $('.paymentAmount').attr('readonly', feeTypeId > 1 ? false : true);
        $('.registrationDetails').attr('hidden', feeTypeId > 1 ? true : false);


        $('#feeType').change(function (e) {
            e.preventDefault();

            let feeTypeId = $(this).find(":selected").val();

            $('.registrationFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.studyFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.insuranceFee').attr('hidden', feeTypeId > 1 ? true : false);
            $('.discount').attr('hidden', feeTypeId > 1 ? true : false);
            $('.dueAmount').attr('hidden', feeTypeId > 1 ? true : false);
            $('.paymentAmount').attr('readonly', feeTypeId > 1 ? false : true);
            $('.registrationDetails').attr('hidden', feeTypeId > 1 ? true : false);
        });
    });
</script>
@endsection
