@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    tfoot{
        background-color:#36304a !important;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')

<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('home.students') }}
                </div>
                <div class="card-body">
                    @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                    @endif

                    <!-- filter -->
                    @include('layouts.filter')

                    <div id="studentsListTable" class="mt-4">
                        <table class="table" id="studentsTable2" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.section') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.show-students-fees') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if ( isset($students) )
                                <?php $no = 1;?>
                                @foreach ($students as $student)
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <th scope="row" class="py-2 text-center">
                                        <?= $no++; ?>
                                    </th>
                                    <td class="py-2 text-center">
                                        {{ $student->student_id }}
                                    </td>
                                    <td class="py-2 text-right">
                                        {{ $student->student_name }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ isset($student->section) ? $student->section->name : __('home.not-set') }}
                                    </td>

                                    <td class="py-2 text-center">
                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full"
                                            href="{{ route('fee.show', $student->id) }}" style="background-color: #36304a">
                                            <i class="fa fa-eye" aria-hidden="true"></i>
                                            {{ __('fee.student-fees') }}
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                                @else
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <td class="py-2 text-center" colspan="7">
                                        {{ __('no-students') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.section') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.show-students-fees') }}
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $students->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });

    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });
        // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        $(".constraint-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-class-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-year").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

    }); // End of $(document).ready
</script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });
    });
</script>
@endsection
