@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<link rel="stylesheet" href="{{ asset('css/custom-style.css') }}">
<style>
    tfoot {
        background-color: #36304a !important;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled) {
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')

<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    الدفعيات الأخرى

                    {{-- <a href="{{ route('other-fee.create') }}"> --}}
                        <a data-modal-target="createFeeModal" data-modal-toggle="createFeeModal">
                            <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                                <button type="button" class="custom-primary-btn text-white  font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2">
                                    <i class="fa fa-user-plus" aria-hidden="true"></i>
                                    {{ __('fee.add-new-fee') }}
                                </button>
                            </div>
                        </a>
                </div>
                <div class="card-body">
                    @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                    @endif

                    <div id="studentsListTable" class="mt-4">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        اسم الشخص
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم هاتف الشخص
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع الدفعية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        المبلغ
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم الدفعية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        تاريخ الإنشاء
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الإجراءات
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if ( isset($fees) )
                                <?php $no = 1;?>
                                @foreach ($fees as $fee)
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <th scope="row" class="py-2 text-center">
                                        <?= $no++; ?>
                                    </th>
                                    <td class="py-2 text-center">
                                        {{ $fee->name ?? '' }}
                                    </td>
                                    <td class="py-2 text-right">
                                        {{ $fee->phone_number ?? '' }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $fee->feeType->name ?? '' }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $fee->amount ?? 0.00 }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $fee->payment_currency ?? 0.00 }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $fee->reference ?? '' }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $fee->created_at ?? '' }}
                                    </td>

                                    @if (auth()->user()->hasRole('admin') || auth()->user()->hasRole('registrar'))
                                    @if ($fee->is_paid == 0)
                                    <td class="py-2 text-center">
                                        <a class="editFee" data-id="{{ $fee->id }}">
                                            <i class="fas fa-edit text-primary"></i>
                                        </a>
                                        {{-- <button type="button" class="editFee" data-id="{{ $fee->id }}"
                                            data-modal-target="editFeeModal" data-modal-toggle="editFeeModal">
                                            <i class="fas fa-edit text-primary"></i>
                                        </button> --}}

                                        <button type="button" class="deleteFee" data-id="{{ $fee->id }}">
                                            <i class="fas fa-trash-alt text-danger"></i>
                                        </button>
                                    </td>
                                    @else
                                    <td class="py-2 text-center">-</td>
                                    @endif
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <td class="py-2 text-center" colspan="7">
                                        {{ __('no-students') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        اسم الشخص
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم هاتف الشخص
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع الدفعية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        المبلغ
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم الدفعية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        تاريخ الإنشاء
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الإجراءات
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $fees->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- modals -->
<!-- Create Fee Modal -->
<div id="createFeeModal" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full max-w-6xl md:h-auto">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-center p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    انشاء دفعية جديدة
                </h3>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <form action="{{ route('other-fee.store') }}" method="post" id="createFeeForm">
                    @csrf
                    <div class="row mb-2">
                        <div class="col-2 pt-2">إسم الشخص</div>
                        <div class="col-4">
                            <input type="text" name="name"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="إسم الشخص">
                        </div>

                        <div class="col-2 pt-2">رقم الهاتف</div>
                        <div class="col-4">
                            <input type="text" name="phone_number"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="رقم الهاتف">
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-2 pt-2">نوع الدفعية</div>
                        <div class="col-4">
                            <select id="type" name="fee_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0" selected disabled>إختار نوع الدفعية</option>
                                @if ( isset($feeTypes) )
                                @foreach ($feeTypes as $feeType)
                                <option value="{{ $feeType->id }}">
                                    {{ $feeType->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">المبلغ</div>
                        <div class="col-4">
                            <input type="number" name="amount"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="المبلغ">
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-2 pt-2">نوع العملة</div>
                        <div class="col-4">
                            <select id="paymentCurrency" name="payment_currency"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>

                                <option value="0" disabled>إختار نوع العملة</option>
                                <option value="SDG" selected>جنية سوداني</option>
                                <option value="USD">دولار امريكي</option>

                            </select>
                        </div>

                        <div class="col-2 pt-2">رقم الدفعية</div>
                        <div class="col-4">
                            <input type="text" name="reference"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="{{ " 117".time() }}" placeholder="رقم الدفعية" readonly>
                            <!-- (117) represents char (O) for Other in OCT	-->
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-2 pt-2"></div>
                        <div class="col-4"></div>

                        <div class="col-2 pt-2">مقدار الدمغة</div>
                        <div class="col-4">
                            <input type="text" name="stamp"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="50.00">
                        </div>
                    </div>
                </form>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button data-modal-hide="createFeeModal" type="submit" id="submitCreateFee"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    حفظ
                </button>
                <button data-modal-hide="createFeeModal" type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600 mx-2">
                    الغاء
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Fee Modal -->
<div class="modal fade" id="editFeeModal" tabindex="-1" role="dialog" aria-labelledby="editFeeModalTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered max-w-6xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title mx-auto text-xl font-semibold text-gray-900 dark:text-white"
                    id="editFeeModalTitle">
                    تعديل دفعية
                </h3>
            </div>
            <div class="modal-body">
                <form action="{{ route('other-fee.update', $fee->id ?? 0) }}" method="post" id="editFeeForm">
                    @csrf
                    @method('put')
                    <input type="hidden" name="id" id="editId">

                    <div class="row mb-2">
                        <div class="col-2 pt-2">إسم الشخص</div>
                        <div class="col-4">
                            <input type="text" name="name" id="editName"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="إسم الشخص">
                        </div>

                        <div class="col-2 pt-2">رقم الهاتف</div>
                        <div class="col-4">
                            <input type="text" name="phone_number" id="editPhoneNumber"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="رقم الهاتف">
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-2 pt-2">نوع الدفعية</div>
                        <div class="col-4">
                            <select id="editFeeType" name="fee_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0" selected disabled>إختار نوع الدفعية</option>
                                @if ( isset($feeTypes) )
                                @foreach ($feeTypes as $feeType)
                                <option value="{{ $feeType->id }}">
                                    {{ $feeType->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">المبلغ</div>
                        <div class="col-4">
                            <input type="text" name="amount" id="editAmount"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="المبلغ">
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-2 pt-2">نوع العملة</div>
                        <div class="col-4">
                            <select id="paymentCurrency" name="payment_currency"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>

                                <option value="0" disabled>إختار نوع العملة</option>
                                <option value="SDG">جنية سوداني</option>
                                <option value="USD">دولار امريكي</option>

                            </select>
                        </div>

                        <div class="col-2 pt-2">رقم الدفعية</div>
                        <div class="col-4">
                            <input type="text" name="reference" id="editReference"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="رقم الدفعية" readonly>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-2 pt-2"></div>
                        <div class="col-4"></div>

                        <div class="col-2 pt-2">مقدار الدمغة</div>
                        <div class="col-4">
                            <input type="text" name="stamp" id="editStamp"
                                class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="50.00">
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button data-bs-dismiss="modal" type="button" id="submitEditFee"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    تعديل
                </button>
                <button  type="button" data-bs-dismiss="modal"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600 mx-2">
                    الغاء
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });

    $(document).ready(function () {
        dataTable = $("#studentsTable2").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });
        // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        $(".constraint-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-class-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-year").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

    }); // End of $(document).ready
</script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });

        $('#submitCreateFee').click(function (e) {
            e.preventDefault();

            $('#createFeeForm').submit();
        });

        $("#studentsTable").on("click", ".editFee", function (e) {
            e.preventDefault()

            $.ajax({
                type: "GET",
                url: "{{ url('other-fee') }}" + "/" + $(this).data('id'),
                success: function (response) {
                    $('#editId').val(response.id);
                    $('#editName').val(response.name);
                    $('#editPhoneNumber').val(response.phone_number);
                    $('#editAmount').val(response.amount);
                    $('#editReference').val(response.reference);
                    $('#editStamp').val(response.stamp ? response.stamp : "50.00");
                    $(`#editFeeType option[value=${response.fee_type_id}]`).attr('selected','selected');
                    $(`#paymentCurrency option[value=${response.payment_currency}]`).attr('selected','selected');

                }
            });

            $('#editFeeModal').modal('show');
        });

        $('#submitEditFee').click(function (e) {
            e.preventDefault();

            $('#editFeeForm').submit();
        });

        $("#studentsTable").on("click", ".deleteFee", function (e) {

            Swal.fire({
                icon: 'warning',
                title: 'عملية حذف!',
                text: 'هل تريد حذف هذه الدفعية فعلا؟',
                showDenyButton: true,
                confirmButtonText: 'نعم',
                denyButtonText: `لا`,
            }).then((result) => {

                if (result.isConfirmed) {
                    var token = $("meta[name='csrf-token']").attr("content");

                    $.ajax({
                        url: "{{ url('other-fee') }}" + "/" + $(this).data('id'),
                        type: 'DELETE',
                        data: {
                            "_token": token,
                        },
                        success: function (data){
                            console.log(data);
                            Swal.fire(
                                'عملية ناجحة!',
                                'تم حذف الدفعية بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
