@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
@endsection

@section('content')

<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('fee.fees') .' ال'. __('fee.student') .' : '. $studentName }}
                    <a href="{{ route('fee.create.student', $studentId) }}">
                        <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                            <button type="button"
                                class="custom-primary-btn text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                                <i class="fa fa-user-plus" aria-hidden="true"></i>
                                {{ __('fee.add-new-fee') }}
                            </button>
                        </div>
                    </a>
                </div>


                <div class="card-body">
                    @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                    @endif

                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr class="table100-head">
                                    <th class="text-xs">
                                        {{ __('fee.code') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.note') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.amount') }}
                                    </th>
                                    <th class="text-xs">
                                        نوع العملة
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.paid') }}
                                    </th>
                                    {{-- <th class="text-xs">
                                        {{ __('fee.penalty') }}
                                    </th> --}}
                                    <th class="text-xs">
                                        {{ __('fee.created-at') }}
                                    </th>
                                    @if (auth()->user()->hasRole('admin') || auth()->user()->hasRole('registrar'))
                                        <th class="text-xs">
                                            {{ __('fee.actions') }}
                                        </th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-500">
                                @if ($studentFees)
                                @foreach ($studentFees as $studentFee)
                                <tr class="whitespace-nowrap">
                                    <td class="text-sm text-center text-black" style="direction: ltr;">
                                        {{ $studentFee->payment_reference }}
                                    </td>
                                    <td class="text-center">
                                        <div class="text-sm text-gray-900">
                                            {{ $studentFee->semester ? $studentFee->semester->name : __('student.not-set') }}
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        {{ $studentNotes }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentFee->payment_amount }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentFee->payment_currency }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentFee->paid_amount }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentFee->created_at }}
                                    </td>
                                    @if (auth()->user()->hasRole('admin') || auth()->user()->hasRole('registrar'))
                                        @if ($studentFee->paid_amount == 0)
                                            <td class="text-2xl text-center">
                                                <a href="{{ route('fee.edit', ['fee' => $studentFee->payment_reference]) }}" id="editFee2">
                                                    <i class="fas fa-edit text-primary"></i>
                                                </a>
                                                <a class="deleteFee" data-id="{{ $studentFee->payment_reference }}">
                                                    <i class="fas fa-trash-alt text-danger"></i>
                                                </a>
                                            </td>
                                        @else
                                        <td></td>
                                        @endif
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr class="whitespace-nowrap">
                                    <td>no data</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });

    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": false,
            "paging": false,
            "ordering": false,
            "info": false,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });
        // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        $(".constraint-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-class-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-year").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $('.deleteFee').click(function (e) {
            e.preventDefault();

            Swal.fire({
                icon: 'warning',
                title: 'عملية حذف!',
                text: 'هل تريد حذف هذه الدفعية فعلا؟',
                showDenyButton: true,
                confirmButtonText: 'نعم',
                denyButtonText: `لا`,
                }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    var token = $("meta[name='csrf-token']").attr("content");

                    $.ajax({
                        // url: "{{ route('fee.destroy', isset($studentFee->payment_reference)) }}",
                        url: "{{ url('fee/') }}" + "/" + $(this).data('id'),
                        type: 'DELETE',
                        data: {
                            "_token": token,
                        },
                        success: function (data){
                            console.log(data);
                            Swal.fire(
                                'عملية ناجحة!',
                                'تم حذف الدفعية بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    });
                }
            });
        });

        $("#addFee, #editFee").each(function(){
            $($(this)).click(function (e) {
                e.preventDefault();

                Swal.fire(
                    'قيد التصميم!',
                    'سيم اضافة هذا القسم قريبا',
                    'question'
                );
            });
        });

    }); // End of $(document).ready

</script>
@endsection
