<div class="custom-filter row">
    <form action="{{ route(Route::currentRouteName()) }}" method="get" id="filterForm">
        {{-- @csrf --}}
        <div class="row flex justify-center space-x-2">
            <!--  الكلية -->
            @if (!auth()->user()->hasRole('registrar'))
                <div class="col-2 px-1">
                    <select id="college" name="college_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="0">{{ __('student.choose-college') }}</option>
                        @if ( isset($colleges) )
                            @foreach ($colleges as $college)
                                <option value="{{ $college->id }}" {{ isset($filters->college_id) && $filters->college_id == $college->id ? 'selected' : '' }} class="college-options">
                                    {{ $college->name }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
            @endif

            <!--  القسم -->
            <div class="col-2">
                <select id="section" name="section_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">{{ __('student.choose-section') }}</option>
                    @if ( isset($sections) )
                        @foreach ($sections as $section)
                            <option value="{{ $section->id }}" {{ isset($filters->section_id) && $filters->section_id == $section->id ? 'selected' : '' }}>
                                {{ $section->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>

            <!--  البرنامج -->
            <div class="col-2">
                <select id="program" name="program_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">{{ __('student.choose-program') }}</option>
                    @if ( isset($programs) )
                        @foreach ($programs as $program)
                            <option value="{{ $program->id }}" {{ isset($filters->program_id) && $filters->program_id == $program->id ? 'selected' : '' }}>
                                {{ $program->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>

            <!-- الدفعة -->
            <div class="col-2">
                <select id="batch" name="batch_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">{{ __('student.choose-batch') }}</option>
                    @if ( isset($batches) )
                        @foreach ($batches as $batch)
                            <option value="{{ $batch->id }}" {{ isset($filters->batch_id) && $filters->batch_id == $batch->id ? 'selected' : '' }}>
                                {{ $batch->value }}
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>

            @php
                $includedRoutes = [
                    'fee.index'
                ];
            @endphp

            @if (in_array(Route::currentRouteName(), $includedRoutes))
                <div class="col-2">
                    <select id="paymentCurrency" name="payment_currency"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">

                        <option value="0" selected>كل العملات</option>
                        <option value="SDG" {{ isset($filters->payment_currency) && $filters->payment_currency == "SDG" ? 'selected' : '' }}>جنية سوداني</option>
                        <option value="USD" {{ isset($filters->payment_currency) && $filters->payment_currency == "USD" ? 'selected' : '' }}>دولار امريكي</option>

                    </select>
                </div>
            @endif

        </div>

        <!-- Special filter -->
        @if ( Route::current()->getName() == 'reports.payments' || Route::current()->getName() == 'reports.revenues' )
            @include('layouts.special-filter')
        @endif

        @if ( Route::current()->getName() == 'reports.fees' || Route::current()->getName() == 'filter.students.revenues.report' )
            @include('layouts.special-filter')
        @endif


        <div class="row flex justify-center space-x-2 mt-4">
            <div class="col-4 flex justify-center px-1">
                <button type="submit" style="background-color: #36304a;" class="mr-3 px-4 py-2 rounded-2 text-white btn" id="studentFilter" name="filter">
                    {{__('student.apply-filter') }}
                </button>
                <a href="{{ route(Route::currentRouteName()) }}" style="background-color: #36304a;" class="bg-danger btn mr-3 px-4 py-2 rounded-2 text-white" id="studentFilter">
                    {{__('student.reset') }}
                </a>
            </div>
        </div>

        @include('students.partials.search-button')
    </form>
</div>
