<div class="custom-filter row">
    <form action="{{ route(Route::currentRouteName()) }}" method="get" id="filterForm">
        <div class="row flex justify-center space-x-2">
            <div class="relative col-2 px-1 ml-3">
                <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                    <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                         viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                              d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                              clip-rule="evenodd"></path>
                    </svg>
                </div>
                <input name="from" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                       placeholder="الفترة من" value="{{ request('from') ?? '' }}">
            </div>

            <div class="relative col-2 px-1 ml-3">
                <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                    <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                         viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                              d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                              clip-rule="evenodd"></path>
                    </svg>
                </div>
                <input name="to" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                       placeholder="الفترة الي" value="{{ request('to') ?? '' }}">
            </div>

            <div class="col-2 px-1 mx-2">
                <select id="bank" name="bank_id"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">
                        كل البنوك
                    </option>
                    @if ( isset($banks) )
                        @foreach ($banks as $bank)
                            <option value="{{ $bank->id }}" {{ isset($bank_id) && $bank_id == $bank->id ? 'selected' : '' }}
                            class="bank-options">
                                {{ $bank->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>

            <div class="col-2 px-1 ml-2">
                <select id="paymentCurrency" name="payment_currency"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">

                    <option value="0" selected disabled>إختار نوع العملة</option>
                    <option value="SDG" {{ isset($payment_currency) && $payment_currency == "SDG" ? 'selected' : '' }}>جنية سوداني</option>
                    <option value="USD" {{ isset($payment_currency) && $payment_currency == "USD" ? 'selected' : '' }}>دولار امريكي</option>

                </select>
            </div>
        </div>

        <div class="row flex justify-center space-x-2 mt-4">
            <div class="col-4 flex justify-center px-1">
                <button type="submit" style="background-color: #36304a;" class="mr-3 px-4 py-2 rounded-2 text-white btn" id="studentFilter" name="filter">
                    {{__('student.apply-filter') }}
                </button>
                <a href="{{ route(Route::currentRouteName()) }}" style="background-color: #36304a;" class="bg-danger btn mr-3 px-4 py-2 rounded-2 text-white" id="studentFilter">
                    {{__('student.reset') }}
                </a>
            </div>
        </div>
    </form>
</div>
