@if (auth()->user()->hasRole('registrar'))
    <div class="row flex justify-center mt-3">
        <div class="relative col-2 px-1 ml-3">
            <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                        clip-rule="evenodd"></path>
                </svg>
            </div>
            <input name="from" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="الفترة من" value="{{ request('from') ?? '' }}">
        </div>

        <div class="relative col-2 px-1 ml-3">
            <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                        clip-rule="evenodd"></path>
                </svg>
            </div>
            <input name="to" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="الفترة الي" value="{{ request('to') ?? '' }}">
        </div>

        @php
            $constraintRoutes = [
                'reports.payments',
                'reports.revenues',
            ];

            $currentRoute = Route::currentRouteName();
            $selectedConstraint = $filters->constraint_id ?? 0;

            $constraintOptions = [
                1 => __('student.registered'),
                2 => __('student.partially-registered'),
                3 => __('student.un-registered'),
            ];
        @endphp

        @if (in_array($currentRoute, $constraintRoutes))
            <div class="col-2 px-1">
                <select id="constraint" name="constraint_id"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">{{ __('كل القيود') }}</option>

                    @foreach ($constraintOptions as $value => $label)
                        <option value="{{ $value }}" {{ $selectedConstraint == $value ? 'selected' : '' }}>
                            {{ $label }}
                        </option>
                    @endforeach
                </select>
            </div>
        @endif
    </div>
@endif

@if (auth()->user()->hasrole('financial') || auth()->user()->hasrole('admin'))
    <div class="row flex justify-center mt-3">
        <div class="relative col-2 px-1 ml-3">
            <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                        clip-rule="evenodd"></path>
                </svg>
            </div>
            <input name="from" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="الفترة من" value="{{ request('from') ?? '' }}">
        </div>

        <div class="relative col-2 px-1 ml-3">
            <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                        clip-rule="evenodd"></path>
                </svg>
            </div>
            <input name="to" datepicker type="text" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="الفترة الي" value="{{ request('to') ?? '' }}">
        </div>

        @if (Route::current()->getName() == 'reports.payments' || Route::current()->getName() == 'reports.revenues')
            <div class="col-2 px-1 ml-2">
                <select id="bank" name="bank_id"
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">
                        كل البنوك
                    </option>
                    @if ( isset($banks) )
                    @foreach ($banks as $bank)
                    <option value="{{ $bank->id }}" {{ isset($bank_id) && $bank_id == $bank->id ? 'selected' : '' }}
                        class="bank-options">
                        {{ $bank->name }}
                    </option>
                    @endforeach
                    @endif
                </select>
            </div>

            <div class="col-2 px-1">
                <select id="admission" name="admission_id"
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0">
                        كل انواع القبول
                    </option>
                    @if ( isset($admissions) )
                    @foreach ($admissions as $admission)
                    <option value="{{ $admission->id }}" {{ isset($filters->admission_id) && $filters->admission_id == $admission->id ? 'selected' : '' }}
                        class="college-options">
                        {{ $admission->name }}
                    </option>
                    @endforeach
                    @endif
                </select>
            </div>
        @endif
    </div>
@endif
