<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ config('app.name', 'Laravel') }}</title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link rel="stylesheet" href="{{ asset('css/card-payment.css') }}">

    <style>
        .error {
            color: Red;
        }

        .uofs-logo {
            width: 100%;
            height: 100%;
        }

        #printReceipt img{
            width: 1122.5px;
            height: 135px;
        }

        .receiptQr, #qr-code img, #qr-code canvas{
            max-width: 100px !important;
            max-height: 100px !important;
        }

    </style>

    <style>
        .loader {
        border: 16px solid #f3f3f3;
        border-radius: 50%;
        border-top: 16px solid #3498db;
        width: 10px;
        height: 10px;
        -webkit-animation: spin 2s linear infinite; /* Safari */
        animation: spin 2s linear infinite;
        }

        /* Safari */
        @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
        }

        @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
        }
    </style>

    <style>
        .swal2-deny {
            display: none !important;
        }

        @media (max-width: 480px) {
            .swal2-confirm {
                display: none !important;
            }

            .swal2-deny {
                display: inline-block !important;
                background-color: #05cf48 !important;
            }

            .swal2-styled.swal2-deny:focus {
                box-shadow: 0 0 0 3px rgb(55 220 140 / 50%);
            }

            .receiptQr, #qr-code img, #qr-code canvas,
            .receiptQr, #qr-code2 img, #qr-code2 canvas{
                max-width: 100px !important;
                max-height: 100px !important;
            }

            .doneButton {
                display: inline-block !important;
                background-color: #05cf48 !important;
                color: white;
                width: 80px;

            }
        }
    </style>
</head>
<body dir="rtl">
    <div id="step1">
        <div class="container-fluid" style="height: 100vh; padding-top: 100px;">
            <div class="container bg-light d-md-flex align-items-center">
                <div class="card box2 shadow-sm min-h-100">
                    <section>
                        <div class="col-md-12 py-4 px-4 mb-5">
                            <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="uofs-logo" class="mx-auto uofs-logo">
                        </div>
                    </section>

                    <form action="javascript:void(0);" method="POST" id="getStudentDataForm">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <div class="inputWithIcon">
                                        <input class="form-control text-center" type="text" placeholder="ادخل الرقم الجامعي" id="student_id" style="text-transform:uppercase" required>
                                        <span class="">
                                            {{-- <img src="https://www.freepnglogos.com/uploads/mastercard-png/mastercard-logo-logok-15.png" alt=""> --}}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 px-md-5 px-4 mt-3 mb-5">
                                <button type="submit" class="btn btn-primary w-100" id="getStudentInfo">إرسال</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- step 2 --}}
    <div id="step2" hidden>
        <div class="container-fluid" style="height: 100vh; padding-top: 30px;">
            <div class="container bg-light d-md-flex align-items-center">
                <div class="card box2 shadow-sm">
                    <section>
                        <div class="col-md-12 py-4 px-4 mb-5">
                            <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="uofs-logo" class="mx-auto uofs-logo">
                        </div>
                    </section>

                    <form action="javascript:void(0);" method="POST" id="studentPaymentForm">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <span class="mb-1">إسم الطالب</span>
                                    <div class="inputWithIcon">
                                        <input class="form-control text-center" type="text" placeholder="إسم الطالب" id="txtStudentName" required readonly>
                                        <span class="">
                                        </span>
                                    </div>
                                </div>

                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <span class="mb-1">المبلغ المطلوب</span>
                                    <div class="inputWithIcon">
                                        <input class="form-control text-center" type="text" placeholder="0.00" id="txtAmount" required readonly>
                                        <span class="">
                                        </span>
                                    </div>
                                </div>

                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <span>رقم البطاقة</span>
                                    <div class="inputWithIcon">
                                        <input class="form-control" type="text" placeholder="6391 01234 5678 9001" id="txtPAN" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <span>
                                        تاريخ الإنتهاء
                                    </span>
                                    <div class="inputWithIcon">
                                        <input type="text" class="form-control date-format" placeholder="01/23" id="txtExpDate" required>
                                        <span class="fas fa-calendar-alt"></span>
                                    </div>
                                    <span class="error" style="display: none">
                                        الرجاء اضافة تاريخ الإنتهاء كما في البطاقة باللغة الانجليزية
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                    <span>PIN</span>
                                    <div class="inputWithIcon">
                                        <input type="password" class="form-control" placeholder="123" id="txtPIN" required>
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex flex-column px-md-5 px-4 mb-4">
                                <span class="mb-1">رقم الهاتف</span>
                                <div class="inputWithIcon">
                                    <input class="form-control text-center" type="text" placeholder="0XXXXXXXXX" id="txtStudentNumber" name="txtStudentNumber" required>
                                </div>
                                <span class="studentNumberError text-danger text-center mt-2" hidden>
                                    هذا الحقل مطلوب، ويجب ان لا يقل عن ١٠ ارقام.
                                </span>
                            </div>

                            <div class="col-12 px-md-5 px-4 mt-3 mb-5">
                                <button type="submit" class="btn btn-primary w-100" id="sendButton" disabled>إرسال</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Print Receipt Modal --}}
    <div hidden>
        <div id="receiptModal" dir="rtl">
            <div class="grid grid-cols-1 gap-1">
                <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" class="text-center" alt="uofs-logo" style="width: 700px; height: 135px;">

                <h1 class="font-bold text-2xl text-center">ايصال سداد دفعية</h1>

                <div>
                    {{-- row 1 --}}
                    <div class="row gx-0">
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; width: 112px;">
                            {{ __('student.name') }}
                        </div>
                        <div class="studentName pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; width: 600px;">
                            {{ __('student.name') }}
                        </div>
                    </div>

                    {{-- row 2 --}}
                    <div class="row gx-0">
                        <div style="width: 80px; border: black 1px solid; border-top: none; border-left: none;"></div>
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                            {{ __('student.id') }}
                        </div>
                        <div class="studentId pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 440px;">
                            {{ __('student.id') }}
                        </div>
                        <div style="width: 80px; border: black 1px solid; border-top: none; border-right: none;"></div>
                    </div>

                    {{-- row 3 --}}
                    <div class="row gx-0">
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                            {{ __('student.semester') }}
                        </div>
                        <div class="semesterId pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                            {{ __('student.semester') }}
                        </div>
                        <div style="width: 80px"></div>
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 120px;">
                            {{ __('student.payment-date') }}
                        </div>
                        <div class="paymentDate pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                            {{ __('student.payment-date') }}
                        </div>
                    </div>

                    {{-- row 4 --}}
                    <div class="row gx-0">
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                            {{ __('fee.payment-amount') }}
                        </div>
                        <div class="paymentAmount pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                            {{ __('fee.payment-amount') }}
                        </div>
                        <div style="border-bottom: black 1px solid; width: 80px;"></div>
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 120px;">
                            {{ __('fee.transaction-reference') }}
                        </div>
                        <div class="transactionRef pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                            {{ __('fee.transaction-reference') }}
                        </div>
                    </div>

                    {{-- row 5 --}}
                    <div class="row gx-0">
                        <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                            {{ __('student.user-name') }}
                        </div>
                        <div class="userName pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 600px;">
                            {{ __('student.user-name') }}
                        </div>
                    </div>
                </div>

            </div>

            <div class="gx-0 row my-5 d-flex justify-content-center">
                <div class="receiptQr d-flex justify-content-center">
                    <div id="qr-code"></div>
                </div>
            </div>
        </div>
    </div>

    {{-- Show Receipt --}}
    <div id="showReceipt" hidden>
        <div class="d-flex justify-content-center align-items-center" style="height: 100vh">
            <div class="bg-light w-8 p-2 mx-2">
                <div id="receiptModal" dir="rtl">
                    <div class="grid grid-cols-1 gap-1">
                        <section>
                            <div class="col-md-12 py-4 px-4 mb-1">
                                <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="uofs-logo" class="mx-auto uofs-logo">
                            </div>
                        </section>

                        <h1 class="font-bold text-2xl text-center">ايصال سداد دفعية</h1>

                        <section>
                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('student.id') }}
                                </div>
                                <div class="studentId col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('student.id') }}
                                </div>
                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('student.name') }}
                                </div>
                                <div class="studentName col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('student.name') }}
                                </div>
                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('student.semester') }}
                                </div>
                                <div class="semesterId col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('student.semester') }}
                                </div>

                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('student.user-name') }}
                                </div>
                                <div class="userName col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('student.user-name') }}
                                </div>
                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('fee.payment-amount') }}
                                </div>
                                <div class="paymentAmount col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('fee.payment-amount') }}
                                </div>
                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('fee.transaction-reference') }}
                                </div>
                                <div class="transactionRef col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('fee.transaction-reference') }}
                                </div>
                            </div>

                            <div class="border border-1 border-dark gx-0 row my-1">
                                <div class="border-2 border-dark border-start col-4 font-bold px-1 py-1">
                                    {{ __('student.payment-date') }}
                                </div>
                                <div class="paymentDate col-8 px-1 py-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block  dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500">
                                    {{ __('student.payment-date') }}
                                </div>
                            </div>

                            <div class="gx-0 row my-5 d-flex justify-content-center">
                                <div class="receiptQr d-flex justify-content-center">
                                    <div id="qr-code2"></div>
                                </div>
                            </div>

                            <div class="gx-0 row my-5 d-flex justify-content-center">
                                <a href="{{ route('card-payment.index') }}" class="btn doneButton">
                                    موافق
                                </a>
                            </div>
                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('js/apay.js') }}"></script>
    <script src="{{ asset('js/divjs.js') }}"></script>
    <script src="{{ asset('plugins/qr-code/js/qrcode.min.js') }}"></script>

    <script>
        let _orderId = "";
        let studentData = "";
        let paymentData = "";
        let _studentNumber = "";

        $('#getStudentInfo').click(function (e) {
            e.preventDefault();

            let studentId = $("#student_id").val();

            $.ajax({
                type: "post",
                url: "{{ url('amarous-pay/student-info') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    student_id: studentId,
                    bank_identifier: '639188d21dcc0',

                },
                success: function (response) {
                    studentData = response;

                    if(studentData != undefined) {
                        if(studentData.is_paid != 1){
                            $('#step1').attr("hidden", true);

                            $('#txtAmount').val(studentData.payment_amount ?? "0.00");
                            $('#txtStudentName').val(studentData.student_name ?? "إسم الطالب");

                            _orderId = studentData.payment_reference;

                            $('#step2').removeAttr("hidden");
                        } else {
                            new QRCode(document.getElementById("qr-code"), "{{ url('check-receipt/') }}" + "/" + studentData.transaction_ref);
                            new QRCode(document.getElementById("qr-code2"), "{{ url('check-receipt/') }}" + "/" + studentData.transaction_ref);

                            Swal.fire({
                                icon: 'question',
                                title: 'عملية معلقة',
                                text: "الطلب مدفوع مسبقا",

                                showCancelButton: true,
                                showDenyButton: true,

                                confirmButtonText: 'طباعة إصال السداد',
                                denyButtonText: 'إظهار إشعار السداد',
                                cancelButtonText: 'الغاء',

                                focusConfirm: true,

                            }).then((result) => {
                                /* Read more about isConfirmed, isDenied below */
                                if (result.isConfirmed) {
                                    printReceipt(studentData.createdAt, studentData.transaction_ref, true);
                                } else if(result.isDenied){
                                    $('#step1').attr("hidden", true);
                                    printReceipt(studentData.createdAt, studentData.transaction_ref, false);
                                    $('#showReceipt').attr("hidden", false);
                                }
                            });
                        }
                    } else {
                        Swal.fire({
                            title: "عملية غير ناجحة",
                            text: "لم يتم ايجاد دفعية مقيدة برقم الطالب المدخل في سجلاتنا، يرجاء مراجعة مسجل الكلية.",
                            icon: "error",
                            confirmButtonText: "تم",
                        });

                        return true;
                    }

                },
                statusCode: {
                    404: function(response, xhr) {
                        if(response.responseJSON.message == "registration not set yet") {
                            Swal.fire({
                                title: "عملية غير ناجحة",
                                text: "لم يتم فتح التسجيل",
                                icon: "error",
                                confirmButtonText: "تم",
                            });
                        } else {
                            Swal.fire({
                                title: "عملية غير ناجحة",
                                text: "لم يتم ايجاد رقم الطالب في سجلاتنا",
                                icon: "error",
                                confirmButtonText: "تم",
                            });
                        }
                    },
                },
                error: function (response) {
                    console.log(response);
                },
            });
        });

        $("#sendButton").click( async function (e) {
            e.preventDefault();
            let studentNumber = document.getElementById('txtStudentNumber').value;

            if(studentNumber.length == 0 || studentNumber.length < 10){
                $('.studentNumberError').attr('hidden', false);
            } else {
                _studentNumber = studentNumber;

                $('.studentNumberError').attr('hidden', true);

                $('#sendButton').html('<div class="loader"></div>');
                $('#sendButton').prop('disabled', true);

                let _amount = document.getElementById('txtAmount').value;
                let _pan = document.getElementById('txtPAN').value;
                let expdate = document.getElementById('txtExpDate').value;
                let fixedExpdate = expdate.split("/");
                let _expdate = fixedExpdate.reverse().join("");
                let _uuid = generateGuid();
                let clearIPIN = _uuid + document.getElementById('txtPIN').value;
                let _date = getCurrDate();
                let encrypt = new JSEncrypt();

                encrypt.setPublicKey("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBANx4gKYSMv3CrWWsxdPfxDxFvl+Is/0kc1dvMI1yNWDXI3AgdI4127KMUOv7gmwZ6SnRsHX/KAM0IPRe0+Sa0vMCAwEAAQ==");
                let encryptedIPIN = encrypt.encrypt(clearIPIN);

                const requestInfo = {
                    "channelId":"3",
                    "serviceId":"100196",
                    "paymentMethodId":"28",
                    "customerId":"36634624",
                    "date":_date,
                    "PAN":_pan,
                    "tranUID":_uuid,
                    "expDate":_expdate,
                    "internetPin":encryptedIPIN,
                    "amount":_amount,
                    "orderId": _orderId // transationId or refrenceNo
                }

                paymentData = requestInfo;

                const myJSON = JSON.stringify(requestInfo);

                const response = await fetch("https://pay.amarouse.com:23666/api/processService", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: myJSON,
                });

                response.json().then(data => {
                    if(data.responseMessage == "INVALID_EXP_DATE") {
                        Swal.fire({
                            icon: 'error',
                            title: 'معاملة غير ناجحة',
                            text: 'تاريخ انتهاء الصلاحية للبطاقة غير صحيح',
                        });
                    } else if(data.responseMessage == "Approved"){
                        doPayment();

                        Swal.fire({
                            icon: 'success',
                            title: 'معاملة ناجحة',
                            text: "تمت العملية بنجاح",

                            showCancelButton: true,
                            showDenyButton: true,

                            confirmButtonText: 'طباعة إصال السداد',
                            denyButtonText: 'إظهار إشعار السداد',
                            cancelButtonText: 'الغاء',

                            confirmButtonText: 'طباعة إيصال السداد',
                            cancelButtonText: 'الغاء',

                        }).then((data) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (data.isConfirmed) {
                                printReceipt(response.created_at, response.transaction_ref, true);
                            } else if(data.isDenied){
                                $('#step1').attr("hidden", true);
                                printReceipt(studentData.createdAt, studentData.transaction_ref, false);
                                $('#showReceipt').attr("hidden", false);
                            } else {
                                location.reload();
                            }
                        });
                    } else if(data.responseMessage == "Already Paid"){

                        new QRCode(document.getElementById("qr-code"), "{{ url('check-receipt/') }}" + "/" + studentData.transaction_ref);
                        new QRCode(document.getElementById("qr-code2"), "{{ url('check-receipt/') }}" + "/" + studentData.transaction_ref);

                        Swal.fire({
                            icon: 'question',
                            title: 'عملية معلقة',
                            text: "الطلب مدفوع مسبقا",

                            showCancelButton: true,
                            showDenyButton: true,

                            confirmButtonText: 'طباعة إصال السداد',
                            denyButtonText: 'إظهار إشعار السداد',
                            cancelButtonText: 'الغاء',

                            confirmButtonText: 'طباعة إيصال السداد',
                            cancelButtonText: 'الغاء',

                            focusConfirm: true,
                        }).then((result) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                                printReceipt(studentData.createdAt, studentData.transaction_ref, true);
                            } else if(result.isDenied){
                                $('#step1').attr("hidden", true);
                                printReceipt(studentData.createdAt, studentData.transaction_ref, false);
                                $('#showReceipt').attr("hidden", false);
                            }
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'معاملة غير ناجحة',
                            text: "يوجد خطاء في البيانات المدخلة",
                        }).then( function(){
                            location.reload();
                        });
                    }
                });
            }
        });

        function generateGuid()
        {
                let guid = s4() + s4() + '-' + s4() + '-' + s4() + '-' +
                s4() + '-' + s4() + s4() + s4();

                return guid;
        }

        function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
        }

        function getCurrDate()
        {
            const today = new Date();
            const yy = today.getFullYear().toString().substr(2,2);
            let mm = today.getMonth() + 1; // Months start at 0!
            let dd = today.getDate();
            let hh = today.getHours();
            let MM = today.getMinutes();
            let ss = today.getSeconds();

            if (dd < 10) dd = '0' + dd;
            if (mm < 10) mm = '0' + mm;
            if (hh < 10) hh = '0' + hh;
            if (MM < 10)MM = '0' + MM;
            if (ss < 10) ss = '0' + ss;
            const formattedToday = dd+mm+yy+hh+MM+ss;

            return formattedToday;
        }

        function uuidv4() {
            return ([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g, c =>
                (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
            );
        }

        function doPayment()
        {
            $.ajax({
                type: "POST",
                url: "{{ url('amarous-pay/request') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    student_id: studentData.student_id,
                    payment_reference: studentData.payment_reference,
                    semester_id: studentData.semester_id,
                    transaction_ref: "fcbcard-" + _orderId,
                    payment_amount: paymentData.amount,
                    bank_id: 2,
                },
                success: function (response) {
                    // sendMessageNotification(response.student_name, _studentNumber, response.payment_amount, response.payment_reference, response.created_at);

                    $('.studentId').html(response.student_id);
                    $('.studentName').html(response.student_name);
                    $('.paymentAmount').html(response.payment_amount);
                    $('.transactionRef').html(response.transaction_ref);
                    $('.semesterId').html(response.semester_name);
                    $('.paymentDate').html(response.created_at);
                    $('.userName').html(response.user_name);

                    // QR Code
                    new QRCode(document.getElementById("qr-code"), "{{ url('check-receipt/') }}" + "/" + response.transaction_ref);

                },
                error: function(response) {
                    console.log(response);
                },
            });
        }

        function sendMessageNotification(studentName, phoneNumber, amount, paymentReference, createdAt)
        {
            $.ajax({
                type: "get",
                url: "{{ url('amarous-pay/sms-notification') }}",
                data: {
                    student_name: studentName,
                    phone_number: phoneNumber,
                    amount: amount,
                    payment_reference: paymentReference,
                    created_at: createdAt,
                },
                success: function (response) {
                },
                error: function (response) {
                    console.log(response);
                },
            });
        }
    </script>


{{-- validate expire date --}}

<script type="text/javascript">

    let isShift = false;
    let seperator = "/";

    window.onload = function () {
        //Reference the Table.
        let tblForm = document.getElementById("tblForm");

        let input = document.getElementById("txtExpDate");
        let input2 = document.getElementById("txtStudentNumber");

        if (input.type == "text") {
            //Check whether Date Format Validation is required.
            if (input.className.indexOf("date-format") != 1) {

                //Set Max Length.
                input.setAttribute("maxlength", 5);

                //Only allow Numeric Keys.
                input.onkeydown = function (e) {
                    return IsNumeric(this, e.keyCode, true);
                };

                //Validate Date as User types.
                input.onkeyup = function (e) {
                    ValidateDateFormat(this, e.keyCode);
                };
            }
        }

        if (input2.type == "text") {
            //Set Max Length.
            input2.setAttribute("maxlength", 10);

            //Only allow Numeric Keys.
            input2.onkeydown = function (e) {
                return IsNumeric(this, e.keyCode, false);
            };
        }
    };

    function IsNumeric(input, keyCode, hasSeperator) {
        if (keyCode == 16) {
            isShift = true;
        }
        //Allow only Numeric Keys.
        if (((keyCode >= 48 && keyCode <= 57) || keyCode == 8 || keyCode <= 37 || keyCode <= 39 || (keyCode >= 96 && keyCode <= 105)) && isShift == false) {
            if(hasSeperator == true){
                if ((input.value.length == 2) && keyCode != 8) {
                    input.value += seperator;
                }
            }

            return true;
        }
        else {
            return false;
        }
    };

    function ValidateDateFormat(input, keyCode) {
        let dateString = input.value;
        if (keyCode == 16) {
            isShift = false;
        }
        // let regex = /(((0|1)[0-9]|2[0-9]|3[0-1])\/(0[1-9]|1[0-2])\/((19|20)\d\d))$/;
        let regex = /^(0[1-9]|1[0-2])\/?([0-9]{2})$/;

        //Check whether valid MM/yyyy Date Format.
        if (regex.test(dateString) || dateString.length == 0) {
            ShowHideError(input, "none");
            $('#sendButton').prop('disabled', false);
        } else {
            ShowHideError(input, "block");
        }

        if(dateString.length == 0){
            $('#sendButton').prop('disabled', true);
        }

    };

    function ShowHideError(textbox, display) {
        let row = textbox.parentNode.parentNode;
        let errorMsg = row.getElementsByTagName("span")[2];
        if (errorMsg != null) {
            errorMsg.style.display = display;
        }
    };

    function printReceipt(createdAt, transactionRef, print)
    {
        $('.studentId').html(studentData.student_id);
        $('.studentName').html(studentData.student_name);
        $('.paymentAmount').html(paymentData.payment_amount ?? studentData.payment_amount);
        $('.transactionRef').html(transactionRef);
        $('.semesterId').html(studentData.semester_name);
        $('.paymentDate').html(createdAt);
        $('.userName').html(studentData.user_name);

        // new QRCode(document.getElementById("qr-code"), "{{ url('check-receipt/') }}" + "/" + studentData.transaction_ref);

        if(print == true){
            $('#receiptModal').printElement();
        }
    }
</script>
</body>
</html>
