<!-- layouts/print-layout.blade.php -->
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'صفحة الطباعة')</title>
    <style>
        @media print {
            @page {
                size: A4 portrait;
                margin: 15mm 20mm 0 20mm;
            }

            body {
                font-family: Arial, sans-serif;
                font-size: 12px;
                color: #000;
                margin: 0;
                padding: 0;
            }

            .page {
                page-break-after: always;
            }

            table {
                margin-top: 40px;
                width: 100%;
                border-collapse: collapse;
            }

            th, td {
                border: 1px solid #000;
                padding: 6px;
                text-align: center;
            }

            .no-print {
                display: none !important;
            }
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .banner {
            text-align: center;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
        }

        .parent {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: repeat(2, 1fr);
            border: 1px solid #000;
        }

        .div1, .div2, .div3, .div4 {
            padding: 7px;
            border: 1px solid #000;
            text-align: right;
        }

        .div1 { grid-area: 1 / 1 / 2 / 2; }
        .div2 { grid-area: 1 / 2 / 2 / 3; }
        .div3 { grid-area: 2 / 1 / 3 / 2; }
        .div4 { grid-area: 2 / 2 / 3 / 3; }

        .parent span:nth-child(1) {
            margin-right: 10px;
            font-weight: bold;
        }

        .parent span:nth-child(2) {
            margin-right: 10px;
        }
    </style>

    @yield('styles')
</head>
<body>
@yield('content')

<script>
    window.onload = function () {
        window.print();
    };
</script>
</body>
</html>
