@extends('print-out.base-layout')

@section('title', 'قوائم إجلاس الطلاب')

@section('content')
    @php
        $studentsPerPage = 25;
        $totalPages = ceil(count($students) / $studentsPerPage);
    @endphp

    @for ($page = 0; $page < $totalPages; $page++)
        <div class="page">
            <div class="banner">
                <img src="{{ asset('img/' . env('SYSTEM_BANAR')) }}" alt="شعار" style="max-width: 650px;">
            </div>

            <div class="header">
                <h2>قوائم إجلاس الطلاب</h2>
                <div class="parent">
                    <div class="div1"><span>الكلية :</span><span>{{ $collegeName ?? '' }}</span></div>
                    <div class="div2"><span>الدفعة :</span><span>{{ $batchValue ?? '' }}</span></div>
                    <div class="div3"><span>القسم :</span><span>{{ $sectionName ?? '' }}</span></div>
                    <div class="div4"><span>البرنامج :</span><span>{{ $programName ?? '' }}</span></div>
                </div>
            </div>

            <table>
                <thead>
                <tr>
                    <th>#</th>
                    <th>رقم الطالب</th>
                    <th>اسم الطالب</th>
                    <th>التوقيع</th>
                    <th>اعمال سنة</th>
                    <th>نصفي</th>
                    <th>نهائي</th>
                    <th>المجموع</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($students->slice($page * $studentsPerPage, $studentsPerPage) as $i => $student)
                    <tr>
                        <td>{{ $page * $studentsPerPage + $i + 1 }}</td>
                        <td>{{ $student->student_id }}</td>
                        <td style="text-align: right;">{{ $student->student_name }}</td>

                        @for ($j = 0; $j < 5; $j++)
                            <td>&nbsp;</td>
                        @endfor
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    @endfor
@endsection
