@extends('print-out.base-layout')

@section('title', 'تقرير الطلاب - التسجيل الالكتروني')

@section('styles')
    <style>
        body{
            @media print {
                td {
                    font-size: 10px !important;
                    padding: 5px;
                }

                .footer-revenue-min{
                    margin-top: 20px;
                }
            }
        }
    </style>
@endsection

@section('content')
    <div class="page">
        <div class="banner">
            <img src="{{ asset('img/' . env('SYSTEM_BANAR')) }}" alt="شعار" style="max-width: 650px;">
        </div>

        <div class="header">
            <h2>تقرير الطلاب - التسجيل الالكتروني</h2>
            <div class="parent">
                <div class="div1"><span>من :</span><span>{{ $start ?? '' }}</span></div>
                <div class="div2"><span>الي :</span><span>{{ $end ?? '' }}</span></div>
                <div class="div3"><span>البنك :</span><span>{{ $bankName ?? '' }}</span></div>
                <div class="div4"><span>العملة :</span><span>{{ $currency ?? '' }}</span></div>
            </div>
        </div>

        <table class="text-sm w-full border mt-4" dir="rtl">
            <thead>
            <tr>
                <th>#</th>
                <th>الكلية</th>
                <th>عام</th>
                <th>خاص</th>
                <th>تسجيل</th>
                <th>تأمين</th>
                <th>غرامة</th>
                <th>أخرى</th>
                <th>دمغة</th>
                <th>الخصومات</th>
                <th>المجموع</th>
            </tr>
            </thead>
            <tbody>
            @php
                $no = 1;
                $totalNotPrivateFees = 0;
                $totalPrivateFees = 0;
                $totalRegistrationFees = 0.0;
                $totalInsuranceFees = 0.0;
                $totalPenalty = 0.0;
                $totalOtherFees = 0.0;
                $totalStamp = 0.0;
                $totalDiscount = 0.0;
            @endphp

            @foreach ($colleges ?? [] as $college)
                @php
                    $rowTotal =
                        ($college->total_not_private_fees ?? 0) +
                        ($college->total_private_fees ?? 0) +
                        ($college->total_registration_fees ?? 0) +
                        ($college->total_insurance_fees ?? 0) +
                        ($college->total_penalty ?? 0) +
                        ($college->total_other_fees ?? 0) +
                        ($college->total_stamp ?? 0);

                    $totalNotPrivateFees += $college->total_not_private_fees ?? 0;
                    $totalPrivateFees += $college->total_private_fees ?? 0;
                    $totalRegistrationFees += $college->total_registration_fees ?? 0;
                    $totalInsuranceFees += $college->total_insurance_fees ?? 0;
                    $totalPenalty += $college->total_penalty ?? 0;
                    $totalOtherFees += $college->total_other_fees ?? 0;
                    $totalStamp += $college->total_stamp ?? 0;
                    $totalDiscount += $college->total_discount ?? 0;
                @endphp
                <tr>
                    <td class="border text-center">{{ $no++ }}</td>
                    <td class="border text-center">{{ $college->name ?? '' }}</td>
                    <td class="border text-center">{{ $college->total_not_private_fees ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_private_fees ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_registration_fees ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_insurance_fees ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_penalty ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_other_fees ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_stamp ?? 0 }}</td>
                    <td class="border text-center">{{ $college->total_discount ?? 0 }}</td>
                    <td class="border text-center">{{ $rowTotal }}</td>
                </tr>
            @endforeach

            @php
                $totalSum = $totalNotPrivateFees + $totalPrivateFees + $totalRegistrationFees + $totalInsuranceFees + $totalPenalty + $totalOtherFees + $totalStamp - $totalDiscount;
            @endphp
            </tbody>
        </table>

{{--        <div class="mt-6 text-sm text-right" dir="rtl">--}}
{{--            <div class="grid grid-cols-4 gap-2">--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع رسوم العام</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalNotPrivateFees }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع رسوم الخاص</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalPrivateFees }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع رسوم التسجيل</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalRegistrationFees }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع رسوم التأمين</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalInsuranceFees }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع الغرامات</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalPenalty }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع الرسوم الأخرى</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalOtherFees }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع الدمغة</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalStamp }}</div>--}}
{{--                </div>--}}
{{--                <div class="border p-2 text-center">--}}
{{--                    <div>مجموع الخصومات</div>--}}
{{--                    <hr>--}}
{{--                    <div>{{ $totalDiscount }}</div>--}}
{{--                </div>--}}
{{--            </div>--}}

{{--            <div class="border mt-4 p-4 text-center font-bold">--}}
{{--                <div>المجموع الكلي</div>--}}
{{--                <hr>--}}
{{--                <div>{{ $totalSum }}</div>--}}
{{--            </div>--}}
{{--        </div>--}}

        <div class="footer-revenue-min" dir="rtl">
            <table>
                <tr>
                    <th>مجموع رسوم العام</th>
                    <th>مجموع رسوم الخاص</th>
                    <th>مجموع رسوم التسجيل</th>
                    <th>مجموع رسوم التامين</th>
                </tr>
                <tr>
                    <td>{{ $totalPrivateFees }}</td>
                    <td>{{ $totalNotPrivateFees }}</td>
                    <td>{{ $totalRegistrationFees }}</td>
                    <td>{{ $totalInsuranceFees }}</td>
                </tr>

                <tr>
                    <td colspan="4" style="border: none">&nbsp;</td>
                </tr>

                <tr>
                    <th>مجموع الغرامات</th>
                    <th>مجموع الرسوم الأخرى</th>
                    <th>مجموع الدمغة</th>
                    <th>مجموع الخصومات</th>
                </tr>

                <tr>
                    <td>{{ $totalOtherFees }}</td>
                    <td>{{ $totalPenalty }}</td>
                    <td>{{ $totalStamp }}</td>
                    <td>{{ $totalDiscount }}</td>
                </tr>

                <tr>
                    <td colspan="4" style="border: none">&nbsp;</td>
                </tr>

                <tr>
                    <th style="border: none">&nbsp;</th>
                    <th colspan="2">المجموع الكلي</th>
                </tr>
                <tr>
                    <td style="border: none">&nbsp;</td>
                    <td colspan="2">{{ $totalSum }}</td>
                </tr>
            </table>
        </div>
    </div>
@endsection
