@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
    <style>
        tfoot{
            background-color: #36304a;
        }

        table.dataTable>thead>tr>th:not(.sorting_disabled){
            padding-right: 30px !important;
        }
    </style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.students-fees') }}
                </div>

                <div class="card-body">
                    <!-- filter -->
                    @include('layouts.filter')

                    <div id="studentsListTable" class="mt-4">
                        <table class="table" id="studentsTable2" style="width: 100%;">
                            <thead>
                                <tr class="table100-head">
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.tuition-fees') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.registration-fees') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.discount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.due-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-reference') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.created-at') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('report.action') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if (isset($studentsFees))
                                    @foreach ($studentsFees as $studentFee)
                                        <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                            <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                                {{ $studentFee->student_id }}
                                            </th>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->student_name }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->study_fees }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->registration_fees }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->discount ?? "0.00" }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->semester ? $studentFee->semester->name : __('student.not-set') }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->payment_amount }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->payment_currency }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->due_amount ?? "0" }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->payment_reference }}
                                                </div>
                                            </td>
                                            <td class="py-2 text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentFee->created_at }}
                                                </div>
                                            </td>
                                            <td>
                                                <a href="{{ route('fee.show', $studentFee->student->id ?? -1) }}" type="button" id="showStudentsFees"
                                                    class="p-1 rounded-lg" style="background-color: #36304a; color: white;">
                                                    {{ __('report.show-student-fees') }}
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                            <tfoot>
                                <tr class="table100-head">
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.tuition-fees') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.registration-fees') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.discount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.due-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-reference') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.created-at') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('report.action') }}
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $studentsFees->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
