@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.students-payments') }}
                </div>

                <div class="card-body">
                    <!-- filter -->
                    @include('layouts.filter')

                    <div id="studentsListTable" class="mt-4">
                        <table class="table" id="studentsTable2" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        #
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.paid') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.transaction-ref') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        البنك
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-reference') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.payment-created-date') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('report.action') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if (isset($studentsPayments))
                                    <?php $no = 1;?>
                                    @foreach ($studentsPayments as $studentPayment)
                                        <tr class="whitespace-nowrap">
                                            <td class="text-sm text-center text-black">
                                                <?= $no++; ?>
                                            </td>
                                            <td class="text-sm text-center text-black">
                                                {{ $studentPayment->student_id }}
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->student_name }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->semester->name ?? '' }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->registration->payment_amount ?? 0 }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->payment_amount }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->payment_currency }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <div class="text-sm text-gray-900">
                                                    {{ $studentPayment->transaction_ref }}
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->bank->name ?? '' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->payment_reference }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->created_at}}
                                            </td>

                                            <td class="py-2 text-center showStudent">
                                                {{-- <a href="{{ route('reports.show.payments', ['studentId' => $studentPayment->student_id]) }}" type="button" id="printStudentPayments" --}}
                                            <a href="{{ route('payments.show', $studentPayment->student->id) }}" type="button" id="showStudentsPayments"
                                                    class="p-1 rounded-lg" style="background-color: #36304a; color: white;">
                                                    {{ __('report.show-student-payments') }}
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th  scope="col" class="py-2 px-2 text-white">
                                        #
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-amount') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.paid') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نوع العملة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.transaction-ref') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        البنك
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('fee.payment-reference') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.payment-created-date') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('report.action') }}
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $studentsPayments->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
