@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

    <style>
        .html5buttons {
            direction: ltr;
            position: absolute;
            top: -45px;
            left: 10px;
        }

        .html5buttons .btn-secondary {
            color: #ffffff;
            background-color: #295694;
        }

        .html5buttons .buttons-print {
            background-color: rgb(167, 32, 53);
            color: white;
        }

        .dataTables_filter {
            margin: 20px 0px 20px;
        }

        #min,
        #max {
            max-width: 150px;
            min-width: unset;
            font-size: 12px;
            font-weight: 400;
            text-align: center;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: none !important;
            min-height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
        }

        .dt-datetime-year,
        .dt-datetime-month {
            min-width: unset !important;
            width: 50px !important;
            max-height: 22px !important;
        }

        .dropdown-menu .dropdown-item {
            text-align: right !important;
        }

        tfoot p {
            color: white !important;
            font-size: 12px !important;
            font-weight: 100 !important;
        }

        input[type='text'],
        input[type='date'],
        input[type='number'],
        select,
        input[type='text']:focus,
        input[type='date']:focus,
        input[type='number']:focus,
        input[type='text']:focus-visible,
        input[type='date']:focus-visible {
            width: unset;
        }

        #printRevenuesModal img {
            width: 1122.5px;
            height: 135px;
        }

        #printRevenuesModal .student-name {
            width: 40%;
            text-align: right;
            padding-right: 20px;
        }

        tbody tr {
            color: black;
        }

        .custom-table {
            border: none !important;
        }

        .custom-table .col-1,
        .custom-table .col-2,
        .custom-table .col-3,
        .custom-table .col-4,
        .custom-table .col-5,
        .custom-table .col-6,
        .custom-table .attendance-title {
            border: none !important;
            border-collapse: collapse;
        }

        .custom-table .no {
            border-right: none !important;
        }

        .custom-table .attendance-cell .col-1-10,
        .custom-table .attendance-cell .col-10-10 {
            position: relative;
            min-height: 1px;
            border: none !important;
            border-collapse: collapse;
            float: left;
        }

        .custom-table .attendance-cell .col-1-10 {
            width: 10%;
        }

        .custom-table .attendance-cell .col-10-10 {
            width: 100%;
        }

        .excluded:focus {
            box-shadow: unset !important;
        }

        .sorting_disabled::before,
        .sorting_disabled::after {
            display: none !important;
        }

        /* Update all table cell borders to none and background to grey */
        table td,
        table th,
        .table td,
        .table th,
        .border-2 {
            border-width: 0 !important;
            border-style: none !important;
            border-color: transparent !important;
            background-color: #f0f0f0 !important; /* Light grey background */
        }

        table, .table {
            border-collapse: separate !important;
            border-spacing: 1px !important; /* Add 1px gap between cells */
        }

        table, .table {
            background-color: #ccc; /* color of the 1px gaps */
        }

        tfoot {
            background-color: #36304a !important;
        }
    </style>

    <link rel="stylesheet" href="{{ asset('plugins/datatable/css/dateTime.min.css') }}">
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.students-revenues-min') }}

                    <button class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none" id="printRevenuesBtn">
                        طباعة
                    </button>
                </div>

                <div class="card-body">
                    @include('layouts.revenues-min-filter')

                    <div class="row flex justify-center pt-8">
                        <div class="grid grid-cols-1 gap-4 col-9">
                            <div>
                                <table class="text-right text-sm w-full">
                                    <tr>
                                        <td class="border-1 border-gray-300 col-4 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">من</div>
                                                <div class="col-6">{{ isset($start) ? $start : '' }}</div>
                                            </div>
                                        </td>
                                        <td class="border-1 border-gray-300 col-4 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">الي</div>
                                                <div class="col-6">{{ isset($end) ? $end : '' }}</div>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <div class="mt-4">
                                <table class="table text-sm w-full" dir="rtl">
                                    <thead>
                                    <tr>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">#</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">الكلية</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">عام</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">خاص</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">تسجيل</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">تأمين</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">غرامة</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">أخرى</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">دمغة</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">الخصومات</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">المجموع</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if (isset($colleges))
                                            <?php
                                            $no = 1;
                                            $totalNotPrivateFees = 0;
                                            $totalPrivateFees = 0;
                                            $totalRegistrationFees = 0.0;
                                            $totalInsuranceFees = 0.0;
                                            $totalPenalty = 0.0;
                                            $totalOtherFees = 0.0;
                                            $totalStamp = 0.0;
                                            $totalDiscount = 0.0;
                                            $_TOTAL = 0.0;
                                            ?>
                                        @foreach ($colleges as $college)
                                            <tr>
                                                <td class="border-1 border-gray-300 text-center">{{ $no }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->name ?? '' }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_not_private_fees ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_private_fees ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_registration_fees ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_insurance_fees ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_penalty ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_other_fees ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_stamp ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">{{ $college->total_discount ?? 0.0 }}</td>
                                                <td class="border-1 border-gray-300 text-center">
                                                    {{
                                                        ($college->total_not_private_fees ?? 0) +
                                                        ($college->total_private_fees ?? 0) +
                                                        ($college->total_registration_fees ?? 0) +
                                                        ($college->total_insurance_fees ?? 0) +
                                                        ($college->total_penalty ?? 0) +
                                                        ($college->total_other_fees ?? 0) +
                                                        ($college->total_stamp ?? 0)
                                                    }}
                                                </td>
                                            </tr>
                                                <?php
                                                $totalNotPrivateFees += $college->total_not_private_fees ?? 0;
                                                $totalPrivateFees += $college->total_private_fees ?? 0;
                                                $totalRegistrationFees += $college->total_registration_fees ?? 0;
                                                $totalInsuranceFees += $college->total_insurance_fees ?? 0;
                                                $totalPenalty += $college->total_penalty ?? 0;
                                                $totalOtherFees += $college->total_other_fees ?? 0;
                                                $totalStamp += $college->total_stamp ?? 0;
                                                $totalDiscount += $college->total_discount ?? 0;
                                                $no++;
                                                ?>
                                        @endforeach
                                            <?php
                                            $_TOTAL = $totalNotPrivateFees + $totalPrivateFees + $totalRegistrationFees +
                                                $totalInsuranceFees + $totalPenalty + $totalOtherFees + $totalStamp - $totalDiscount;
                                            ?>
                                    @endif
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th colspan="2" class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">الإجمالي</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalNotPrivateFees ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalPrivateFees ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalRegistrationFees ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalInsuranceFees ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalPenalty ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalOtherFees ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalStamp ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $totalDiscount ?? 0.0 }}</th>
                                        <th class="border-1 font-bold p-2 text-center text-white" style="background-color: #36304a !important">{{ $_TOTAL ?? 0.0 }}</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- modal --}}
<div hidden>
    <div class="flex justify-center" id="printRevenuesModal">
        <div class="grid grid-cols-1 gap-4">
            <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="">

            <h1 class="font-bold text-2xl text-center">تقرير الطلاب التسجيل الالكتروني</h1>

            <div>
                <table class="text-right text-sm w-full" dir="rtl">
                    <tr>
                        <td class="border-1 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">من</div>
                                <div class="col-6">{{ isset($start) ? $start : '' }}</div>
                            </div>
                        </td>
                        <td class="border-1 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">الي</div>
                                <div class="col-6">{{ isset($end) ? $end : '' }}</div>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>

            <div>
                <table class="text-sm w-full" dir="rtl">
                    <thead>
                        <tr>
                            <th class="col-2">#</th>
                            <th class="col-2">الكلية</th>
                            <th class="col-2">عام</th>
                            <th class="col-2">خاص</th>
                            <th class="col-2">تسجيل</th>
                            <th class="col-2">تأمين</th>
                            <th class="col-2">غرامة</th>
                            <th class="col-2">أخرى</th>
                            <th class="col-2">دمغة</th>
                            <th class="col-2">الخصومات</th>
                            <th class="col-2">المجموع</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ( isset($colleges) )
                            <?php
                                $no = 1;
                                $totalNotPrivateFees = 0;
                                $totalPrivateFees = 0;

                                $totalRegistrationFees = 0.0;
                                $totalInsuranceFees = 0.0;
                                $totalPenalty = 0.0;
                                $totalOtherFees = 0.0;
                                $totalStamp = 0.0;
                                $totalDiscount = 0.0;
                                $_TOTAL = 0.0;
                            ?>
                            @foreach ($colleges as $college)
                                <tr>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $no }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center w-1/2">
                                        {{ $college->name ?? '' }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_not_private_fees ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_private_fees ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_registration_fees ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_insurance_fees ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_penalty ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_other_fees ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_stamp ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_discount ?? 0.0 }}
                                    </td>
                                    <td class="border-1 border-gray-300 col-2 text-center">
                                        {{ $college->total_not_private_fees + $college->total_private_fees + $college->total_registration_fees + $college->total_insurance_fees + $college->total_penalty + $college->total_other_fees + $college->total_stamp }}
                                    </td>
                                </tr>
                                <?php
                                    $totalNotPrivateFees += $college->total_not_private_fees ?? 0;
                                    $totalPrivateFees += $college->total_private_fees ?? 0;

                                    $totalRegistrationFees += $college->total_registration_fees ?? 0;
                                    $totalInsuranceFees += $college->total_insurance_fees ?? 0;
                                    $totalPenalty += $college->total_penalty ?? 0;
                                    $totalOtherFees += $college->total_other_fees ?? 0;
                                    $totalStamp += $college->total_stamp ?? 0; // دمغة
                                    $totalDiscount += $college->total_discount ?? 0; // دمغة
                                    $no++;
                                    ?>
                            @endforeach
                            <?php $_TOTAL = $totalNotPrivateFees + $totalPrivateFees + $totalRegistrationFees + $totalInsuranceFees + $totalPenalty + $totalOtherFees + $totalStamp - $totalDiscount; ?>
                        @endif
                    </tbody>
                </table>
            </div>

            <div class="text-right text-sm w-full" dir="rtl">
                <div class="row border">
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع رسوم العام</div>
                        <hr>
                        <div>{{ $totalNotPrivateFees ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع رسوم الخاص</div>
                        <hr>
                        <div>{{ $totalPrivateFees ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع رسوم التسجيل</div>
                        <hr>
                        <div>{{ $totalRegistrationFees ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع رسوم التامين</div>
                        <hr>
                        <div>{{ $totalInsuranceFees ?? 0 }}</div>
                    </div>
                </div>
                <br>
                <div class="row border">
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع الغرامات</div>
                        <hr>
                        <div>{{ $totalPenalty ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع الرسوم الاخرى</div>
                        <hr>
                        <div>{{ $totalOtherFees ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع الدمغة</div>
                        <hr>
                        <div>{{ $totalStamp ?? 0 }}</div>
                    </div>
                    <div class="col-3 p-0 text-center border">
                        <div>مجموع الخصومات</div>
                        <hr>
                        <div>{{ $totalDiscount ?? 0 }}</div>
                    </div>
                </div>
                <br>
                <div class="row border">
                    <div class="col-12 p-0 text-center border">
                        <div>المجموع الكلي</div>
                        <hr>
                        <div>{{ $_TOTAL ?? 0 }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>
<script src="{{ asset('plugins/datatable/js/moment.min.js') }}"></script>
<script src="{{ asset('plugins/datatable/js/dateTime.min.js') }}"></script>
<script src="{{ asset('js/divjs.js') }}"></script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch, #bank, #admission, #constraint, #paymentCurrency').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });

        $('#printRevenuesBtn2').click(function(){
            $('#printRevenuesModal').printElement();
        });
    });



</script>

<script>
    $(document).ready(function () {
        $('#printRevenuesBtn').click(function(){
            const url = new URL("{{ route('print.revenue-min') }}", window.location.origin);

            // optionally append filters or parameters
            // Pass filter values, not students
            url.searchParams.append('from', '{{ request()->get("from") }}');
            url.searchParams.append('to', '{{ request()->get("to") }}');
            url.searchParams.append('bank_id', '{{ request()->get("bank_id") }}');
            url.searchParams.append('currency_id', '{{ request()->get("currency_id") }}');

            window.open(url.toString(), '_blank');
        });
    });



    {{--document.getElementById('printRevenuesBtn').addEventListener('click', function () {--}}
    {{--    console.log('printRevenuesBtn');--}}
    {{--    const url = new URL("{{ route('attendance.print') }}", window.location.origin);--}}

    {{--    // optionally append filters or parameters--}}
    {{--    // url.searchParams.append('college_id', ...);--}}

    {{--    window.open(url.toString(), '_blank');--}}
    {{--});--}}
</script>

@endsection
