@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

    <style>
        .html5buttons{
            direction: ltr;
            position: absolute;
            top: -45px;
            left: 10px;
        }
        .html5buttons .btn-secondary{
            color:  #ffffff;
            background-color:#295694;
        }

        .html5buttons .buttons-print{
            background-color: rgb(167, 32, 53);
            color: white;
        }

        .dataTables_filter{
            margin: 20px 0px 20px;
        }
        #min, #max {
            max-width: 150px;
            min-width: unset;
            font-size: 12px;
            font-weight: 400;
            text-align: center;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #ced4da !important;
            border-radius: 0.25rem;
            min-height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
        }
        .dt-datetime-year, .dt-datetime-month{
            min-width: unset !important;
            width: 50px !important;
            max-height: 22px !important;
        }

        .dropdown-menu .dropdown-item {
            text-align: right !important;
        }

        tfoot{
        background-color:#36304a !important;
        }

        tfoot p{
            color: white !important;
            font-size: 12px !important;
            font-weight: 100 !important;
        }

        #printRevenuesModal td,
        #printRevenuesModal th{
            border: black 2px solid;
            color: black;
        }

        input[type='text'],
        input[type='date'],
        input[type='number'],
        select,
        input[type='text']:focus,
        input[type='date']:focus,
        input[type='number']:focus,
        input[type='text']:focus-visible,
        input[type='date']:focus-visible
        {
            width: unset;
        }

        #printRevenuesModal img{
            width: 1122.5px;
            height: 135px;
        }

        #printRevenuesModal .student-name{
            width: 40%;
            text-align: right;
            padding-right: 20px;
        }
    </style>

    <link rel="stylesheet" href="{{ asset('plugins/datatable/css/dateTime.min.css') }}">
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.students-revenues') }}

                    <button class="btn btn-secondary" id="printRevenuesBtn">
                        طباعة
                    </button>
                </div>

                <div class="card-body">
                    @include('layouts.filter')

                    <div class="row flex justify-center pt-8">
                        <div class="grid grid-cols-1 gap-4 col-8">
                            <div>
                                <table class="text-right text-sm w-full">
                                    <tr>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">الكلية</div>
                                                <div class="col-6">
                                                    {{ isset($college) ? $college->name : '' }}
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">الدفعة</div>
                                                <div class="col-6">
                                                    {{ isset($batch) ? $batch->value : '' }}
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">القسم</div>
                                                <div class="col-6">
                                                    {{ isset($section) ? $section->name : '' }}
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">البرنامج</div>
                                                <div class="col-6">
                                                    {{ isset($program) ? $program->name : '' }}
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @if (auth()->user()->hasRole(['financial', 'admin']))
                                    <tr>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">نوع القبول</div>
                                                <div class="col-6">
                                                    {{ isset($admission) ? $admission->name : '' }}
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">البنك</div>
                                                <div class="col-6">
                                                    {{ isset($bank) ? $bank->name : '' }}
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">من</div>
                                                <div class="col-6">{{ isset($start) ? $start : '' }}</div>
                                            </div>
                                        </td>
                                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                                            <div class="flex justify-around row">
                                                <div class="col-6">الي</div>
                                                <div class="col-6">{{ isset($end) ? $end : '' }}</div>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <div>
                                <table class="text-sm w-full" dir="rtl">
                                    <thead>
                                        <tr>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">#</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">رقم الطالب</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">اسم الطالب</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">التامين الصحي</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">رسوم التسجيل</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">الرسوم الدراسية</th>
                                            <th class="border-2 col-2 font-bold p-2 text-center text-white">الخصومات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if ( isset($payments) )
                                            <?php
                                                $no = 1;
                                                $totalInsuranceFees = 0;
                                                $totalRegistrationFees = 0;
                                                $totalStudyFees = 0;
                                                $totalDiscount = 0;
                                            ?>
                                            @foreach ($payments as $payment)
                                                <tr>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $no }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $payment->student_id ?? '' }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center w-2/6">
                                                        {{ $payment->student_name ?? '' }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $payment->p_insurance_fees ?? 0.0 }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $payment->p_registration_fees ?? 0.0 }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $payment->p_study_fees ?? 0.0 }}
                                                    </td>
                                                    <td class="border-2 border-gray-300 col-2 text-center">
                                                        {{ $payment->p_discount ?? 0.0 }}
                                                    </td>
                                                </tr>
                                                <?php
                                                    $totalInsuranceFees += $payment->p_insurance_fees ?? 0;
                                                    $totalRegistrationFees += $payment->p_registration_fees ?? 0;
                                                    $totalStudyFees += $payment->p_study_fees ?? 0;
                                                    $totalDiscount += $payment->p_discount ?? 0;
                                                    $no++;
                                                ?>
                                            @endforeach
                                            <tr>
                                                <td colspan="3" class="border-2 border-gray-300 col-2 text-center text-black font-bold">المجموع</td>
                                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalInsuranceFees }}</td>
                                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalRegistrationFees}}</td>
                                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalStudyFees != 0 ? $totalStudyFees / 2 : 0.0 }}</td>
                                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalDiscount }}</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            @if (auth()->user()->hasRole(['financial', 'admin']))
                            <div id="footer">
                                <table class="text-right text-sm w-full">
                                    <thead>
                                        <tr>
                                            <th class="col-2 font-bold text-center"></th>
                                            <th class="border-2 col-2 font-bold px-1 py-2 text-right text-white" colspan="4">
                                                <div class="flex justify-around">
                                                    <div>مجموع المطلوبات</div>
                                                    <div>{{ $totalFees ?? 0 }}</div>
                                                </div>
                                            </th>
                                            <th class="col-2 font-bold text-center"></th>
                                        </tr>
                                        <tr>
                                            <th class="col-2 font-bold text-right"></th>
                                            <th class="border-2 col-2 font-bold px-1 py-2 text-right text-white" colspan="4">
                                                <div class="flex justify-around">
                                                    <div>مجموع الإيرادات</div>
                                                    <div>{{ $totalPayments ?? 0 }}</div>
                                                </div>
                                            </th>
                                            <th class="col-2 font-bold text-center"></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- modal --}}
<div hidden>
    <div class="flex justify-center" id="printRevenuesModal">
        <div class="grid grid-cols-1 gap-4">
            <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="">

            <h1 class="font-bold text-2xl text-center">تقرير الطلاب التسجيل الالكتروني</h1>

            <div>
                <table class="text-right text-sm w-full" dir="rtl">
                    <tr>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">الكلية</div>
                                <div class="col-6">
                                    {{ isset($college) ? $college->name : '' }}
                                </div>
                            </div>
                        </td>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">الدفعة</div>
                                <div class="col-6">
                                    {{ isset($batch) ? $batch->value : '' }}
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">القسم</div>
                                <div class="col-6">
                                    {{ isset($section) ? $section->name : '' }}
                                </div>
                            </div>
                        </td>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">البرنامج</div>
                                <div class="col-6">
                                    {{ isset($program) ? $program->name : '' }}
                                </div>
                            </div>
                        </td>
                    </tr>
                    @if (auth()->user()->hasRole('financial'))
                    <tr>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">نوع القبول</div>
                                <div class="col-6">
                                    {{ isset($admission) ? $admission->name : '' }}
                                </div>
                            </div>
                        </td>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">البنك</div>
                                <div class="col-6">
                                    {{ isset($bank) ? $bank->name : '' }}
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endif
                    <tr>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">من</div>
                                <div class="col-6">{{ isset($start) ? $start : '' }}</div>
                            </div>
                        </td>
                        <td class="border-2 border-gray-300 col-6 font-bold p-2 px-3 text-right">
                            <div class="flex justify-around row">
                                <div class="col-6">الي</div>
                                <div class="col-6">{{ isset($end) ? $end : '' }}</div>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>

            <div>
                <table class="text-sm w-full" dir="rtl">
                    <thead>
                        <tr>
                            <th class="col-2">#</th>
                            <th class="col-2">رقم الطالب</th>
                            <th class="col-2">اسم الطالب</th>
                            <th class="col-2">التامين الصحي</th>
                            <th class="col-2">رسوم التسجيل</th>
                            <th class="col-2">الرسوم الدراسية</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ( isset($payments) )
                            <?php
                                $no = 1;
                                $totalInsuranceFees = 0;
                                $totalRegistrationFees = 0;
                                $totalStudyFees = 0;
                            ?>
                            @foreach ($payments as $payment)
                                <tr>
                                    <td class="col-2 text-center">
                                        {{ $no }}
                                    </td>
                                    <td class="col-2 text-center">
                                        {{ $payment->student_id }}
                                    </td>
                                    <td class="col-2 w-2/6 student-name">
                                        {{ $payment->student_name ?? '' }}
                                    </td>
                                    <td class="col-2 text-center">
                                        {{ $payment->p_insurance_fees ?? 0.0 }}
                                    </td>
                                    <td class="col-2 text-center">
                                        {{ $payment->p_registration_fees ?? 0.0 }}
                                    </td>
                                    <td class="col-2 text-center">
                                        {{ $payment->p_study_fees ?? 0.0 }}
                                    </td>
                                </tr>
                                <?php
                                    $totalInsuranceFees += $payment->p_insurance_fees ?? 0;
                                    $totalRegistrationFees += $payment->p_registration_fees ?? 0;
                                    $totalStudyFees += $payment->p_study_fees ?? 0;
                                    $no++;
                                ?>
                            @endforeach
                            <tr>
                                <td colspan="3" class="border-2 border-gray-300 col-2 text-center text-black font-bold">المجموع</td>
                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalInsuranceFees }}</td>
                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalRegistrationFees}}</td>
                                <td class="border-2 border-gray-300 col-2 text-center text-black font-bold">{{ $totalStudyFees != 0 ? $totalStudyFees / 2 : 0.0 }}</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>

            @if (auth()->user()->hasRole('financial'))
                <div id="footer" style="padding-top: 10px; padding-bottom: 0px;">
                    <table class="text-right text-sm w-full">
                        <thead dir="rtl">
                            <tr>
                                <th class="col-2 font-bold text-center"></th>
                                <th class="border-2 col-2 font-bold px-1 py-2 text-right" colspan="4">
                                    <div class="flex justify-around">
                                        <div>مجموع المطلوبات</div>
                                        <div>{{ $totalFees ?? 0 }}</div>
                                    </div>
                                </th>
                                <th class="col-2 font-bold text-center"></th>
                            </tr>
                            <tr>
                                <th class="col-2 font-bold text-right"></th>
                                <th class="border-2 col-2 font-bold px-1 py-2 text-right" colspan="4">
                                    <div class="flex justify-around">
                                        <div>مجموع الإيرادات</div>
                                        <div>{{ $totalPayments ?? 0 }}</div>
                                    </div>
                                </th>
                                <th class="col-2 font-bold text-center"></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endif
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>
<script src="{{ asset('plugins/datatable/js/moment.min.js') }}"></script>
<script src="{{ asset('plugins/datatable/js/dateTime.min.js') }}"></script>
<script src="{{ asset('js/divjs.js') }}"></script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch, #bank, #admission, #constraint, #paymentCurrency').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });

        $('#printRevenuesBtn').click(function(){
            $('#printRevenuesModal').printElement();
        });
    });
</script>
@endsection
