@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
    <style>
        .html5buttons{
            direction: ltr;
            position: absolute;
            top: -73px;

            left: 10px;
        }
        .html5buttons .btn-secondary{
            color:  #ffffff;
            background-color:#295694;
        }

        .html5buttons .buttons-print{
            background-color: rgb(167, 32, 53);
            color: white;
        }

        #min, #max {
            max-width: 150px;
            min-width: unset;
            font-size: 12px;
            font-weight: 400;
            text-align: center;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            min-height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
        }
        @media print {
            thead { display: table-header-group; }
            tfoot { display: table-footer-group; }
        }
    </style>

    <link rel="stylesheet" href="{{ asset('plugins/datatable/css/dateTime.min.css') }}">
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.student-fees') }} : {{$studentName ?? ''}}
                </div>

                <div class="card-body">

                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr class="table100-head">
                                    <th class="text-xs">
                                        {{ __('fee.code') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.type') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.note') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.amount') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.paid') }}
                                    </th>
                                    {{-- <th class="text-xs">
                                        {{ __('fee.penalty') }}
                                    </th> --}}
                                    <th class="text-xs">
                                        {{ __('fee.created-at') }}
                                    </th>
                                    @if (auth()->user()->role_id == 1 ||  auth()->user()->hasrole('registrar') )
                                        <th class="text-xs">
                                            {{ __('fee.actions') }}
                                        </th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-500">
                                @if (isset($studentFees))
                                @foreach ($studentFees as $studentFee)
                                <tr class="whitespace-nowrap">
                                    <td class="text-sm text-center text-black">
                                        {{ $studentFee->payment_reference }}
                                    </td>
                                    <td class="text-center">
                                        <div class="text-sm text-gray-900">
                                            {{ $studentFee->semester_id }}
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        {{ $studentNotes }}
                                    </td>
                                    <td class="text-center">
                                        {{-- {{ $studentFee->payment_amount + $studentFee->pivot->penalty }} --}}
                                        {{ $studentFee->payment_amount }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentFee->paid_amount }}
                                    </td>
                                    {{-- <td class="text-center">
                                        {{ $studentFee->pivot->penalty }}
                                    </td> --}}
                                    <td class="text-center">
                                        {{ $studentFee->created_at }}
                                    </td>
                                    @if (auth()->user()->hasRole('admin') || auth()->user()->hasRole('registrar'))
                                        @if ($studentFee->paid_amount == 0)
                                            <td class="text-2xl text-center">
                                                <a href="{{ route('fee.edit', ['fee' => $studentFee->payment_reference]) }}" id="editFee2">
                                                    <i class="fas fa-edit text-primary"></i>
                                                </a>
                                                <a class="deleteFee" data-id="{{ $studentFee->payment_reference }}">
                                                    <i class="fas fa-trash-alt text-danger"></i>
                                                </a>
                                            </td>
                                        @else
                                            <td></td>
                                        @endif
                                    @endif
                                </tr>
                                @endforeach
                                @else
                                <tr class="whitespace-nowrap">
                                    <td>no data</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <!-- end of studentsListTable-->

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": false,
            "paging": false,
            "ordering": false,
            "info": false,
            // dom: 'Bfrtip',
            dom: '<"html5buttons"B>lTfgt<"row"<"col-md-6"i><"col-md-6"p>>',
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],
            // "buttons": ["print"],
            'buttons': [{
                extend: 'print',
                footer: true,
                autoPrint: true,

                customize: function ( win ) {
                    $(win.document.body).css('direction', 'rtl');
                    // $(win.document.body).css( 'font-size', '10pt' ).prepend('<img src="http://datatables.net/media/images/logo-fade.png" style="position:absolute; top:0; left:0;" />');
                    // $(win.document.body).find( 'table' ).addClass( 'compact' ).css( 'font-size', 'inherit' );                },
                    $(win.document.body).find( 'table' ).css( 'text-align', 'center' );

                },
                exportOptions: {
                    columns: [0, 1, 2, 3]
                },
            }],

            "oLanguage": {
                "sSearch": "بحث ",
            },
            // drawCallback: function () {
            //     var api = this.api();
            //     $( api.table().footer() ).html(
            //         '<th>'+
            //             '{{ __('report.total') }}'+
            //             ' = '+ api.column( 0, {page:'current'} ).data().sum()+
            //         '</th>'+
            //         '<th>'+
            //             '{{ __('report.total') }}'+
            //             ' = '+ api.column( 1, {page:'current'} ).data().sum()+
            //         '</th>'+
            //         '<th></th>'+
            //         '<th></th>'
            //     );
            // },
        });
        $('.buttons-print').html('طباعة');

        $('#deleteFee').click(function (e) {
            e.preventDefault();

            Swal.fire({
                icon: 'warning',
                title: 'عملية حذف!',
                text: 'هل تريد حذف هذه الدفعية فعلا؟',
                showDenyButton: true,
                confirmButtonText: 'نعم',
                denyButtonText: `لا`,
                }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    Swal.fire(
                        'قيد التصميم!',
                        'سيم اضافة هذا القسم قريبا',
                        'question'
                    );

                    // var id = $(this).data("id");
                    // var studentId = $(this).data("studentId");
                    // var token = $("meta[name='csrf-token']").attr("content");

                    // $.ajax({
                    //     url: "{{ route('fee.destroy', ['fee' => isset($studentFee->code), 'student_id' => isset($studentId) ] ) }}",
                    //     type: 'DELETE',
                    //     data: {
                    //         "id": id,
                    //         "_token": token,
                    //     },
                    //     success: function (data){
                    //         console.log(data);
                    //         Swal.fire(
                    //             'عملية ناجحة!',
                    //             'تم حذف الدفعية بنجاح!',
                    //             'success'
                    //         ).then( () => {
                    //             location.reload();
                    //         });
                    //     }
                    // });
                }
            });
        });

        $("#addFee, #editFee").each(function(){
            $($(this)).click(function (e) {
                e.preventDefault();

                Swal.fire(
                    'قيد التصميم!',
                    'سيم اضافة هذا القسم قريبا',
                    'question'
                );
            });
        });

    }); // end of ready
</script>
@endsection
