@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
    <style>
        .html5buttons{
            direction: ltr;
            position: absolute;
            top: -73px;

            left: 10px;
        }
        .html5buttons .btn-secondary{
            color:  #ffffff;
            background-color:#295694;
        }


        #min, #max {
            max-width: 150px;
            min-width: unset;
            font-size: 12px;
            font-weight: 400;
            text-align: center;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            min-height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
        }
        @media print {
            thead { display: table-header-group; }
            tfoot { display: table-footer-group; }
        }

        tfoot{
            background-color: #36304a !important;
            color: #fff;
        }

        table.dataTable>thead>tr>th:not(.sorting_disabled){
            padding-right: 30px !important;
        }
    </style>

    <link rel="stylesheet" href="{{ asset('plugins/datatable/css/dateTime.min.css') }}">
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('report.student-payments') }} : {{ isset($student_name) ? $student_name : '' }}

                    <button class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none" id="printRevenuesBtn">
                        طباعة
                    </button>
                </div>

                <div class="card-body">

                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr class="table100-head">
                                    <th class="text-xs" hidden>
                                        {{ __('student.id') }}
                                    </th>
                                    <th class="text-xs" hidden>
                                        {{ __('student.name') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.transaction-reference') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.fee-amount') }}
                                    </th>
                                    <th class="text-xs">
                                        نوع العملة
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.semester') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.payment-date') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white">
                                @if (isset($studentPayments))
                                    @foreach ($studentPayments as $studentPayment)
                                        <tr class="whitespace-nowrap">
                                            <td class="text-center" hidden>
                                                {{ $studentPayment->student_id }}
                                            </td>
                                            <td class="text-center" hidden>
                                                {{ $studentPayment->student_name }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->transaction_ref }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->payment_amount }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->payment_currency }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->semester ? $studentPayment->semester->name : __('student.not-set') }}
                                            </td>
                                            <td class="text-center">
                                                {{ $studentPayment->created_at}}
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                <tr class="whitespace-nowrap">
                                    <td>no data</td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot class="bg-gray-100">
                                <tr>
                                    <th></th>
                                    <th>
                                        {{ __('report.total') . ' = ' . $totalPaid  }}
                                    </th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </tfoot>

                        </table>
                    </div><!-- end of studentsListTable-->

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": false,
            "paging": false,
            "ordering": false,
            "info": false,
            'buttons': [{
                extend: 'print',
                footer: true,
                autoPrint: true,

                customize: function ( win ) {
                    $(win.document.body).css('direction', 'rtl');
                    $(win.document.body).find( 'table' ).css( 'text-align', 'center' );

                },
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6]
                },
            }],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });
    });
</script>
@endsection
