@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
    <style>
        tfoot{
            background-color: #36304a;
        }

        table.dataTable>thead>tr>th:not(.sorting_disabled){
            padding-right: 30px !important;
        }
    </style>
@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('settings.activities-log') }}
            </h3>
        </div>
        <div class="p-6 space-y-6">
            <div class="custom-filter row">
{{--                <form action="{{ route('settings.filter-activity-log') }}" method="post" id="filterForm">--}}
                <form action="" method="post" id="filterForm">
                    @csrf

                    @include('layouts.activity-filter')

                    <div class="row flex justify-center space-x-2 mt-4">
                        <div class="col-4 flex justify-center px-1">
                            <button type="submit" style="background-color: #36304a;" class="mr-3 px-4 py-2 rounded-2 text-white btn" id="studentFilter" name="filter">
                                {{__('student.apply-filter') }}
                            </button>
                            <a href="{{ route('settings.activity-log') }}" style="background-color: #36304a;" class="bg-danger btn mr-3 px-4 py-2 rounded-2 text-white" id="studentFilter">
                                {{__('student.reset') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            <div class="card-body">
                <div id="studentsListTable" class="mt-4">
                    <table class="table" id="studentsTable" style="width: 100%;">
                        <thead>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    رقم
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    النشاط
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    المؤثر
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    المتأثر
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    الحدث
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    التاريخ
                                </th>
                            </tr>
                        </thead>
                        <tbody id="studentsList">
                            @if (isset($activities) && $activities != '[]')
                            <?php $no = 1; ?>
                            @foreach ($activities as $activity)
                            <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    {{ $no ?? ''}}
                                </th>
                                <td class="py-2 text-center">
                                    <?php
                                        if($activity->log_name == 'student') {
                                            $logName = 'طالب';
                                        } elseif ($activity->log_name == 'registration') {
                                            $logName = 'دفعية طالب';
                                        } elseif ($activity->log_name == 'payment'){
                                            $logName = 'سداد دفعية';
                                        }
                                    ?>
                                    {{ $logName ?? '' }}
                                </td>
                                <td class="py-2 text-center">
                                {{ $activity->user_name }}
                                </td>
                                <td class="py-2 text-center">
                                    {{ $activity->student_id }}
                                </td>
                                <td class="py-2 text-center">
                                    <?php
                                        if($activity->event == 'created') {
                                            $evenName = 'إضافة';
                                            $class = 'alert alert-success';
                                        } elseif ($activity->event == 'updated') {
                                            $evenName = 'تعديل';
                                            $class = 'alert alert-primary';
                                        } elseif ($activity->event == 'deleted'){
                                            $evenName = 'حذف';
                                            $class = 'alert alert-danger';
                                        }
                                    ?>
                                    <div class="{{$class ?? ''}} p-1 m-0 max-w-xs mx-auto" role="alert" style="max-width: 100px;">{{ $evenName ?? '' }} </div>
                                </td>
                                <td class="py-2 text-center">
                                    {{ $activity->created_at ?? '' }}
                                </td>
                            </tr>

                            <?php $no += 1; ?>
                            @endforeach
                            @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    رقم
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    النشاط
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    المؤثر
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    المتأثر
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    الحدث
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    التاريخ
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('scripts')

<script src="{{ asset('plugins/datatable/js/sum().js') }}"></script>
<script src="{{ asset('plugins/datatable/js/moment.min.js') }}"></script>
<script src="{{ asset('plugins/datatable/js/dateTime.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });


        $('#min, #max').on('change', function () {
            dataTable.draw();
        });
        // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        $(".section-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".program-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-year-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".semester-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $('.buttons-print').html('طباعة');
    }); // End of $(document).ready

</script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch, #bank, #admission, #constraint').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });
    });
</script>
@endsection
