@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    select:disabled {
        background-color: rgba(0, 0, 0, 0.3);
    }


    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    إدارة التسجيل
                </div>
                <div class="card-body">
                    <!-- Students table-->
                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الفصل الدراسي
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نهاية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الاجراء
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if ($registrations)
                                @foreach ($registrations as $registration)
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <th scope="row"
                                        class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                        {{ $registration->college }}
                                    </th>
                                    <td class="py-2 text-center">
                                        {{ $registration->batch }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $registration->semester }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $registration->start }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $registration->end }}
                                    </td>

                                    <td class="py-2 text-center showStudent" style="max-width: 100px;">
                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full showRegistration"
                                            style="background-color: hsl(254, 21%, 24%)"
                                            data-modal-toggle="showRegistrationModal" data-id="{{ $registration->id }}">
                                            <i class="fa fa-eye bg-white p-1 rounded-full text-success"
                                                aria-hidden="true"></i>
                                        </a>

                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full editRegistration"
                                            style="background-color: #36304a"
                                            {{-- data-modal-toggle="editRegistrationModal" --}}
                                            data-id="{{ $registration->id }}">
                                            <i class="fa fa-edit bg-white p-1 rounded-full text-secondary"
                                                aria-hidden="true"></i>
                                        </a>

                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full deleteRegistration"
                                            style="background-color: #36304a" data-id="{{ $registration->id }}">
                                            <i class="fa fa-trash bg-white p-1 rounded-full text-danger"
                                                aria-hidden="true"></i>
                                        </a>
                                    </td>

                                </tr>
                                @endforeach
                                @else
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <td class="py-2 text-center" colspan="6">
                                        {{ __('no-students') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الفصل الدراسي
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نهاية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الاجراء
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modals --}}
<div class="modal fade" id="editRegistrationModal" tabindex="-1" role="dialog" aria-labelledby="editRegistrationModalTitle" aria-hidden="true">
    <div class="min-w-full modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header flex items-start justify-center border-b rounded-t dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                <div class="card-header flex justify-between p-3 text-blue-700">
                    تعديل المجموعة
                </div>
            </h3>
          </button>
        </div>
        <form action="{{ route('registration-management.update') }}" method="post">
            @csrf
            @method('PUT')

            <div class="modal-body px-3 py-2 space-y-6">
                <div class="overflow-x-auto relative shadow-md sm:rounded-lg">
                    <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>
                                <th scope="col" class="py-2 px-2">
                                    الكلية
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    القسم
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    الفصل الدراسي
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    الدفعة
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    بداية التسجيل
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    نهاية التسجيل
                                </th>
                                <th scope="col" class="py-2 px-2">
                                    مقدار الدمغة
                                </th>
                            </tr>
                        </thead>
                        <tbody id="studentsList">
                            <td class="py-2 text-center col-4">
                                <!--  الكلية -->
                                <select id="college" name="college_id"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="0">{{ __('student.choose-college') }}</option>
                                    @if ( isset($colleges) )
                                    @foreach ($colleges as $college)
                                    <option value="{{ $college->id }}" {{ isset($college_id) &&
                                        $college_id == $college->id ? 'selected' : '' }} class="college-options">
                                        {{ $college->name }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                            </td>
                            <td class="py-2 text-center col-2">
                                <!--  القسم -->
                                <select id="section" name="section_id"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    disabled>
                                    <option value="0">{{ __('student.choose-section') }}</option>
                                    @if ( isset($sections) )
                                    @foreach ($sections as $section)
                                    <option value="{{ $section->id }}" {{ isset($section_id) &&
                                        $section_id == $section->id ? 'selected' : '' }}>
                                        {{ $section->name }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                            </td>
                            <td class="py-2 text-center col-2">
                                <!--  البرنامج -->
                                <select id="program" name="program_id"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    disabled>
                                    <option value="0">{{ __('student.choose-program') }}</option>
                                    @if ( isset($programs) )
                                    @foreach ($programs as $program)
                                    <option value="{{ $program->id }}" {{ isset($program_id) &&
                                        $program_id==$program->id ? 'selected' : '' }}>
                                        {{ $program->name }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                            </td>
                            <td class="py-2 text-center col-2">
                                <!-- الدفعة -->
                                <select id="batch" name="batch_id"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="0">{{ __('student.choose-batch') }}</option>
                                    @if ( isset($batches) )
                                    @foreach ($batches as $batch)
                                    <option value="{{ $batch->id }}" {{ isset($batch_id) && $batch_id==$batch->id ?
                                        'selected' : '' }}>
                                        {{ $batch->value }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                            </td>
                            <td class="py-2 text-center col-2">
                                <input type="date" name="registration_start" id="registrationStart" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                            </td>
                            <td class="py-2 text-center col-2">
                                <input type="date" name="registration_end" id="registrationEnd" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            </td>
                            <td class="py-2 text-center col-2">
                                <input type="text" name="stamp" id="registrationStamp" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            </td>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer flex justify-center">
                <button type="submit"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 ml-3">
                    حفظ
                </button>
                <button data-bs-dismiss="modal" type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-4 py-2 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                    الغاء
                </button>
            </div>
            </div>
        </form>
      </div>
    </div>
  </div>

<div id="showRegistrationModal2" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full hidden">
    <div class="relative w-full h-full max-w-8xl md:h-auto">
        <!-- Modal content -->
        <div class="overflow-x-auto relative shadow-md sm:rounded-lg mt-8">
            <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                <thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                    <tr>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.id') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.name') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.college') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.section') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.program') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.batch') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.registration-fees') }}
                        </th>
                        <th scope="col" class="py-2 px-2">
                            {{ __('student.tuition-fees') }}
                        </th>
                    </tr>
                </thead>
                <tbody id="showStudentsList2"></tbody>
                <tfoot class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                    <tr>
                        <th scope="col" class="py-1 px-1" colspan="2" style="direction: ltr;">
                            {{-- {{ $students->links() }} --}}
                        </th>
                        <th colspan="7"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<div id="showRegistrationModal" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full md:h-screen">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    مجموعة الطلاب
                </h3>
                <button type="button"
                    class="bg-gray-300 text-danger"
                    data-modal-toggle="showRegistrationModal">
                    <svg aria-hidden="true" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.id') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.name') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.college') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.section') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.program') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.batch') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.registration-fees') }}
                            </th>
                            <th scope="col" class="py-2 px-2">
                                {{ __('student.tuition-fees') }}
                            </th>
                        </tr>
                    </thead>
                    <tbody id="showStudentsList"></tbody>
                    <tfoot class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="py-1 px-1" colspan="2" style="direction: ltr;">
                                {{-- {{ $students->links() }} --}}
                            </th>
                            <th colspan="7"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                {{-- <button data-modal-toggle="showRegistrationModal" type="button"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">I
                    accept</button>
                <button data-modal-toggle="showRegistrationModal" type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">Decline</button> --}}
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });

        $('.deleteRegistration').click(function (e) {
            e.preventDefault();

            Swal.fire({
                icon: 'warning',
                title: 'عملية حذف!',
                text: 'هل تريد حذف هذه المجموعة حقا؟',
                showDenyButton: true,
                confirmButtonText: 'نعم',
                denyButtonText: `لا`,
                }).then((result) => {

                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    var id = $(this).data("id");
                    var token = $("meta[name='csrf-token']").attr("content");

                    $.ajax({
                        url: "{{ url('registration-management') }}" + "/" + id,
                        type: 'DELETE',
                        data: {
                            "_token": token,
                        },
                        success: function (data){
                            console.log(data);
                            Swal.fire(
                                'عملية ناجحة!',
                                'تم حذف الدفعية بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        },
                        error: function (data){
                            Swal.fire(
                                'عملية غير ناجحة!',
                                'لم يتم ايجاد المجموعة',
                                'error'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    });
                }
            });
        });


        $('#studentsTable tbody').on('click', '.editRegistration', function (e) {
            e.preventDefault();
            let id = $(this).data('id');

            $.ajax({
                type: "get",
                url: "registration-management/" + id + "/edit",
                success: function (response) {
                    response.sections.forEach(element => {
                        $("#section").append(`
                            <option value="${element.id}"> ${element.name} </option>
                        `);
                    });

                    $('#registrationId').val(response.id);

                    $("#college option[value="+response.college_id+"]").attr('selected', 'selected');
                    $("#section option[value="+response.section_id+"]").attr('selected', 'selected');
                    $("#program option[value="+response.program_id+"]").attr('selected', 'selected');
                    $("#batch option[value="+response.batch_id+"]").attr('selected', 'selected');
                    $('#registrationStart').val(response.start);
                    $('#registrationEnd').val(response.end);
                    $('#registrationStamp').val(response.stamp);
                }
            });

            $('#editRegistrationModal').modal('toggle');
        });

        $('#studentsTable tbody').on('click', '.showRegistration', function () {
            let id = $(this).data('id');
            $.ajax({
                type: "get",
                url: "registration-management/" + id + "/show",
                success: function (response) {
                    $('#showStudentsList').html('');
                    response.forEach(element => {
                        $('#showStudentsList').append(`
                            <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    ${element.student_id}
                                </th>
                                <td class="py-2 text-center">
                                    ${element.student_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.college_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.section_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.program_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.batch_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.registration_fees}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.program_fees}
                                </td>
                            </tr>
                        `);
                    });
                }
            });
        });

        $('#college').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('college.sections') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#section').html('<option value="0">{{ __("student.choose-section") }}</option>');
                    $(response).each(function (index, element) {
                        $('#section').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                }
            });
        });

        // $('.showRegistration').change(function (e) {
        //     e.preventDefault();

        //     $('#showRegistrationModal').hasClass('flex') ? $('#showRegistrationModal').removeClass('flex') : '';
        // });


    });

</script>
@endsection
