@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    select:disabled {
        background-color: rgba(0, 0, 0, 0.3);
    }

    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    فرض قيود على التسجيل

                    <button type="button"
                        data-modal-toggle="createRegistrationModal"
                        class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none">
                        <i class="fa fa-plus" aria-hidden="true"></i>
                        إضافة قيد جديد
                    </button>
                </div>
                <div class="card-body">
                    <!-- Students table-->
                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نهاية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الاجراء
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if ($registrations)
                                @foreach ($registrations as $registration)
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <th scope="row"
                                        class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                        {{ $registration->college ? $registration->college->name : '' }}
                                    </th>
                                    <td class="py-2 text-center">
                                        {{ $registration->batch ? $registration->batch->value : '' }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $registration->start }}
                                    </td>
                                    <td class="py-2 text-center">
                                        {{ $registration->end }}
                                    </td>

                                    <td class="py-2 text-center showStudent" style="max-width: 100px;">
                                        {{-- <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full showRegistration"
                                            style="background-color: hsl(254, 21%, 24%)"
                                            data-modal-toggle="showRegistrationModal" data-id="{{ $registration->id }}">
                                            <i class="fa fa-eye bg-white p-1 rounded-full text-success"
                                                aria-hidden="true"></i>
                                        </a> --}}

                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full editRegistration"
                                            style="background-color: #36304a" data-modal-toggle="editRegistrationModal"
                                            data-id="{{ $registration->id }}">
                                            <i class="fa fa-edit bg-white p-1 rounded-full text-secondary"
                                                aria-hidden="true"></i>
                                        </a>

                                        <a class="px-2 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full deleteRegistration"
                                            style="background-color: #36304a" data-id="{{ $registration->id }}">
                                            <i class="fa fa-trash bg-white p-1 rounded-full text-danger"
                                                aria-hidden="true"></i>
                                        </a>
                                    </td>

                                </tr>
                                @endforeach
                                @else
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <td class="py-2 text-center" colspan="6">
                                        {{ __('no-students') }}
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        نهاية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        الاجراء
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $registrations->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modals --}}
<div id="createRegistrationModal" tabindex="-1" aria-hidden="true"
    class="fixed top-20 left-0 right-0 z-50 w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full hidden">
    <div class="relative w-full h-full max-w-6xl md:h-auto">
        <!-- Modal content -->
        <form action="{{ route('settings.registration.constraint.store') }}" method="post">
            @csrf
            @method('POST')
            <input type="hidden" name="id" value="" id="registrationId">
            <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-start justify-center border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        <div class="card-header flex justify-between p-3 text-blue-700">
                            إضافة
                        </div>
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="px-3 py-2 space-y-6 flex justify-center">
                    <div class="overflow-x-auto relative shadow-md sm:rounded-lg col-12">
                        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                            <thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                                <tr>
                                    <th scope="col" class="py-2 px-2">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        نهاية التسجيل
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                <td class="py-2 text-center col-3">
                                    <!--  الكلية -->
                                    <select id="college" name="college_id"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                        <option value="0">إختار الكلية</option>
                                        @if ( isset($colleges) )
                                        @foreach ($colleges as $college)
                                        <option value="{{ $college->id }}" class="college-options">
                                            {{ $college->name }}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                </td>
                                <td class="py-2 text-center col-3">
                                    <!-- الدفعة -->
                                    <select id="batch" name="batch_id"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                        <option value="0">إختار الدفعة</option>
                                        @if ( isset($batches) )
                                        @foreach ($batches as $batch)
                                        <option value="{{ $batch->id }}">
                                            {{ $batch->value }}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                </td>
                                <td class="py-2 text-center col-3">
                                    <input type="date" name="registration_start" id="registrationStart" required
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                                </td>
                                <td class="py-2 text-center col-3">
                                    <input type="date" name="registration_end" id="registrationEnd" required
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center p-2 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600 justify-center">
                    <button data-modal-toggle="createRegistrationModal" type="submit"
                            class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none ml-3">
                        حفظ
                    </button>
                    <button data-modal-toggle="createRegistrationModal" type="button"
                            class="text-white bg-red-600 hover:bg-red-700 focus:ring-4 focus:outline-none focus:ring-red-300 rounded-lg text-sm font-medium px-5 py-2.5 mr-2 mb-2 ml-3">
                        الغاء
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<div id="editRegistrationModal" tabindex="-1" aria-hidden="true"
    class="fixed top-20 left-0 right-0 z-50 w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full hidden">
    <div class="relative w-full h-full max-w-6xl md:h-auto">
        <!-- Modal content -->
        <form action="{{ route('settings.registration.constraint.update', -1) }}" method="post" novalidate>
            @csrf
            @method('PUT')
            <input type="hidden" name="id" value="" id="editRegistrationId">
            <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-start justify-center border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        <div class="card-header flex justify-between p-3 text-blue-700">
                            تعديل
                        </div>
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="px-3 py-2 space-y-6 flex justify-center">
                    <div class="overflow-x-auto relative shadow-md sm:rounded-lg col-12">
                        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                            <thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                                <tr>
                                    <th scope="col" class="py-2 px-2">
                                        الكلية
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        الدفعة
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        بداية التسجيل
                                    </th>
                                    <th scope="col" class="py-2 px-2">
                                        نهاية التسجيل
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                <td class="py-2 text-center col-3">
                                    <!--  الكلية -->
                                    <select id="college" name="college_id"
                                        class="editCollege bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                        <option value="0" disabled="disabled">{{ __('student.choose-college') }}</option>
                                        @if ( isset($colleges) )
                                        @foreach ($colleges as $college)
                                        <option value="{{ $college->id }}" class="college-options" disabled="disabled">
                                            {{ $college->name }}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                </td>
                                <td class="py-2 text-center col-3">
                                    <!-- الدفعة -->
                                    <select id="batch" name="batch_id"
                                        class="editBatch bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                        <option value="0" disabled="disabled">{{ __('student.choose-batch') }}</option>
                                        @if ( isset($batches) )
                                        @foreach ($batches as $batch)
                                        <option value="{{ $batch->id }}" disabled="disabled">
                                            {{ $batch->value }}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                </td>
                                <td class="py-2 text-center col-3">
                                    <input type="date" name="registration_start" id="registrationStart" required
                                        class="editRegistrationStart bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                                </td>
                                <td class="py-2 text-center col-3">
                                    <input type="date" name="registration_end" id="registrationEnd" required
                                        class="editRegistrationEnd bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                </td>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center p-2 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600 justify-center">
                    <button data-modal-toggle="editRegistrationModal" type="button"
                            class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none ml-3">
                        تعديل
                    </button>
                    <button data-modal-toggle="editRegistrationModal" type="button"
                            class="text-white bg-red-600 hover:bg-red-700 focus:ring-4 focus:outline-none focus:ring-red-300 rounded-lg text-sm font-medium px-5 py-2.5 mr-2 mb-2 ml-3">
                        الغاء
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable2").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });

        $('.deleteRegistration').click(function (e) {
            e.preventDefault();

            Swal.fire({
                icon: 'warning',
                title: 'عملية حذف!',
                text: 'هل تريد حذف هذه المجموعة حقا؟',
                showDenyButton: true,
                confirmButtonText: 'نعم',
                denyButtonText: `لا`,
                }).then((result) => {

                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    var id = $(this).data("id");
                    var token = $("meta[name='csrf-token']").attr("content");

                    $.ajax({
                        url: "{{ url('settings/registration-constraint') }}" + "/" + id,
                        type: 'DELETE',
                        data: {
                            "_token": token,
                        },
                        success: function (data){
                            console.log(data);
                            Swal.fire(
                                'عملية ناجحة!',
                                'تم حذف الدفعية بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        },
                        error: function (data){
                            Swal.fire(
                                'عملية غير ناجحة!',
                                'لم يتم ايجاد المجموعة',
                                'error'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    });
                }
            });
        });

        // $('.editRegistration').click(function (e) {
        //     e.preventDefault();
        //     let id = $(this).data('id');
        //     $.ajax({
        //         type: "get",
        //         url: "registration-constraint/" + id + "/show",
        //         success: function (response) {
        //             $('#editRegistrationId').val(response.id);
        //             $(".editCollege option[value="+response.college_id+"]").attr('selected', 'selected');
        //             $(".editCollege option[value="+response.college_id+"]").removeAttr('disabled');
        //             $(".editBatch option[value="+response.batch_id+"]").attr('selected', 'selected');
        //             $(".editBatch option[value="+response.batch_id+"]").removeAttr('disabled');
        //             $('.editRegistrationStart').val(response.start);
        //             $('.editRegistrationEnd').val(response.end);
        //         }
        //     });
        // });

        $('.editRegistration').on('click', function (e) {
            e.preventDefault();

            const id = $(this).data('id');
            const url = `registration-constraint/${id}/show`;

            $.get(url, function (response) {
                $('#editRegistrationId').val(response.id);

                const $collegeSelect = $('.editCollege');
                const $batchSelect = $('.editBatch');

                // Enable and select the correct college
                $collegeSelect.find('option')
                    .prop('selected', false)
                    .prop('disabled', true);

                $collegeSelect.find(`option[value="${response.college_id}"]`)
                    .prop('selected', true)
                    .prop('disabled', false);

                // Enable and select the correct batch
                $batchSelect.find('option')
                    .prop('selected', false)
                    .prop('disabled', true);

                $batchSelect.find(`option[value="${response.batch_id}"]`)
                    .prop('selected', true)
                    .prop('disabled', false);

                // Set registration dates
                $('.editRegistrationStart').val(response.start);
                $('.editRegistrationEnd').val(response.end);
            });
        });


        $('#studentsTable tbody').on('click', '.showRegistration', function () {
            let id = $(this).data('id');
            $.ajax({
                type: "get",
                url: "registration-management/" + id + "/show",
                success: function (response) {
                    $('#showStudentsList').html('');
                    response.forEach(element => {
                        $('#showStudentsList').append(`
                            <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    ${element.student_id}
                                </th>
                                <td class="py-2 text-center">
                                    ${element.student_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.college_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.section_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.program_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.batch_name}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.registration_fees}
                                </td>
                                <td class="py-2 text-center">
                                    ${element.program_fees}
                                </td>
                            </tr>
                        `);
                    });
                }
            });
        });

        $('#college').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('college.sections') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#section').html('<option value="0">{{ __("student.choose-section") }}</option>');
                    $(response).each(function (index, element) {
                        $('#section').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                }
            });
        });

        // $('.showRegistration').change(function (e) {
        //     e.preventDefault();

        //     $('#showRegistrationModal').hasClass('flex') ? $('#showRegistrationModal').removeClass('flex') : '';
        // });


    });

</script>
@endsection
