@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    .penalty-lable span{
        color: #a72035;
        font-weight: 900;
    }
    .card{
        min-height: 100px
    }
</style>
@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('settings.setup-penalty') }}
            </h3>
        </div>

        @if (count($penalties) > 0)
        <div class="card">
            <div class="card-header"> الغرامات </div>
            <div class="card-body">
                @foreach ($penalties as $penalty)
                    <form method="post" enctype="multipart/form-data" id="editPenaltyForm" name="form{{$penalty->id}}">
                        @csrf
                        <input type="hidden" name="penalty_id" id="penaltyId" value="{{ $penalty->id }}">
                        <div class="p-2 mr-8">
                            <div class="row">
                                <div class="col-3 pt-2 penalty-lable">
                                    <span>{{ __('settings.penalty-start') }}</span>
                                    <input type="datetime-local" name="penalty_start" id="penaltyStart-{{$penalty->id}}" value="{{ $penalty->start }}" required>
                                </div>

                                <div class="col-3 pt-2 penalty-lable">
                                    <span>{{ __('settings.penalty-end') }}</span>
                                    <input type="datetime-local" name="penalty_end" id="penaltyEnd-{{$penalty->id}}" value="{{ $penalty->end }}" required>
                                </div>

                                <div class="col-3 pt-2 penalty-lable">
                                    <span>{{ __('settings.penalty-amount') }}</span>
                                    <input type="text" name="penalty_amount" id="penaltyAmount-{{$penalty->id}}" value="{{ $penalty->amount }}" required>
                                </div>
                                <div class="col-3 pt-2">
                                    <button data-id="{{ $penalty->id }}" style="margin-top: 15px;"
                                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-xl px-4 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 editPenalty">
                                        {{-- {{ __('settings.penalty-edit') }} --}}
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button data-id="{{ $penalty->id }}" style="margin-top: 15px;"
                                        class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-xl px-4 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800 deletePenalty">
                                        <i class="fas fa-trash-alt"></i>
                                        {{-- {{ __('settings.penalty-edit') }} --}}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                @endforeach  
            </div>
        </div>
        @else
        <div class="card">
            <div class="card-header"> الغرامات </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-2 pt-2 lable">
                        <span>
                            لم يتم اضافة غرامة بعد
                        </span>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <div class="card m-8">
            <div class="card-header"> اضافة غرامة </div>
            <div class="card-body">
                <form method="post" enctype="multipart/form-data" id="addPenaltyForm">
                    @csrf
                    <div class="p-6 space-y-6">
                        <div class="row">
                            <div class="col-2 pt-2 lable">{{ __('settings.penalty-start') }}</div>
                            <div class="col-3">
                                <input type="datetime-local" name="penalty_start" id="penaltyStart" required>
                            </div>
        
                            <div class="col-2 pt-2 lable">{{ __('settings.penalty-end') }}</div>
                            <div class="col-3">
                                <input type="datetime-local" name="penalty_end" id="penaltyEnd" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-2 pt-2 lable">{{ __('settings.penalty-amount') }}</div>
                            <div class="col-3">
                                <input type="text" name="penalty_amount" id="penaltyAmount" required>
                            </div>
                        </div>
                    </div>
        
                    <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600">
                        <button type="submit"
                            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            {{ __('settings.penalty-add') }}
                        </button>
                        <a href="#" type="button"
                            class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                            {{ __('student.cancel') }}
                        </a>
                    </div>
                </form>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

{{-- <script src="{{ asset('plugins/bootstrap-editable/js/index.js') }}"></script> --}}

<!-- Init js-->
{{-- <script src="{{ asset('js/form-xeditable.init.js') }}"></script> --}}

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>


<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        $("#addPenaltyForm").validate({
            rules: {
                penalty_start: {
                    required: true,
                },
                penalty_end: {
                    required: true,
                },
                penalty_amount: {
                    required: true,
                },
            },
            messages: {
                penalty_start: {
                    required: ".هذا الحقل مطلوب",
                },
                penalty_end: {
                    required: ".هذا الحقل مطلوب",
                },
                penalty_amount: {
                    required: ".هذا الحقل مطلوب",
                },
            },
            submitHandler: function(form) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $('#submit').html('Please Wait...');
                $("#submit"). attr("disabled", true);
                $.ajax({
                    url: "{{ route('post.settings.setup.penalty') }}",
                    type: "POST",
                    data: $('#addPenaltyForm').serialize(),
                    success: function( response ) {
                        console.log( response );
                        if(response == 'success'){
                            Swal.fire(
                                'نجاح!',
                                'تم اضافة الغرامة بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    }
                });
            }
        });

        $(".editPenalty").click(function (e) { 
            e.preventDefault();

            $(this).validate({
                rules: {
                    penalty_start: {
                        required: true,
                    },
                    penalty_end: {
                        required: true,
                    },
                    penalty_amount: {
                        required: true,
                    },
                },
                messages: {
                    penalty_start: {
                        required: ".هذا الحقل مطلوب",
                    },
                    penalty_end: {
                        required: ".هذا الحقل مطلوب",
                    },
                    penalty_amount: {
                        required: ".هذا الحقل مطلوب",
                    },
                },
            });

            penaltyId = $(this).attr("data-id");

            $.ajax({
                    url: 'edit-penalty/' + penaltyId,
                    type: "POST",
                    data: {
                        penaltyId: $(this).attr("data-id"),
                        penalty_start: $('#penaltyStart-'+penaltyId).val(),
                        penalty_end: $('#penaltyEnd-'+penaltyId).val(),
                        penalty_amount: $('#penaltyAmount-'+penaltyId).val(),
                        _token: $('meta[name="csrf-token"]').attr('content'),
                        _method: 'put',
                    },
                    // data: $(this).parent("form").serialize(),
                    success: function( response ) {
                        console.log(response);
                        if(response == 'success'){
                            Swal.fire(
                                'نجاح!',
                                'تم تعديل الغرامة بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    }
                });
        });

        $(".deletePenalty").click(function (e) { 
            e.preventDefault();

            $penaltyId = $(this).attr("data-id");
            $.ajax({
                    url: 'delete-penalty/' + penaltyId,
                    type: "DELETE",
                    data: {
                        penaltyId: $(this).attr("data-id"),
                        _token: $('meta[name="csrf-token"]').attr('content'),
                    },
                    success: function( response ) {
                        if(response == 'success'){
                            Swal.fire(
                                'نجاح!',
                                'تم حذف الغرامة بنجاح!',
                                'success'
                            ).then( () => {
                                location.reload();
                            });
                        }
                    }
                });
        });
    });

    // custmize invalid input
    document.addEventListener("DOMContentLoaded", function() {
        var elements = document.getElementsByTagName("INPUT");
        for (var i = 0; i < elements.length; i++) {
            elements[i].oninvalid = function(e) {
                e.target.setCustomValidity("");
                if (!e.target.validity.valid) {
                    e.target.setCustomValidity("هذا الحقل مطلوب");
                }
            };
            elements[i].oninput = function(e) {
                e.target.setCustomValidity("");
            };
        }
    });
</script>
@endsection