@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>

<style>
    .registration-lable {
        color: #a72035;
        font-weight: 900;
    }
    tfoot{
        background-color:#36304a !important;
    }
    tfoot p{
        color: white !important;
        font-size: 12px !important;
        font-weight: 100 !important;
    }
</style>

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    .html5buttons {
        direction: ltr;
        position: absolute;
        top: -45px;
        left: 10px;
    }

    .html5buttons .btn-secondary {
        color: #ffffff;
        background-color: #295694;
    }

    .html5buttons .buttons-print,
    .html5buttons .buttons-excel {
        background-color: rgb(167, 32, 53);
        color: white;
    }

    .dataTables_filter {
        margin: 20px 0px 20px;
    }

    #min,
    #max {
        max-width: 150px;
        min-width: unset;
        font-size: 12px;
        font-weight: 400;
        text-align: center;
        color: #495057;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #ced4da !important;
        border-radius: 0.25rem;
        min-height: calc(1.5em + 0.5rem + 2px);
        padding: 0.25rem 0.5rem;
    }

    .dt-datetime-year,
    .dt-datetime-month {
        min-width: unset !important;
        width: 50px !important;
        max-height: 22px !important;
    }

    input[type='date'],
    input[type='date']:focus-visible,
    input[type='date']:focus{
        min-width: unset;
    }
</style>

@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('settings.setup-registration') }}
            </h3>
            {{-- <button type="button"
                class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800"
                style="position: absolute; left: 30px;">
                <i class="fa fa-user-plus" aria-hidden="true"></i>
                {{ __('student.add-new-student') }}
            </button> --}}
        </div>
        <div class="p-6 space-y-6">
            <div class="card-body">
                <!-- filter -->
                @include('layouts.filter')

                <div id="studentsListTable" class="mt-4">
                    <table class="table" id="studentsTable" style="width: 100%;">
                        <thead>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.id') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.name') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.college') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.section') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.program') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.batch') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.registration-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.tuition-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.insurance-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white" style="min-width: 100px;">
                                    {{ __('student.show') }}
                                </th>
                            </tr>
                        </thead>
                        <tbody id="studentsList">
                            @if (isset($students) && $students != '[]')
                                @foreach ($students as $student)
                                    <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                        <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                            {{ $student->student_id}}
                                        </th>
                                        <td class="py-2 text-center">
                                            {{ $student->student_name }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->college ? $student->college->name : __('student.not-set') }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->section->name ?? __('student.not-set') }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->program->name ?? __('student.not-set') }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->batch ? $student->batch->value : __('student.not-set') }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->registration_fees }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->program_fees }}
                                        </td>
                                        <td class="py-2 text-center">
                                            {{ $student->insurance_fees }}
                                        </td>
                                        <td class="py-2 text-center showStudent">
                                            <a class="px-4 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full"
                                                href="{{ route('student.edit', $student->id) }}" style="background-color: #36304a">
                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                                {{ __('student.show') }}
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.id') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.name') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.college') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.section') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.program') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.batch') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.registration-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.tuition-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.insurance-fees') }}
                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    {{ __('student.show') }}
                                </th>
                            </tr>
                        </tfoot>
                    </table>

                    <div>
                        {{ $students->withQueryString()->links() }}
                    </div>
                </div>
            </div>
        </div>

        <div class="p-6 space-y-6">
            <div class="card-body">
                <form action="{{ route('registration.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
{{--                    <input type="hidden" name="students" value="{{ isset($students) ? json_encode($students) : null }}">--}}
                    <input type="hidden" name="college_id" value="{{ request()->college_id }}">
                    <input type="hidden" name="batch_id" value="{{ request()->batch_id }}">
                    <input type="hidden" name="section_id" value="{{ request()->section_id }}">
                    <input type="hidden" name="program_id" value="{{ request()->program_id }}">
                    <input type="hidden" name="semester" value="{{ $semester_id ?? null }}">


                    <div class="justify-center py-6 row space-x-4">
                        <div class="col-2 pt-2 ml-4">
                            {{ __('settings.registration-start') }}
                            <input type="date" name="registration_start" id="registrationStart" required
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                        </div>

                        <div class="col-2 pt-2">
                            {{ __('settings.registration-end') }}
                            <input type="date" name="registration_end" id="registrationEnd" required
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        </div>
                        <div class="col-2 pt-2">
                            &nbsp;
                            <select id="semester" name="semester_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                                <option value="0">{{ __('student.choose-semester') }}</option>
                                @if ( isset($semesters) )
                                @foreach ($semesters as $semester)
                                <option value="{{ $semester->id }}">
                                    {{ $semester->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>
                    </div>

                    <div class="justify-center py-6 row space-x-4">
                        <div class="col-2 pt-2">
                            <div class="flex mb-1">
                                <span class="mx-auto">
                                    مقدار الدمغة
                                </span>
                            </div>
                            <input type="text" name="stamp" id="registrationEnd" required
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 text-center mx-auto"
                                value="50"
                                style="width: 100px;">
                        </div>

                    </div>

                    <div class="row flex justify-center space-x-2 mt-4">
                        <div class="col-4 flex justify-center px-1 pb-16">
                            <button type="submit" style="background-color: #36304a;" class="mr-3 px-5 py-2 rounded-2 text-white btn" id="studentRegistration" name="registration">
                                {{__('settings.start-registration') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')

{!! Toastr::message() !!}

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable2").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });

        $('#college, #section, #program, #batch, #paymentCurrency').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });
    });
</script>

@endsection
