@extends('layouts.app')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('settings.manage-sort-students') }}
                </div>

                <div class="card m-8">
                    <div class="card-header">تعديل ترتيب الطلاب</div>
                    <div class="card-body">
                        <form method="post" action="{{ route('settings.update.sort.students') }}" enctype="multipart/form-data" id="addPenaltyForm">
                            @csrf
                            @method('put')
                            
                            <div class="p-6 space-y-6">
                                <div class="row">
                                    <div class="col-2 pt-2 lable">{{ __('settings.penalty-start') }}</div>
                                    <div class="col-3">
                                        <input type="datetime-local" name="penalty_start" id="penaltyStart" required>
                                    </div>

                                    <div class="col-2 pt-2 lable">{{ __('settings.penalty-end') }}</div>
                                    <div class="col-3">
                                        <input type="datetime-local" name="penalty_end" id="penaltyEnd" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-2 pt-2 lable">{{ __('settings.penalty-amount') }}</div>
                                    <div class="col-3">
                                        <input type="text" name="penalty_amount" id="penaltyAmount" required>
                                    </div>
                                </div>
                            </div>

                            <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600">
                                <button type="submit"
                                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                    تعديل
                                </button>
                                <a href="#" type="button"
                                   class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                                    {{ __('student.cancel') }}
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
    {!! Toastr::message() !!}
    <script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

    <script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

@endsection
