@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    @font-face {
        font-family: 'Droid-Arabic-Kufi';
        src: url('fonts/Kufi/Droid-Arabic-Kufi.ttf.woff') format('woff'),
            url('fonts/Kufi/Droid-Arabic-Kufi.ttf.svg#Droid-Arabic-Kufi') format('svg'),
            url('fonts/Kufi/Droid-Arabic-Kufi.ttf.eot'),
            url('fonts/Kufi/Droid-Arabic-Kufi.ttf.eot?#iefix') format('embedded-opentype');
        font-weight: bolder;
        font-style: normal;
    }

    tfoot {
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled) {
        padding-right: 30px !important;
    }

    #cardFrontPrinter {
        font-family: 'Droid-Arabic-Kufi';
    }

    /* style sheet for "A4" printing */
    /* @media print and (width: 21cm) and (height: 29.7cm) {
        @page {
            margin: 0.5cm;
        }
    } */

    @media print {

        @page {
            margin: 0cm;
        }

        #cardFrontPrinter,
        #cardBackPrinter {
            page-break-after: always;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    إستخراج بطاقة جديدة
                </div>
                <div class="card-body">
                    <!-- filter -->
                    @include('layouts.filter')

                    <div id="studentsListTable" class="mt-4">
                        <table class="table" id="studentsTable2" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.college') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.section') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student-card.faces') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student-card.status') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.actions') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="studentsList">
                                @if ( isset($students) )
                                <?php $no = 1;?>
                                @foreach ($students as $student)
                                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                    <th scope="row" class="py-2 text-center">
                                        <?= $no++; ?>
                                    </th>
                                    <td class="py-2 text-center">
                                        {{ $student->student_id }}
                                    </td>
                                    <td class="py-2 text-right">
                                        {{ $student->student_name }}
                                    </td>

                                    <td class="py-2 text-center">
                                        {{ isset($student->college) ? $student->college->name :
                                        __('home.not-set') }}
                                    </td>

                                    <td class="py-2 text-center">
                                        {{ isset($student->section) ? $student->section->name :
                                        __('home.not-set') }}
                                    </td>

                                    {{-- number of faces print --}}
                                    <td class="py-2 text-center">
                                        @isset($student)
                                        <span
                                            class="bg-yellow-100 text-yellow-800 text-xs font-medium mr-2 px-2.5 pl-8 py-2 rounded dark:bg-green-900 dark:text-green-300">
                                            <div
                                                class="absolute inline-flex items-center justify-center w-6 text-xs font-bold border-2 rounded-full left-1 bg-pink-100 text-pink-800">
                                                {{ $student->card->front_prints ?? 0 }}
                                            </div>
                                            {{ __('student-card.front-printed') }}
                                        </span>

                                        <span
                                            class="bg-yellow-100 text-yellow-800 text-xs font-medium mr-2 px-2.5 pl-8 py-2 rounded dark:bg-green-900 dark:text-green-300">
                                            <div
                                                class="absolute inline-flex items-center justify-center w-6 text-xs font-bold border-2 rounded-full left-1 bg-pink-100 text-pink-800">
                                                {{ $student->card->back_prints ?? 0 }}
                                            </div>
                                            {{ __('student-card.back-printed') }}
                                        </span>
                                        @endisset
                                    </td>

                                    {{-- number of prints --}}
                                    <td class="py-2 text-center">
                                        @isset($student)
                                        @if ($student->card && $student->card->status == 1)
                                        <span
                                            class="bg-green-100 text-green-800 text-xs font-medium mr-2 px-2.5 pl-8 py-2 rounded dark:bg-green-900 dark:text-green-300">
                                            <div
                                                class="absolute inline-flex items-center justify-center w-6 text-xs font-bold border-2 rounded-full left-1 bg-pink-100 text-pink-800">
                                                {{ $student->card->number_of_print ?? 0 }}
                                            </div>
                                            {{ __('student-card.printed') }}
                                        </span>
                                        @else
                                        <span
                                            class="bg-red-100 text-red-800 text-xs font-medium mr-2 px-2.5 pl-8 py-2 rounded dark:bg-red-900 dark:text-red-300">
                                            <div
                                                class="absolute inline-flex items-center justify-center w-6 text-xs font-bold border-2 rounded-full left-1 bg-pink-100 text-pink-800">
                                                0
                                            </div>
                                            {{ __('student-card.not-printed') }}
                                        </span>
                                        @endif
                                        @endisset

                                    </td>

                                    <td class="py-2 text-center">
                                        <button type="button"
                                            class="showCard px-4 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full mx-1"
                                            style="background-color: #36304a"
                                            data-student_id="{{ $student->student_id}}">
                                            <i class="fa fa-eye"></i>
                                            {{ __('student.show') }}
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        رقم
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.id') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.name') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.college') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.section') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student-card.status') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student-card.status') }}
                                    </th>
                                    <th scope="col" class="py-2 px-2 text-white">
                                        {{ __('student.actions') }}
                                    </th>
                                </tr>
                            </tfoot>
                        </table>

                        <div>
                            {{ $students->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Show Card Modal -->
<div class="modal fade" id="showCardModal" tabindex="-1" aria-labelledby="showCardModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content">
            <div class="modal-header justify-center">
                <h3 class="modal-title text-xl font-semibold text-gray-900 dark:text-white flex justify-center"
                    id="showCardModalLabel">
                    عرض بطاقة الطالب
                </h3>
            </div>
            <div class="modal-body">
                <div class="p-6 space-y-6 text-center">
                    <div dir="ltr">
                        <ul class="hidden text-sm font-medium text-center text-gray-500 divide-x divide-gray-200 rounded-lg shadow sm:flex dark:divide-gray-700 dark:text-gray-400"
                            id="myTab" data-tabs-toggle="#myTabContent" role="tablist">
                            <li class="w-full">
                                <button
                                    class="inline-block w-full p-4 text-gray-900 bg-white rounded-l-lg hover:text-gray-700 hover:bg-gray-50 focus:ring-1 focus:ring-blue-300 focus:outline-none"
                                    id="card-back-tab" data-tabs-target="#card-back" type="button" role="tab"
                                    aria-controls="contacts" aria-selected="false">
                                    الواجهة الخلفية
                                </button>
                            </li>
                            <li class="w-full">
                                <button
                                    class="inline-block w-full p-4 bg-gray-100 rounded-r-lg hover:text-gray-700 hover:bg-gray-50 focus:ring-1 focus:ring-blue-300 focus:outline-none active"
                                    id="card-front-tab" data-tabs-target="#card-front" type="button" role="tab"
                                    aria-controls="contacts" aria-selected="true" aria-current="page">
                                    الواجهة الامامية
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div id="myTabContent">
                        <div class="row hidden p-4 rounded-lg bg-gray-50 dark:bg-gray-800" id="card-back"
                            role="tabpanel" aria-labelledby="card-back-tab">
                            <div class="col-6 text-center">
                                <div class="frontImage position-absolute">
                                    <img src="{{ asset('img/card/back-full.png') }}" alt="" style="max-width: 180px;">
                                </div>
                            </div>
                            <div class="col-6 text-right">
                                <form action="javascript:void(0)" method="POST" id="cardBackForm"
                                    class="flex flex-col h-full justify-between" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="student_id" class="showStudentId">
                                    <div>
                                        <h2 class="text-center font-black mb-5">
                                            تفاصيل الواجهة الأمامية
                                        </h2>
                                        <div class="row py-2">
                                            <div class="md:flex md:items-center">
                                                <div class="col-4">
                                                    <label
                                                        class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                        for="inline-full-name">
                                                        تنبيهات
                                                    </label>
                                                </div>
                                                <div class="col-8">
                                                    <ul class="list-disc col-12 font-black">
                                                        <li class="list-disc">
                                                            يسمح لحاملها بدخول كافة المؤسسات الحكومية
                                                        </li>
                                                        <li class="list-disc">
                                                            النظافة و المحافظة علي ممتلكات الجامعة سلوك حضاري
                                                        </li>
                                                        <li class="list-disc">
                                                            يجب ابراز البطاقة عند الطلب
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row py-2">
                                            <div class="md:flex md:items-center">
                                                <div class="col-4">
                                                    <label
                                                        class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                        for="inline-full-name">
                                                        الصلاحية حتى
                                                    </label>
                                                </div>
                                                <div class="col-8">
                                                    <input
                                                        class="showExpireDate bg-gray-200 appearance-none border-2 border-gray-200 rounded w-full py-1 px-1 text-gray-700 leading-tight focus:outline-none focus:bg-white focus:border-purple-500"
                                                        type="date" name="expire_date" id="expire_date"
                                                        placeholder="تاريخ الصلاحية" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="button"
                                            class="printCardBack text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-3 py-2 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 mt-4">
                                            <i class="fa fa-print"></i>
                                            {{ __('student-card.print-back-only') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="row hidden p-4 rounded-lg bg-gray-50 dark:bg-gray-800" id="card-front"
                            role="tabpanel" aria-labelledby="card-front-tab">
                            <div class="col-6 text-center position-relative">
                                <div class="position-absolute mx-auto"
                                    style="z-index: 1; max-width: 135px; right: 35px;">
                                    <img src="{{ asset('img/card/avatar.png') }}" alt="" class="studentImage">
                                </div>
                                <div class="frontImage position-absolute" style="z-index: 2;">
                                    <img src="{{ asset('img/card/front-clear7.png') }}" alt="" style="max-width: 180px">
                                </div>
                            </div>
                            <div class="col-6 text-right">
                                <form action="javascript:void(0)" method="POST" id="cardFrontForm"
                                    class="flex flex-col h-full justify-between" enctype="multipart/form-data">
                                    @csrf
                                    <div>
                                        <h2 class="text-center font-black mb-5">
                                            تفاصيل الواجهة الأمامية
                                        </h2>
                                        <div class="row py-2">
                                            <div class="md:flex md:items-center">
                                                <div class="col-4">
                                                    <label
                                                        class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                        for="inline-full-name">
                                                        إسم الطالب
                                                    </label>
                                                </div>
                                                <div class="col-8">
                                                    <input
                                                        class="showStudentName bg-gray-200 appearance-none border-2 border-gray-200 rounded w-full py-1 px-1 text-gray-700 leading-tight focus:outline-none focus:bg-white focus:border-purple-500"
                                                        type="text" name="student_name" placeholder="إسم الطالب">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row py-2">
                                            <div class="md:flex md:items-center">
                                                <div class="col-4">
                                                    <label
                                                        class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                        for="inline-full-name">
                                                        الكلية
                                                    </label>
                                                </div>
                                                <div class="col-8">
                                                    <input
                                                        class="showCollegeName bg-gray-200 appearance-none border-2 border-gray-200 rounded w-full py-1 px-1 text-gray-700 leading-tight focus:outline-none focus:bg-white focus:border-purple-500"
                                                        type="text" name="college_name" placeholder="الكلية">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row py-2">
                                            <div class="md:flex md:items-center">
                                                <div class="col-4">
                                                    <label
                                                        class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                        for="inline-full-name">
                                                        رقم التسجيل
                                                    </label>
                                                </div>
                                                <div class="col-8">
                                                    <input
                                                        class="showStudentId bg-gray-200 appearance-none border-2 border-gray-200 rounded w-full py-1 px-1 text-gray-700 leading-tight focus:outline-none focus:bg-white focus:border-purple-500"
                                                        type="text" name="student_id" placeholder="رقم التسجيل">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row py-2">
                                        <div class="md:flex md:items-center">
                                            <div class="col-4">
                                                <label class="block text-gray-500 font-bold md:text-right mb-1 md:mb-0"
                                                    for="inline-full-name">
                                                    تاريخ الإصدار
                                                </label>
                                            </div>
                                            <div class="col-8">
                                                <input
                                                    class="showSectionName bg-gray-200 appearance-none border-2 border-gray-200 rounded w-full py-1 px-1 text-gray-700 leading-tight focus:outline-none focus:bg-white focus:border-purple-500"
                                                    type="text" name="section_name" placeholder="سنة الطباعة">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="text-center">
                                        <button type="button"
                                            class="printCardFront text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-3 py-2 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 mt-4">
                                            <i class="fa fa-print"></i>
                                            {{ __('student-card.print-front-only') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="modal-footer" dir="ltr">
                <button data-bs-dismiss="modal" type="button" id="printCardBack"
                    class="text-white focus:ring-4 focus:outline-none focus:ring-red-300 rounded-lg border border-red-200 text-sm font-medium px-4 py-1.5 hover:text-gray-900 focus:z-10 mx-2 bg-danger"
                    style="background-color: rgb(54, 48, 74);">
                    {{ __('student-card.cancel') }}
                </button>

                <button type="button"
                    class="printCard text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-2 py-1.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    <i class="fa fa-print"></i>
                    {{ __('student-card.print') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- print card front -->
<div hidden>
    <div id="cardFrontPrinter" class="position-relative flex mx-auto" style="width: 204px; height: 325px; direction: rtl;">
        <div class="block mx-auto" style="z-index: 1; width: 125px; height: 125px; margin-top: 15px;">
            <img src="{{ asset('img/card/avatar.png') }}" alt="" class="studentImage">
        </div>
        <div class="frontImage position-absolute" style="width: 204px; height: 325px; z-index: 2; direction: rtl;">
            <img src="{{ asset('img/card/front-clear7.png') }}" alt="" style="width: 100%; height: 100%;">
        </div>

        <div class="position-absolute flex justify-center" style="width: 100%; height: 100%; z-index: 3;">
            <div class="my-auto">
                <div class="row text-black w-100 mx-auto" style="font-size: 11px;font-weight: bold; padding-top: 40px;">
                    <div class="col-12 text-center">
                        <span class="printStudentName"></span>
                    </div>
                </div>

                 <div class="row text-black w-100 mx-auto my-1" style="font-size: 11px;font-weight: bold;">
                    <div class="col-12 text-center">
                        <span class="printCollegeName"></span>
                    </div>
                </div>

                <div class="row text-black w-100 mx-auto my-1" style="font-size: 11px;font-weight: bold;">
                    <div class="col-12 text-center">
                        رقم التسجيل : <span class="printStudentId"></span>
                    </div>
                </div>

                <div class="row text-black w-100 mx-auto my-1" style="font-size: 10px;font-weight: bold;">
                    <div class="col-12 text-center">
                        تاريخ الإصدار : <span class="printSectionName"></span>
                    </div>
                </div>

                <div class="position-absolute"
                    style="z-index: 1;left: 5px;bottom: 25px; transform: rotate(0deg);">
                    <span class="flex mx-auto" style="font-size: 9px;font-weight: bold;">الشؤون العلمية</span>
                    <div class="flex mx-auto" style="width: 50px; height: 50px;">
                        <img src="{{ asset('img/signature.png') }}" alt="" >
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('js/divjs.js') }}"></script>

<script>
    $(document).ready(function () {
        $('#studentsListTable').on('click', '.showCard', function () {
            // alert($(this).data('student_id'));
            document.getElementById('expire_date').valueAsDate = new Date();
            const MFG = new Date();

            $('.showExpireDate').valueAsDate = new Date();
            let studentId = $(this).data('student_id');

            $.ajax({
                type: "GET",
                url: "{{ route('students-cards.show', -1) }}",
                data: {
                    'student_id': studentId,
                },
                success: function (response) {
                    console.log(response);
                    $('.showStudentName').val(response.student_name);
                    $('.showCollegeName').val(response.college_name);
                    // $('.showCollegeName').val(1);
                    $('.showSectionName').val(MFG.getFullYear());
                    $('.showStudentId').val(response.student_id);

                    $('.printStudentName').html(response.student_name);
                    $('.printCollegeName').html(response.college_name);
                    $('.printStudentId').html(response.student_id);
                    $('.printSectionName').html(MFG.getFullYear());
                    // $('.studentImage').attr('src', response.student_image);

                    if(response.student_image != 'avatar.png'){
                        $('.studentImage').attr('src', "{{ asset('files/students/') }}/" + response.student_image);
                    } else {
                        $('.studentImage').attr('src', "{{ asset('img/card/') }}/" + response.student_image);
                    }

                    $('#showCardModal').modal('show');
                },
                error: function (response) {
                    console.log(response.responseText);
                },
            });
        });


        $(".printCard").click(function (e) {
            e.preventDefault();
            let studentId = $('.showStudentId').val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                }
            });

            $.ajax({
                type: "POST",
                url: "{{ route('print.card') }}",
                data: {
                    student_id: $('.showStudentId').val(),
                    student_name: $('.showStudentName').val(),
                    college_name: $('.showCollegeName').val(),
                    section_name: $('.showSectionName').val(),
                    expire_date: $('.showExpireDate').val(),
                },
                success: function (response) {
                    console.log(response);


                    setTimeout( function(){
                        $('#cardFrontPrinter').printElement();
                        $('#cardBackPrinter').printElement();

                        Swal.fire({
                            icon: 'success',
                            title: 'عملية ناجحة!',
                            text: response,
                        }).then( () => {
                            location.reload();
                        });
                    }, 2000);
                },
                error: function (response) {
                    console.log(response);
                },
            });
        });

        $(".printCardFront").click(function (e) {
            e.preventDefault();

            let form = document.getElementById("cardFrontForm");
            let formData = new FormData(form);

            $.ajax({
                type: "POST",
                url: "{{ route('print.card.front') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (response) {
                    console.log(response);

                    setTimeout( function(){
                        $('#cardFrontPrinter').printElement();

                        Swal.fire({
                            icon: 'success',
                            title: 'عملية ناجحة!',
                            text: response,
                        }).then( () => {
                            location.reload();
                        });
                    }, 2000);

                },
                error: function (response) {
                    console.log(response);
                },
            });
        });

        $(".printCardBack").click(function (e) {
            e.preventDefault();

            let form = document.getElementById("cardBackForm");
            let formData = new FormData(form);

            $.ajax({
                type: "POST",
                url: "{{ route('print.card.back') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (response) {
                    console.log(response);

                    setTimeout( function(){
                        $('#cardBackPrinter').printElement();

                        Swal.fire({
                            icon: 'success',
                            title: 'عملية ناجحة!',
                            text: response,
                        }).then( () => {
                            location.reload();
                        });
                    }, 2000);


                },
                error: function (response) {
                    console.log(response);
                },
            });
        });

    });
</script>
@endsection
