@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    #studentFile{
        opacity: 0;
        position: absolute;
        z-index: -1;
        max-width: 200px;
    }

    textarea {
        resize: none;
    }
</style>
@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('student.add-new-student') }}
            </h3>
        </div>
        <div class="p-6 space-y-6">
            <form method="post" action="{{ route('student.store') }}" enctype="multipart/form-data" id="addStudentForm">
                @csrf
                <div class="p-6 space-y-6">
                    <div id="accordion-collapse" data-accordion="collapse">
                        <h2 id="accordion-collapse-heading-1">
                            <button type="button" class="flex items-center w-full p-2 text-xl text-left border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 hover:bg-gray-100 dark:hover:bg-gray-800 bg-gray-100 dark:bg-gray-800 text-gray-900 dark:text-white" data-accordion-target="#accordion-collapse-body-1" aria-expanded="true" aria-controls="accordion-collapse-body-1">
                                <svg data-accordion-icon="" class="w-6 h-6 rotate-180 shrink-0"
                                    fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                <span class="px-4">
                                    {{ __('student.important-data') }}
                                </span>
                            </button>
                        </h2>
                        <div id="accordion-collapse-body-1" class="" aria-labelledby="accordion-collapse-heading-1">
                            <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">

                                <div class="row py-2">
                                    <div class="col-12 flex justify-center text-center">
                                        <img id="fileImage" src="{{ asset('img/students/default-student-image.png') }}" alt="" style="width: 200px; height: 200px;">
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.serial_number') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="student_serial_number" id="studentSerialNumber"
                                            placeholder="{{ __('student.id') }}" value="000000" readonly
                                            placeholder="{{ __('student.serial-number') }}" readonly>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.id') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="student_id" id="studentId" placeholder="{{ __('student.id') }}"
                                            value="{{ $newStudentId }}">
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.program-fees') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="program_fees" id="programFees"
                                            placeholder="{{ __('student.program-fees') }}" required>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.name') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="student_name" id="studentName"
                                            placeholder="{{ __('student.name') }}" required>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.registration-fees') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="registration_fees" id="registrationFees"
                                            placeholder="{{ __('student.registration-fees') }}" required>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">النوع</div>
                                    <div class="col-4">
                                        <div class="flex m-2">
                                            <div class="flex items-center">
                                                <input id="gender-1" type="radio" value="1" name="gender" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                                <label for="gender-1" class="mx-2 text-sm font-medium text-gray-900 dark:text-gray-300">ذكر</label>
                                            </div>
                                            <div class="flex items-center">
                                                <input id="gender-2" type="radio" value="2" name="gender" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                                <label for="gender-2" class="mx-2 text-sm font-medium text-gray-900 dark:text-gray-300">أنثى</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.insurance-fees') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="insurance_fees" id="insuranceFees"
                                            placeholder="{{ __('student.insurance-fees') }}" required>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.college') }}</div>
                                    <div class="col-4">
                                        <select name="college_id" id="collegeId">
                                            <option value="0">{{ __('student.choose-college') }}</option>
                                            @if ($colleges)
                                            @foreach ($colleges as $college)
                                            <option value="{{ $college->id }}">
                                                {{ $college->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.section') }}</div>
                                    <div class="col-4">
                                        <select name="section_id" id="sectionId">
                                            <option value="0">{{ __('student.choose-section') }}</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.program') }}</div>
                                    <div class="col-4">
                                        <select name="program_id" id="programId">
                                            @if ($programs)
                                            @foreach ($programs as $program)
                                            <option value="{{ $program->id }}">
                                                {{ $program->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.batch') }}</div>
                                    <div class="col-4">
                                        <select name="batch_id" id="batchId">
                                            @if ($batches)
                                            @foreach ($batches as $batch)
                                            <option value="{{ $batch->id }}">
                                                {{ $batch->value }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value=""></option>
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.national-id') }}</div>
                                    <div class="col-4">
                                        <input type="text" name="national_id" id="nationalId"
                                            placeholder="{{ __('student.national-id') }}" required>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.date-of-birth') }}</div>
                                    <div class="col-4">
                                        <input type="date" name="date_of_birth" id="dateOfBirth"
                                            placeholder="{{ __('student.date-of-birth') }}">
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">الولاية</div>
                                    <div class="col-4">
                                        <select name="state_id" id="stateId">
                                            <option value="" selected disabled>
                                                إختار الولاية
                                            </option>
                                            @if ($states)
                                            @foreach ($states as $state)
                                                <option value="{{ $state->id }}">
                                                    {{ $state->name }}
                                                </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">المحلية</div>
                                    <div class="col-4">
                                        <select name="locality_id" id="localityId">
                                            <option value="" selected disabled>
                                                إختار المحلية
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.admission-type') }}</div>
                                    <div class="col-4">
                                        <select name="admission_id" id="admissionId">
                                            @if ($admissions)
                                            @foreach ($admissions as $admission)
                                            <option value="{{ $admission->id }}">
                                                {{ $admission->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">نوع السكن</div>
                                    <div class="col-4">
                                        <select name="accommodation_type" id="primaryCertificateYear">
                                            <option value="0" disabled selected>
                                                إختار نوع السكن
                                            </option>
                                            <option value="1">داخلي</option>
                                            <option value="2">خارجي</option>
                                        </select>
                                    </div>


                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.phone-number') }}</div>
                                    <div class="col-4">
                                        <input type="number" name="phone_number" id="phoneNumber"
                                            placeholder="{{ __('student.phone-number') }}">
                                    </div>

                                    <div class="col-2 pt-2">عنوان ولي الامر</div>
                                    <div class="col-4">
                                        <input type="text" name="guardian_address" id="guardianAddress"
                                            placeholder="عنوان ولي الامر">
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">إسم ولي الامر</div>
                                    <div class="col-4">
                                        <input type="text" name="guardian_name" id="guardianName"
                                            placeholder="إسم ولي الامر">
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.guardian-phone-number') }}</div>
                                    <div class="col-4">
                                        <input type="number" name="guardian_phone_number" id="guardianPhoneNumber"
                                            placeholder="{{ __('student.guardian-phone-number') }}">
                                    </div>
                                </div>

                                <div class="flex justify-center my-4 row">
                                    <div class="col-2 my-auto text-center">ملحوظة</div>
                                    <div class="col-4">
                                        <textarea name="notes" id="notes" cols="50" rows="2" placeholder="أكتب تعليق..."></textarea>
                                    </div>
                                </div>

                                <div class="row my-4">
                                    <div class="col-12 flex justify-center text-center">
                                        <div class="col-2 pt-2">{{ __('student.image') }}</div>
                                        <div class="col-4">
                                            <label for="studentFile" class="custom-file-label px-4 py-2 rounded">
                                                {{ __('student.upload-image') }}
                                            </label>
                                            <input class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" id="studentFile" type="file" name="student_image">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h2 id="accordion-collapse-heading-2">
                            <button type="button" class="flex items-center w-full p-2 text-xl text-left text-gray-500 border border-b-0 border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800" data-accordion-target="#accordion-collapse-body-2" aria-expanded="false" aria-controls="accordion-collapse-body-2">
                                <svg data-accordion-icon="" class="w-6 h-6 shrink-0" fill="currentColor"
                                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                <span class="px-4">
                                    {{ __('student.optional-data') }}
                                </span>
                            </button>
                        </h2>
                        <div id="accordion-collapse-body-2" class="hidden" aria-labelledby="accordion-collapse-heading-2">
                            <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700">
                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.phone-number2') }}</div>
                                    <div class="col-4">
                                        <input type="number" name="phone_number2" id="phoneNumber2"
                                            placeholder="{{ __('student.phone-number2') }}">
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.certificate-type') }}</div>
                                    <div class="col-4">
                                        <select name="primary_certificate_type" id="primaryCertificateType">
                                            <option value="0" disabled selected>
                                                {{ __('student.choose-certificate-type') }}
                                            </option>
                                            @if ( isset($primaryCertificateTypes) )
                                            @foreach ($primaryCertificateTypes as $certificateType)
                                            <option value="{{ $certificateType->id }}">
                                                {{ $certificateType->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.certificate-year') }}</div>
                                    <div class="col-4">
                                        <select name="primary_certificate_year" id="primaryCertificateYear">
                                            <option value="0" disabled selected>
                                                {{ __('student.choose-certificate-year') }}
                                            </option>
                                            @if ( isset($primaryCertificateYears) )
                                            @foreach ($primaryCertificateYears as $certificateYear)
                                            <option value="{{ $certificateYear->id }}">
                                                {{ $certificateYear->value }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">نسبة القبول</div>
                                    <div class="col-4">
                                        <input type="text" name="acceptance_rate" id="acceptanceRare"
                                            placeholder="نسبة القبول" required>
                                    </div>

                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.scholarships') }}</div>
                                    <div class="col-4">
                                        <select name="scholarship" id="scholarship">
                                            @if ( isset($scholarships) )
                                            @foreach ($scholarships as $scholarship)
                                            <option {{ $scholarship->name == 'without-scholarship' ? 'disabled selected' : '' }} value="{{ $scholarship->id }}">
                                                {{ $scholarship->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.scholarship-funding') }}</div>
                                    <div class="col-4">
                                        <select name="scholarship_funding" id="scholarshipFunding">
                                            @if ( isset($scholarshipFundings) )
                                            @foreach ($scholarshipFundings as $scholarshipFunding)
                                            <option {{ $scholarshipFunding->value == 0 ? 'disabled selected' : '' }} value="{{ $scholarshipFunding->id }}">
                                                {{ $scholarshipFunding->value }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                <div class="row my-2">
                                    <div class="col-2 pt-2">{{ __('student.scholarship-donor') }}</div>
                                    <div class="col-4">
                                        <select name="scholarship_donor" id="scholarshipDonor">
                                            <option value="0" disabled selected>
                                                {{ __('student.choose-scholarship-donor') }}
                                            </option>
                                            @if ( isset($scholarshipDonors) )
                                            @foreach ($scholarshipDonors as $scholarshipDonor)
                                            <option value="{{ $scholarshipDonor->id }}">
                                                {{ $scholarshipDonor->name }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2 pt-2">{{ __('student.student-status') }}</div>
                                    <div class="col-4">
                                        <select name="education_status" id="educationStatus">
                                            <option value="0" disabled selected>
                                                {{ __('student.choose-student-status') }}
                                            </option>
                                            @if ( isset($educationStatuses) )
                                            @foreach ($educationStatuses as $status)
                                            <option value="{{ $status->id }}">
                                                {{ $status->value }}
                                            </option>
                                            @endforeach
                                            @else
                                            <option value="0">not set</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600 justify-center ">
                    <button type="submit" class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 focus:outline-none">
                        <i class="fa fa-user-plus" aria-hidden="true"></i>
                        {{ __('student.add') }}
                    </button>
                    <a href="{{ route('student.index') }}"
                       class="bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg text-sm px-5 py-2.5 focus:outline-none focus:ring-4 focus:ring-red-300 dark:focus:ring-red-800 mx-2">
                        {{ __('student.cancel') }}
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        $("#addStudentForm").validate({
            rules: {
                student_name: "required",
                program_fees: {
                    required: true,
                    number: true
                },
                registration_fees: {
                    required: true,
                    number: true
                },
                insurance_fees: {
                    required: true,
                    number: true
                },
                national_id: {
                    required: false,
                    number: true,
                },
            },
            messages: {
                student_name: ".هذا الحقل مطلوب",
                program_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                registration_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                insurance_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                national_id: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                    minlength: "يجب ان لايقل عن ٨ خانات",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                // $(input).next('img').attr('src', e.target.result);
                $(input).next('img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]); // convert to base64 string
        }
    }


    $("#studentImageInput").change(function() {
        alert('changed');
        // $('#studentImageNoImage').css('display','none');
        // $('#studentImageOld').css('display','none');
        $('#studentImageLabel').css('display','none');
        $('#studentImage').css('display','block');
        readURL(this);
    });

    // custmize invalid input
    document.addEventListener("DOMContentLoaded", function() {
        var elements = document.getElementsByTagName("INPUT");
        for (var i = 0; i < elements.length; i++) {
            elements[i].oninvalid = function(e) {
                e.target.setCustomValidity("");
                if (!e.target.validity.valid) {
                    e.target.setCustomValidity("هذا الحقل مطلوب");
                }
            };
            elements[i].oninput = function(e) {
                e.target.setCustomValidity("");
            };
        }
    });
</script>

<script>
    $(document).ready(function () {
        $('#collegeId').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('college.sections') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#sectionId').html('');
                    $(response).each(function (index, element) {
                        $('#sectionId').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                }
            });
        });

        $('#studentFile').change(function(){
            var input = this;
            var url = $(this).val();
            var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
            if (input.files && input.files[0]&& (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"))
            {
                var reader = new FileReader();

                reader.onload = function (e) {
                $('#fileImage').attr('src', e.target.result);
                }
            reader.readAsDataURL(input.files[0]);

            }
            else
            {
                $('#fileImage').attr('src', '{{ asset('img/students/default-student-image.png') }}');
            }
        });

        $('#stateId').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('state.localities') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#localityId').html('');
                    $(response).each(function (index, element) {
                        $('#localityId').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                },
                error : function(response) {
                    console.log(response);
                }
            });
        });
    });
</script>
@endsection
