@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    .custom-file-label{
        border: solid 1px #1a56db;
    }

    #studentFile{
        opacity: 0;
        position: absolute;
        z-index: -1;
        max-width: 200px;
    }

    #editStudentForm .error{
        color: #ff0026;
    }

    textarea {
        resize: none;
    }
</style>

@endsection


@section('content')
<div style="padding-top: 53px;">
    <!-- Modal content -->
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <!-- Modal header -->
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('student.show') ." ". __('student.data') ." ال". __('student.student') }}
            </h3>
        </div>
        <!-- Modal body -->
        <form action="{{ route('student.update', $student->id) }}" method="post" enctype="multipart/form-data" id="editStudentForm">
            @csrf
            @method('put')
            <div class="p-6 space-y-6">
                <div id="accordion-collapse" data-accordion="collapse">
                    <h2 id="accordion-collapse-heading-1">
                        <button type="button" class="flex items-center w-full p-2 text-xl text-left border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 hover:bg-gray-100 dark:hover:bg-gray-800 bg-gray-100 dark:bg-gray-800 text-gray-900 dark:text-white" data-accordion-target="#accordion-collapse-body-1" aria-expanded="true" aria-controls="accordion-collapse-body-1">
                            <svg data-accordion-icon="" class="w-6 h-6 rotate-180 shrink-0"
                                fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            <span class="px-4">
                                {{ __('student.important-data') }}
                            </span>
                        </button>
                    </h2>
                    <div id="accordion-collapse-body-1" class="" aria-labelledby="accordion-collapse-heading-1">
                        <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                            <div class="row py-2 mb-4">

                                <div class="col-12 flex justify-center text-center">
                                    @php $avatarPath = $student->gender == 2 ? 'img/students/female-avatar.jpg' : 'img/students/male-avatar.jpg' @endphp

                                    <img id="fileImage"
                                         src="{{ $student->image ? asset('files/students/' . $student->image) : asset($avatarPath) }}"
                                         alt="Student Image"
                                         style="width: 200px; height: 183px; border-radius: 30%; object-fit: cover;"
                                         onerror="this.onerror=null;this.src='{{ asset($avatarPath) }}';">
                                    <input type="hidden" name="oldImage" value="{{ $student->image }}">
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.serial_number') }}"
                                        name="student_serial_number"
                                        id="studentSerialNumber"
                                        :value="000000"
                                        :placeholder="__('student.id')"
                                        required
                                        readonly
                                    />
                                </div>

                                <div class="w-1/3"></div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.id') }}"
                                        name="student_id"
                                        id="studentId"
                                        :value="$student->student_id ? $student->student_id : ''"
                                        :placeholder="__('student.id')"
                                        required
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.program-fees') }}"
                                        name="program_fees"
                                        id="programFees"
                                        :value="$student->program_fees ? $student->program_fees : 0"
                                        :placeholder="__('student.program-fees')"
                                        required
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.name') }}"
                                        name="student_name"
                                        id="studentName"
                                        :value="$student->student_name"
                                        :placeholder="__('student.name')"
                                        required
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.registration-fees') }}"
                                        name="registration_fees"
                                        id="registrationFees"
                                        :value="$student->registration_fees ? $student->registration_fees : 0"
                                        :placeholder="__('student.registration-fees')"
                                        required
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-radio
                                        label="النوع"
                                        name="gender"
                                        :options="[1 => 'ذكر', 2 => 'أنثى']"
                                        :selected="$student->gender"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.insurance-fees') }}"
                                        name="insurance_fees"
                                        id="insuranceFees"
                                        :value="$student->insurance_fees ? $student->insurance_fees : 0"
                                        :placeholder="__('student.insurance-fees')"
                                        required
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.college') }}"
                                        name="college_id"
                                        id="collegeId"
                                        :options="$colleges"
                                        :selected="$student->college_id"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.section') }}"
                                        name="section_id"
                                        id="sectionId"
                                        :options="$sections"
                                        :selected="$student->section_id"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.program') }}"
                                        name="program_id"
                                        id="programId"
                                        :options="$programs"
                                        :selected="$student->program_id"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.batch') }}"
                                        name="batch_id"
                                        id="batchId"
                                        :options="$batches"
                                        :selected="$student->batch_id"
                                    />
                                </div>
                            </div>

                            {{-- <div class="row py-2">
                                <div class="col-2 pt-2">{{ __('student.program') }}</div>
                                <div class="col-4">
                                    <select name="program_id" id="programId">
                                        @if ($programs)
                                        @foreach ($programs as $program)
                                            <option value="{{ $program->id }}" {{ $program->id == $student->program_id ? 'selected' : '' }}>
                                                {{ __('student.'. $program->name .'') }}
                                            </option>
                                        @endforeach
                                        @else
                                        <option value="0">not set</option>
                                        @endif
                                    </select>
                                </div>

                                <div class="col-2 pt-2">{{ __('student.section') }}</div>
                                <div class="col-4">
                                    <select name="section_id" id="sectionId">
                                        @if ($sections)
                                        @foreach ($sections as $section)
                                        <option value="{{ $section->id }}" {{ $section->id == $student->section_id ? 'selected' : '' }}>
                                            {{ __('student.'. $section->name .'') }}
                                        </option>
                                        @endforeach
                                        @else
                                        <option value=""></option>
                                        @endif
                                    </select>
                                </div>
                            </div> --}}

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        type="text"
                                        name="national_id"
                                        id="nationalId"
                                        :value="$student->national_id"
                                        label="{{ __('student.national-id') }}"
                                        placeholder="{{ __('student.national-id') }}"
                                        required
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        type="date"
                                        name="date_of_birth"
                                        id="dateOfBirth"
                                        :value="$student->date_of_birth"
                                        label="{{ __('student.date-of-birth') }}"
                                        placeholder="{{ __('student.date-of-birth') }}"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.program') }}"
                                        name="program_id"
                                        id="programId"
                                        :options="$programs"
                                        :selected="$student->program_id"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.admission-year') }}"
                                        name="academic_year_id"
                                        id="admissionId"
                                        :options="$years"
                                        :selected="$student->academicYear_id"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="الولاية"
                                        name="state_id"
                                        id="stateId"
                                        :options="$states"
                                        :selected="$student->state_id"
                                    >
                                        <option value="0">إختر الولاية</option>
                                    </x-input-field-select>
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="المحلية"
                                        name="locality_id"
                                        id="localityId"
                                        :options="[]"
                                        :selected="$student->locality_id"
                                    >
                                        <option value="0">إختر المحلية</option>
                                    </x-input-field-select>
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.admission-type') }}"
                                        name="admission_id"
                                        id="admissionId"
                                        :options="$admissions"
                                        :selected="$student->admission_id"
                                    >
                                        <option value="0">إختر نوع القبول</option>
                                    </x-input-field-select>
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="نوع السكن"
                                        name="accommodation_type"
                                        id="accommodationType"
                                        :options="[
                                            (object)['id' => 1, 'name' => 'داخلي'],
                                            (object)['id' => 2, 'name' => 'خارجي'],
                                        ]"
                                        :selected="$student->accommodation_type"
                                    >
                                        <option value="0" disabled>إختار نوع السكن</option>
                                    </x-input-field-select>
                                </div>
                            </div>


                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.phone-number') }}"
                                        name="phone_number"
                                        id="phoneNumber"
                                        value="{{ $student->phone_number }}"
                                        placeholder="{{ __('student.phone-number') }}"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        label="عنوان ولي الامر"
                                        name="guardian_address"
                                        id="guardianAddress"
                                        value="{{ $student->guardian_address }}"
                                        placeholder="عنوان ولي الامر"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="إسم ولي الامر"
                                        name="guardian_name"
                                        id="guardianName"
                                        value="{{ $student->guardian_name }}"
                                        placeholder="إسم ولي الامر"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.guardian-phone-number') }}"
                                        name="guardian_phone_number"
                                        id="guardianPhoneNumber"
                                        value="{{ $student->guardian_phone_number }}"
                                        placeholder="{{ __('student.guardian-phone-number') }}"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2 my-4">
                                <x-input-field-textarea
                                    label="ملحوظة"
                                    name="notes"
                                    id="notes"
                                    :value="$student->notes"
                                    rows="3"
                                />
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <label for="studentFile" class="custom-file-label px-4 py-6 rounded">
                                    {{ __('student.upload-image') }}
                                </label>
                                <input class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" id="studentFile" type="file" name="student_image">
                            </div>

{{--                            <div class="row py-2">--}}
{{--                                <div class="col-12 flex justify-center text-center">--}}
{{--                                    <div class="col-2 pt-2">{{ __('student.image') }}</div>--}}
{{--                                    <div class="col-4">--}}
{{--                                        <label for="studentFile" class="custom-file-label px-4 py-2 rounded">--}}
{{--                                            {{ __('student.upload-image') }}--}}
{{--                                        </label>--}}
{{--                                        <input class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" id="studentFile" type="file" name="student_image">--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
                        </div>
                    </div>

                    <h2 id="accordion-collapse-heading-2">
                        <button type="button" class="flex items-center w-full p-2 text-xl text-left text-gray-500 border border-b-0 border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800" data-accordion-target="#accordion-collapse-body-2" aria-expanded="false" aria-controls="accordion-collapse-body-2">
                            <svg data-accordion-icon="" class="w-6 h-6 shrink-0" fill="currentColor"
                                viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            <span class="px-4">
                                {{ __('student.optional-data') }}
                            </span>
                        </button>
                    </h2>
                    <div id="accordion-collapse-body-2" class="hidden" aria-labelledby="accordion-collapse-heading-2">
                        <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700">

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field
                                        label="{{ __('student.phone-number2') }}"
                                        name="phone_number2"
                                        id="phoneNumber2"
                                        value="{{ $student->phone_number2 ?? '' }}"
                                        placeholder="{{ __('student.phone-number') }}"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.certificate-type') }}"
                                        name="primary_certificate_type"
                                        id="primaryCertificateType"
                                        :options="$primaryCertificateTypes"
                                        :selected="isset($oldPrimaryCertificate) ? $oldPrimaryCertificate->certificate_type_id : ''"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.certificate-year') }}"
                                        name="primary_certificate_year"
                                        id="primaryCertificateYear"
                                        :options="$primaryCertificateYears"
                                        :selected="isset($oldPrimaryCertificate) ? $oldPrimaryCertificate->certificate_year_id : ''"
                                    />
                                </div>

                                <div class="w-1/3">

                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.scholarships') }}"
                                        name="scholarship"
                                        id="scholarship"
                                        :options="$scholarships"
                                        :selected="isset($oldScholarship) ? $oldScholarship->scholarship_id : ''"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.scholarship-funding') }}"
                                        name="scholarship_funding"
                                        id="scholarshipFunding"
                                        :options="$scholarshipFundings"
                                        :selected="isset($oldScholarship) ? $oldScholarship->scholarship_funding_id : ''"
                                    />
                                </div>
                            </div>

                            <div class="flex py-2 justify-center gap-2">
                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.scholarship-donor') }}"
                                        name="scholarship_donor"
                                        id="scholarshipDonor"
                                        :options="$scholarshipDonors"
                                        :selected="isset($oldScholarship) ? $oldScholarship->scholarship_donor_id : ''"
                                    />
                                </div>

                                <div class="w-1/3">
                                    <x-input-field-select
                                        label="{{ __('student.student-status') }}"
                                        name="scholarship_donor"
                                        id="scholarshipDonor"
                                        :options="$educationStatuses"
                                        :selected="isset($oldStatus) ? $oldStatus->education_status_id : ''"
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600">
                <button type="submit"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    {{ __('student.save') }}
                </button>
                <a href="{{ route('student.index') }}" type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                    {{ __('student.cancel') }}
                </a>

                <button type="button" id="printStudentData" class="px-5 py-2.5 rounded-lg" style="background-color: #a72035; position: absolute; left: 20px; color: white;">
                    {{ __('student.print') }}
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Print reciept for student card -->
<div class="relative bg-white rounded-lg shadow dark:bg-gray-700" style="display: none">
    <!-- Modal header -->
    <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
            {{ __('student.show') ." ". __('student.data') ." ال". __('student.student') }}
        </h3>
    </div>

    <div id="dataForCard">
        <div class="p-6 space-y-6">
            <div class="row">
                <div class="col-12 flex justify-center text-center">
                    <img id="studentImage" src="{{ $student->image ? asset('img/students/' . $student->image) : asset('img/students/default-student-image.png')}}" alt="" style="width: 150px; height: 150px;">
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.serial_number') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="studentSerialNumber" placeholder="{{ __('student.id') }}"
                    value="000000" readonly
                    placeholder="{{ __('student.serial-number') }}" readonly>
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.id') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="studentId" value="{{ $student->student_id ? $student->student_id : '' }}"
                    placeholder="{{ __('student.id') }}" readonly>
                </div>

                <div class="col-2 pt-2">{{ __('student.name') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="studentName" value="{{ $student->student_name ? $student->student_name : '' }}"
                    placeholder="{{ __('student.name') }}" required>
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.program') }}</div>
                <div class="col-4">
                    <select name="" id="programId">
                        @if ($programs)
                        @foreach ($programs as $program)
                            <option value="{{ $program->id }}" {{ $program->id == $student->program_id ? 'selected' : '' }}>
                                {{ $program->name }}
                            </option>
                        @endforeach
                        @else
                        <option value="0">not set</option>
                        @endif
                    </select>
                </div>

                <div class="col-2 pt-2">{{ __('student.section') }}</div>
                <div class="col-4">
                    <select name="section_id" id="sectionId" style="max-width: 230px;">
                        <option value="0">{{ __('student.choose-section') }}</option>
                        @if ($sections)
                            @foreach ($sections as $section)
                                <option value="{{ $section->id }}" {{ $section->id == $student->section_id ? 'selected' : '' }}>
                                    {{ $section->name }}
                                </option>
                            @endforeach
                        @else
                        <option value="0"></option>
                        @endif
                    </select>
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.date-of-birth') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="nationalId" value="{{ $student->national_id ? $student->national_id : '' }}"
                    placeholder="{{ __('student.national-id') }}" required>
                </div>
                <div class="col-2 pt-2">{{ __('student.national-id') }}</div>

                <div class="col-4">
                    <input type="date" name="" id="dateOfBirth" value="{{ $student->date_of_birth ? $student->date_of_birth : '' }}"
                        placeholder="{{ __('student.date-of-birth') }}">
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.state') }}</div>
                <div class="col-4">
                    <select name="" id="stateId">
                        @if ($states)
                        @foreach ($states as $state)
                        <option value="{{ $state->id }}" {{ $state->id == $student->state_id ? 'selected' : '' }}>
                            {{ $state->name }}
                        </option>
                        @endforeach
                        @else
                        <option value="0">not set</option>
                        @endif
                    </select>
                </div>

                <div class="col-2 pt-2">{{ __('student.phone-number') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="phoneNumber" value="{{ $student->phone_number ? $student->phone_number : '' }}"
                        placeholder="{{ __('student.phone-number') }}">
                </div>
            </div>

            <div class="row">
                <div class="col-2 pt-2">{{ __('student.admission-type') }}</div>
                <div class="col-4">
                    <select name="" id="admissionId">
                        @if ($admissions)
                        @foreach ($admissions as $admission)
                        <option value="{{ $admission->id }}">
                            {{ $admission->name }}
                        </option>
                        @endforeach
                        @else
                        <option value="0">not set</option>
                        @endif
                    </select>
                </div>

                <div class="col-2 pt-2">{{ __('student.guardian-phone-number') }}</div>
                <div class="col-4">
                    <input type="text" name="" id="guardianPhoneNumber" value="{{ $student->guardian_phone_number ? $student->guardian_phone_number : ''  }}"
                        placeholder="{{ __('student.guardian-phone-number') }}">
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script>
    $(document).ready(function () {
        $('#printStudentData').click(function (e) {
            e.preventDefault();

            $('#dataForCard').print({
                append : '<style>#dataForCard{direction: rtl;}</style>',
            });
        });
    });
</script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function () {
        $("#editStudentForm").validate({
            rules: {
                student_name: "required",
                program_fees: {
                    required: true,
                    number: true
                },
                registration_fees: {
                    required: true,
                    number: true
                },
                insurance_fees: {
                    required: true,
                    number: true
                },
                national_id: {
                    required: false,
                    number: true,
                },
            },
            messages: {
                student_name: ".هذا الحقل مطلوب",
                program_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                registration_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                insurance_fees: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                national_id: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                    minlength: "يجب ان لايقل عن ٨ خانات",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $(input).next('img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]); // convert to base64 string
        }
    }


    $("#studentImageInput").change(function() {
        // $('#studentImageNoImage').css('display','none');
        // $('#studentImageOld').css('display','none');
        $('#studentImageLabel').css('display','none');
        $('#studentImage').css('display','block');
        readURL(this);
    });

</script>

<script>
    $(document).ready(function () {
        $('#collegeId').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('college.sections') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#sectionId').html('');
                    $(response).each(function (index, element) {
                        $('#sectionId').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                }
            });
        });

        $('#studentFile').change(function(){
            var input = this;
            var url = $(this).val();
            var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
            if (input.files && input.files[0]&& (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"))
            {
                var reader = new FileReader();

                reader.onload = function (e) {
                $('#fileImage').attr('src', e.target.result);
                }
            reader.readAsDataURL(input.files[0]);

            }
            else
            {
                $('#fileImage').attr('src', '{{ asset('img/students/default-student-image.png') }}');
            }
        });

        $('#stateId').change(function (e) {
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('state.localities') }}",
                data: {
                    parent_id: $(this).find(":selected").val(),
                },
                // dataType: "html",
                success: function (response) {
                    $('#localityId').html('');
                    $(response).each(function (index, element) {
                        $('#localityId').append($('<option>', {
                            value: element.id,
                            text : element.name
                        }));
                    });
                }
            });
        });
    });
</script>
@endsection
