@extends('layouts.app')
@section('styles')

<link href="{{ asset('plugins/bootstrap-editable/css/bootstrap-editable.css') }}" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    .custom-file-label {
        border: solid 1px #1a56db;
    }

    #file_input, #fileInputEdit {
        opacity: 0;
        position: absolute;
        z-index: -1;
        max-width: 200px;
    }

    #editStudentForm .error {
        color: #ff0026;
    }
</style>

<style>
    tfoot {
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled) {
        padding-right: 30px !important;
    }
</style>

@endsection


@section('content')
<div style="padding-top: 53px;">
    <!-- Modal content -->
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <!-- Modal header -->
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <div class="flex-col">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-2">
                    {{ __('student.show') ." ". __('student.files') ." ال". __('student.student') }}
                </h3>
                <h4 class="font-semibold text-gray-900 dark:text-white">
                    {{ $student->student_name ?? ''}}
                </h4>
            </div>
        </div>

        <!-- Modal body -->
        {{-- <a href="{{ route('student-files.create') }}"> --}}
        <a data-modal-target="addFile" data-modal-toggle="addFile">
            <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                <button type="button"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800 ml-6">
                    <i class="fa fa-plus-square" aria-hidden="true"></i>
                    إضافة ملف
                </button>
            </div>
        </a>
        <div class="p-6 space-y-6">
            <div id="studentsListTable" class="mt-4">
                <table class="table" id="filesTable" style="width: 100%;">
                    <thead>
                        <tr>
                            <th scope="col" class="py-2 px-2 text-white">
                                رقم
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                نوع الملف
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                ملحوظة
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                معاينة الملف
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                تاريخ الانشاء
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                الإجراءات
                            </th>
                        </tr>
                    </thead>

                    <tbody id="studentsList">
                        @if ($files)
                        <?php $no = 1; ?>
                        @foreach ($files as $file)
                        <tr>
                            <td class="py-2 text-center">
                                {{ $no }}
                            </td>
                            <td class="py-2 text-center">
                                {{ $file->fileType->value ?? 'لم يتم التحديد' }}
                            </td>
                            <td class="py-2 text-center">
                                {{ $file->note ?? 'لم يتم التحديد' }}
                            </td>
                            <td class="py-2 text-center">
                                <a href="{{ asset('files/students/'. $file->url) }}"
                                    class="px-2 py-1 rounded text-white" style="background-color: #36304a">
                                    <i class="fas fa-eye"></i>
                                    معاينة
                                </a>
                            </td>
                            <td class="py-2 text-center">
                                {{ $file->created_at ?? 'لم يتم التحديد' }}
                            </td>
                            <td class="py-2 text-center flex justify-center">
                                <a id="editFileBtn" data-modal-target="editFile" data-modal-toggle="editFile" data-id="{{ $file->id }}"
                                    class="px-2 py-1 rounded text-white mx-2" style="background-color: #337ab7">
                                    <i class="fas fa-edit"></i>
                                    تعديل
                                </a>

                                @if (auth()->user()->hasRole(['registrar', 'admin']))
                                <a href="{{ route('student.files', $student->id) }}" onclick="event.preventDefault();
                                        document.getElementById('delete-form-{{$file->id}}').submit();"
                                    class="px-2 py-1 rounded text-white mx-2" style="background-color: #d9534f">
                                    <i class="fas fa-trash"></i>
                                    حذف
                                </a>
                                <form id="delete-form-{{$file->id}}" +
                                    action="{{route('student-files.destroy', $file->id)}}" method="post">
                                    @csrf @method('DELETE')
                                </form>
                                @endif
                            </td>
                        </tr>

                        <?php $no += 1; ?>
                        @endforeach
                        @endif
                    </tbody>

                    <tfoot>
                        <tr>
                            <th scope="col" class="py-2 px-2 text-white">
                                رقم
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                نوع الملف
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                ملحوظة
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                تحميل الملف
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                تاريخ الانشاء
                            </th>
                            <th scope="col" class="py-2 px-2 text-white">
                                الإجراءات
                            </th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>


{{-- modals --}}
<!-- Add File -->
<div id="addFile" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full md:h-auto">
        <form method="post" action="{{ route('student-files.store') }}" enctype="multipart/form-data" id="addFileForm">
            @csrf
            <input type="hidden" name="student_id" value="{{ $student->student_id ?? '' }}">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-start justify-center p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white text-center">
                        إضافة ملف جديد
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="p-6 space-y-6">
                    <div class="row">
                        <div class="col-2 pt-2">نوع الملف</div>
                        <div class="col-4">
                            <select id="fileTypeId" name="file_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0">إختار نوع الملف</option>
                                @if ( isset($fileTypes) )
                                @foreach ($fileTypes as $fileType)
                                <option value="{{ $fileType->id }}">
                                    {{ $fileType->value }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">ملاحظة</div>
                        <div class="col-4">
                            <input type="text" name="note" id="note"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="ملاحظة"
                                value="">
                        </div>
                    </div>

                    <div class="row my-4">
                        <div class="col-12 flex justify-center text-center">
                            <div class="col-4">
                                <label for="file_input" class="custom-file-label px-4 py-2 rounded">
                                    إضغط هنا لتحمل الملف
                                </label>
                                <input
                                    class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                                    id="file_input" type="file" name="file">
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                    <button data-modal-hide="addFile" type="submit"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        حفظ
                    </button>
                    <button data-modal-hide="addFile" type="button"
                        class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                        الغاء
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Edit File -->
<div id="editFile" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full md:h-auto">
        <form method="post" action="{{ route('student-files.update', $fileId ?? 0) }}" enctype="multipart/form-data" id="editFileForm">
            @csrf
            @method('put')
            <input type="hidden" name="id" id="id">
            <input type="hidden" name="student_id" id="studentIdEdit">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-start justify-center p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white text-center">
                        تعديل بيانات الملف
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="p-6 space-y-6">
                    <div class="row">
                        <div class="col-2 pt-2">نوع الملف</div>
                        <div class="col-4">
                            <select name="file_type_id" id="fileTypeIdEdit"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                required>
                                <option value="0">إختار نوع الملف</option>
                                @if ( isset($fileTypes) )
                                @foreach ($fileTypes as $fileType)
                                <option value="{{ $fileType->id }}">
                                    {{ $fileType->value }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">ملاحظة</div>
                        <div class="col-4">
                            <input type="text" name="note" id="noteEdit"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="ملاحظة"
                                value="">
                        </div>
                    </div>

                    <div class="row my-4">
                        <div class="col-12 flex justify-center text-center">
                            <div class="col-4">
                                <label for="fileInputEdit" class="custom-file-label px-4 py-2 rounded">
                                    إضغط هنا لتحمل الملف
                                </label>
                                <input
                                    class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                                    id="fileInputEdit" type="file" name="file_edit">
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                    <button data-modal-hide="editFile" type="submit"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        تعديل
                    </button>
                    <button data-modal-hide="editFile" type="button"
                        class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                        الغاء
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')

{!! Toastr::message() !!}

<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>


<!-- datatable custimzation -->
<script>
    $(document).ready(function () {
        dataTable = $("#filesTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": false,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });
    
        $('#filesTable').on("click", "#editFileBtn", function () { 
            let id = $(this).data('id');
            $.ajax({
                type: "get",
                url: "{{ url('student-files') }}" + '/' + id,
                success: function (response) {
                    console.log(response);
                    $('#id').val(response.id);
                    $('#studentIdEdit').val(response.fileable_id);
                    $('#noteEdit').val(response.note);
                    $(`#fileTypeIdEdit option[value=${response.file_type_id}]`).attr('selected', 'selected');
                },
                error: function (response) {
                    console.log(response);
                },
            });
        });
    }); // End of $(document).ready
</script>
@endsection