@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<link rel="stylesheet" href="{{ asset('css/custom-style.css') }}">
<style>
    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
    .toast-title{
        text-align: center;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('home.students') }}
                    <a href="{{ route('student.create') }}">
                        <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                            <button type="button" class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 focus:outline-none">
                                <i class="fa fa-user-plus" aria-hidden="true"></i>
                                {{ __('student.add-new-student') }}
                            </button>
                        </div>
                    </a>
                </div>
                <div class="card-body">
                    <!-- filter -->
                    @include('layouts.filter')

{{--                    @include('students.partials.search-button')--}}

                    <div id="studentsListTable" class="mt-4">
                        @include('students.partials.table')
                    </div>
                </div>

            </div>

            <div class="export-import flex justify-center m-5">
                <form action="{{ route('student.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group mb-4 text-center">
                        <div class="custom-file">
                            <label for="file_input" class="custom-file-label px-4 py-2 rounded">
                                {{ __('student.choose-file') }}
                            </label>
                            <input class="block w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 cursor-pointer dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" id="file_input" type="file" name="file" required>
                        </div>
                    </div>
                    <button class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2">
                        <i class="fa fa-upload" aria-hidden="true"></i>
                        {{ __('student.import') }}
                    </button>
                    <a class="custom-primary-btn text-white font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2"
                        href="{{ route('student.export.view') }}">
                        <i class="fa fa-download" aria-hidden="true"></i>
                        {{ __('student.export') }}
                    </a>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
{!! Toastr::message() !!}
<script src="{{ asset('plugins/jQuery.print.min.js') }}"></script>

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

{{--<script src="{{ asset('plugins/ajax-search/js/ajax-search.js') }}"></script>--}}

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });
</script>

@endsection
