<div id="studentsSearchListTable" class="mt-4">
    <table class="table" id="studentsSearchTable" style="width: 100%;">
        <thead>
        <tr>
            <th scope="col" class="py-2 px-2 text-white">
                رقم
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.id') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.name') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.section') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.date') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.actions') }}
            </th>
        </tr>
        </thead>
        <tbody id="studentsList">
        @if ( isset($students) )
                <?php $no = 1;?>
            @foreach ($students as $student)
                <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                    <th scope="row" class="py-2 text-center">
                            <?= $no++; ?>
                    </th>
                    <td class="py-2 text-center">
                        {{ $student->student_id }}
                    </td>
                    <td class="py-2 text-right">
                        {{ $student->student_name }}
                    </td>
                    <td class="py-2 text-center">
                        {{ isset($student->section) ? $student->section->name : __('home.not-set') }}
                    </td>
                    <td class="py-2 text-center">
                        {{ $student->created_at}}
                    </td>

                    <td class="py-2 text-center">
                        <a class="px-4 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full mx-1"
                           href="{{ route('student.edit', $student->id) }}" style="background-color: #36304a">
                            <i class="fa fa-eye" aria-hidden="true"></i>
                            {{ __('student.show') }}
                        </a>

                        <a class="px-4 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full mx-1"
                           href="{{ route('student.files', $student->id) }}" style="background-color: #36304a">
                            <i class="fa fa-file" aria-hidden="true"></i>
                            {{ __('student.files') }}
                        </a>

                        {{-- @if (auth()->user()->hasRole('admin'))
                            <a href="{{ route('student.index') }}" onclick="event.preventDefault();
                            document.getElementById('delete-form-{{$student->id}}').submit();"
                                class="px-4 py-1 text-sm text-white bg-red-700 hover:bg-red-800 rounded-full mx-1">
                                <i class="fa fa-trash" aria-hidden="true"></i>
                                {{ __('student.delete') }}
                            </a>
                            <form id="delete-form-{{$student->student_id}}" +
                                action="{{route('student.destroy', $student->student_id)}}" method="post">
                                @csrf @method('DELETE')
                            </form>
                        @endif --}}
                    </td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <th scope="col" class="py-2 px-2 text-white">
                رقم
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.id') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.name') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.section') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.date') }}
            </th>
            <th scope="col" class="py-2 px-2 text-white">
                {{ __('student.actions') }}
            </th>
        </tr>
        </tfoot>
    </table>

    <div>
        {{ $students->withQueryString()->links() }}
    </div>
</div>
