@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
    .printReceipt{
        background-color: #a72035;
    }

    #printReceipt td,
    #printReceipt th{
        border: black 2px solid;
        color: black;
    }

    #printReceipt img{
        width: 1122.5px;
        height: 135px;
    }

    #printReceipt .student-name{
        /* width: 40%; */
        text-align: right;
        padding-right: 20px;
    }
    .receiptQr{
        width: 120px;
        margin: auto;
    }
</style>
@endsection

@section('content')
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                {{ __('fee.pay-student-payment') }}
            </h3>
        </div>
        <div class="p-6 space-y-6">
            <form method="post" action="{{ route('pay.payment') }}" enctype="multipart/form-data" id="studentForm">
                @csrf
                <div class="p-6 space-y-6">
                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.id') }}</div>
                        <div class="col-4">
                            <input type="text" name="student_id" id="studentId"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="" placeholder="{{ __('student.id') }}">
                        </div>

                        <div class="col-6">
                            <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-right' : 'float-left'}}">
                                <button type="button" id="getStudentData"
                                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                                    <i class="fa fa-user-plus" aria-hidden="true"></i>
                                    {{ __('fee.get-student-data') }}
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row"></div>
                    <hr>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.name') }}</div>
                        <div class="col-4">
                            <input type="text" name="student_name" id="studentName"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="" readonly placeholder="{{ __('student.name') }}">
                        </div>

                        <div class="col-2 pt-2">{{ __('fee.payment-amount') }}</div>
                        <div class="col-4">
                            <input type="text" name="payment_amount" id="paymentAmount"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.payment-amount') }}"
                                value="" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('student.semester') }}</div>
                        <div class="col-4">
                            <select id="semesterId" name="semester_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                readonly>
                                <option value="0">{{ __('student.choose-semester') }}</option>
                                @if ( isset($semesters) )
                                @foreach ($semesters as $semester)
                                <option value="{{ $semester->id }}">
                                    {{ $semester->name }}
                                </option>
                                @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="col-2 pt-2">{{ __('fee.payment-reference') }}</div>
                        <div class="col-4">
                            <input type="text" name="payment_reference" id="paymentReference"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.payment-reference') }}" value=""
                                readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-2 pt-2"></div>
                        <div class="col-4">
                        </div>

                        <div class="col-2 pt-2">حالة الدفعية</div>
                        <div class="col-4">
                            <div id="paymentStatus" dir="rtl" class="flex"></div>
                        </div>
                    </div>

                    <div class="row"></div>
                    <hr>

                    <div class="row">
                        <div class="col-2 pt-2">{{ __('fee.transaction-reference') }}</div>
                        <div class="col-4">
                            <input type="text" name="transaction_ref" id="transactionRef"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                value="" readonly placeholder="{{ __('fee.transaction-reference') }}">
                        </div>

                        <div class="col-2 pt-2">{{ __('fee.financial-identifier') }}</div>
                        <div class="col-4">
                            <input type="text" name="bank_identifier" id="bankIdentifier"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                placeholder="{{ __('fee.financial-identifier') }}"
                                value="">
                        </div>
                    </div>

                </div>

                <div class="flex items-center p-6 space-x-2 rounded-b border-t border-gray-200 dark:border-gray-600 justify-between">
                    <div>
                        <button type="submit"
                            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            {{ __('student.add') }}
                        </button>
                        <a href="{{ route('home') }}" type="button"
                            class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                            {{ __('student.cancel') }}
                        </a>
                    </div>
                    <button type="button" id="getStudentData"
                        {{-- class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 focus:outline-none float-right" > --}}
                        class="text-white font-medium rounded-lg text-sm px-5 py-2.5 focus:outline-none float-right printReceipt hidden">
                        طباعة الايصال
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- modal --}}
<div hidden>
    <div id="receiptModal" dir="rtl">
        <div class="grid grid-cols-1 gap-1">
            <img src="{{ asset('img/') . env('SYSTEM_BANAR') }}" alt="">
            
            <h1 class="font-bold text-2xl text-center">ايصال سداد دفعية</h1>
            
            <div>
                {{-- row 1 --}}
                <div class="row gx-0">
                    {{-- row 1 --}}
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; width: 112px;">
                        {{ __('student.name') }}
                    </div>
                    <div class="studentName pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; width: 600px;">
                        {{ __('student.name') }}
                    </div>
                </div>

                {{-- row 2 --}}
                <div class="row gx-0">
                    <div style="width: 80px; border: black 1px solid; border-top: none; border-left: none;"></div>
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                        {{ __('student.id') }}
                    </div>
                    <div class="studentId pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 440px;">
                        {{ __('student.id') }}
                    </div>
                    <div style="width: 80px; border: black 1px solid; border-top: none; border-right: none;"></div>
                </div>
                
                {{-- row 3 --}}
                <div class="row gx-0">
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                        {{ __('student.semester') }}
                    </div>
                    <div class="semesterId pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                        {{ __('student.semester') }}
                    </div>
                    <div style="width: 80px"></div>
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 120px;">
                        {{ __('student.payment-date') }}
                    </div>
                    <div class="paymentDate pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                        {{ __('student.payment-date') }}
                    </div>
                </div>

                {{-- row 4 --}}
                <div class="row gx-0">
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                        {{ __('fee.payment-amount') }}
                    </div>
                    <div class="paymentAmount pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                        {{ __('fee.payment-amount') }}
                    </div>
                    <div style="border-bottom: black 1px solid; width: 80px;"></div>
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 120px;">
                        {{ __('fee.transaction-reference') }}
                    </div>
                    <div class="transactionRef pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 200px;">
                        {{ __('fee.transaction-reference') }}
                    </div>
                </div>

                {{-- row 5 --}}
                <div class="row gx-0">    
                    <div class="pt-2 pr-2 font-bold" style="border: black 1px solid; border-top: none; width: 112px;">
                        {{ __('student.user-name') }}
                    </div>
                    <div class="userName pt-2 pb-1 bg-gray-50 text-gray-900 text-sm focus:ring-blue-500 block w-full dark:bg-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 px-4" style="border: black 1px solid; border-right: none; border-top: none; width: 600px;">
                        {{ __('student.user-name') }}
                    </div>
                </div>
            </div>

        </div>

        <div class="mt-10">
            <div class="receiptQr">
                <div id="qr-code"></div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/qr-code/js/qrcode.min.js') }}"></script>

{!! Toastr::message() !!}
<script src="{{ asset('js/divjs.js') }}"></script>
<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch').each( function (){
            $(this).change(function (e) { 
                e.preventDefault();
                
                $('#studentFilter').click();
            });
        });

        $('#getStudentData').click(function (e) { 
            e.preventDefault();

            $.ajax({
                type: "get",
                url: "{{ route('get.student.info') }}",
                data: {
                    student_id: $('#studentId').val(),
                },
                success: function (response) {
                    console.log(response);
                    $('#studentName').val(response.student_name);
                    $('#paymentAmount').val(response.payment_amount);
                    $('#paymentReference').val(response.payment_reference);
                    $(`#semesterId option[value=${response.semester_id}]`).attr('selected','selected');
                    $('#transactionRef').val(Date.now());

                    if(response.is_paid == 1){
                        $('#paymentStatus').html(`
                            <div class="bg-green-100 border border-green-400 text-green-700 px-2 py-2 rounded relative" role="alert">
                                <strong class="font-bold">${response.payment_status}</strong>
                            </div>
                        `);
                        $('.printReceipt').removeClass('hidden');
                    } else {
                        $('#paymentStatus').html(`
                            <div class="bg-red-100 border border-red-400 text-red-700 px-2 py-2 rounded relative" role="alert">
                                <strong class="font-bold">${response.payment_status}</strong>
                            </div>
                        `);
                        $('.printReceipt').addClass('hidden');
                    }

                    $('.studentId').html(response.student_id);
                    $('.studentName').html(response.student_name);
                    $('.paymentAmount').html(response.payment_amount);
                    $('.transactionRef').html(response.transaction_ref);
                    $('.semesterId').html(response.semester_name);
                    $('.paymentDate').html(response.createdAt);
                    $('.userName').html(response.user_name);

                    // QR Code
                    new QRCode(document.getElementById("qr-code"), "{{ url('check-receipt/') }}" + "/" + response.transaction_ref);
                },
                statusCode: {
                    404: function(data, xhr) {
                        Swal.fire({
                            title: "عملية غير ناجحة",
                            text: data.responseJSON,
                            icon: "error",
                            confirmButtonText: "تم",
                        });
                    },
                    442: function(data, xhr) {
                        Swal.fire({
                            title: "عملية غير ناجحة",
                            text: data.responseJSON,
                            icon: "question",
                            confirmButtonText: "تم",
                        });
                    },
                    500: function(data, xhr) {
                        Swal.fire({
                            title: "عملية غير ناجحة",
                            text: data.responseJSON,
                            icon: "error",
                            confirmButtonText: "تم",
                        });
                        console.log(xhr.responseText);
                    },
                },
                error: function (request, status, error) {
                    console.log(request.responseText);
                }
            });
        });

        $('.printReceipt').click(function(){
            $('#receiptModal').printElement();
        });
    });

</script>
@endsection