@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">

<style>
    tfoot{
        background-color: #36304a;
    }
    
    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    {{ __('student.student-payments') }}
                    @if (auth()->user()->hasRole('financial'))
                        <a href="{{ route('pay.student.payment') }}">
                            <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                                <button type="button"
                                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                                    <i class="fa fa-user-plus" aria-hidden="true"></i>
                                    {{ __('fee.pay-new-fee') }}
                                </button>
                            </div>
                        </a>
                    @endif
                </div>

                <div class="card-body">
                    <div class="custom-filter row">
                        <form action="{{ route('filter.students.payments') }}" method="post" id="filterForm">
                            @csrf
                            @include('layouts.filter')

                            <div class="row flex justify-center space-x-2 mt-4">
                                <div class="col-4 flex justify-center px-1">
                                    <button type="submit" style="background-color: #36304a;" class="mr-3 px-4 py-2 rounded-2 text-white btn" id="studentFilter" name="filter">
                                        {{__('student.apply-filter') }}
                                    </button>
                                    <a href="{{ route('student.payments') }}" style="background-color: #36304a;" class="bg-danger btn mr-3 px-4 py-2 rounded-2 text-white" id="studentFilter">
                                        {{__('student.reset') }}
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div id="studentsListTable">
                        <table class="table" id="studentsTable" style="width: 100%;">
                            <thead>
                                <tr class="table100-head">
                                    <th class="text-xs">
                                        رقم
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.id') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.transaction-reference') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.name') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.academic-class') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.batch') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.amount') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.constraint-type') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.payment-date') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white">
                                @if ( isset($studentsPayments) )
                                <?php $no = 1; ?>
                                @foreach ($studentsPayments as $studentPayment)
                                @if ($studentPayment->student)
                                <tr class="whitespace-nowrap">
                                    <td class="text-sm text-center text-black">
                                        <?= $no++; ?>
                                    </td>
                                    <td class="text-sm text-center text-black">
                                        {{ $studentPayment->student->student_id }}
                                    </td>
                                    <td class="text-sm text-center text-black">
                                        {{ $studentPayment->transaction_ref }}
                                    </td>
                                    <td class="text-center">
                                        <div class="text-sm text-gray-900">
                                            {{ $studentPayment->student->student_name }}
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="text-sm text-black">{{ isset($studentPayment->student->semester) ? $studentPayment->student->semester->name  : __('student.not-set') }}</div>
                                    </td>
                                    <td class="text-center">
                                        <div class="text-sm text-black">{{ isset($studentPayment->student->batch->value) ? $studentPayment->student->batch->value : __('student.not-set') }}
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        {{ $studentPayment->payment_amount }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentPayment->student->constraint_type != null ? __('student.' .
                                        $studentPayment->student->constraint_type) : __('student.not-set') }}
                                    </td>
                                    <td class="text-center">
                                        {{ $studentPayment->created_at}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @else
                                <tr class="whitespace-nowrap">
                                    <td>no data</td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr class="table100-head">
                                    <th class="text-xs">
                                        رقم
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.id') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('fee.transaction-reference') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.name') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.academic-class') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.batch') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.amount') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.constraint-type') }}
                                    </th>
                                    <th class="text-xs">
                                        {{ __('student.payment-date') }}
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div> <!-- end of studentsListTable-->

                </div>
            </div>
            <div class="export-import flex justify-center m-5">
                <a class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800"
                    href="{{ route('students.payments.export.view') }}">
                    <i class="fa fa-download" aria-hidden="true"></i>
                    {{ __('student.export') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<!-- datatable custimzation -->
{!! Toastr::message() !!}

<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });
    
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
            },
        });
        // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    
        $(".constraint-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-class-option").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        $(".academic-year").click(function() {
            dataTable.search( $(this).attr('value') ).draw();
        });

        
    }); // End of $(document).ready
</script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch').each( function (){
            $(this).change(function (e) { 
                e.preventDefault();
                
                $('#studentFilter').click();
            });
        });
    });
</script>
@endsection