@extends('layouts.app')
@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
	.html5buttons{
		direction: ltr;
		position: absolute;
		top: -45px;
		left: 10px;
	}
	.html5buttons .btn-secondary{
		color:  #ffffff;
		background-color:#295694;
	}

	.html5buttons .buttons-print{
		background-color: rgb(167, 32, 53);
		color: white;
	}

	.dataTables_filter{
		margin: 20px 0px 20px;
	}
	#min, #max {
		max-width: 150px;
		min-width: unset;
		font-size: 12px;
		font-weight: 400;
		text-align: center;
		color: #495057;
		background-color: #fff;
		background-clip: padding-box;
		border: 1px solid #ced4da !important;
		border-radius: 0.25rem;
		min-height: calc(1.5em + 0.5rem + 2px);
		padding: 0.25rem 0.5rem;
	}
	.dt-datetime-year, .dt-datetime-month{
		min-width: unset !important;
		width: 50px !important;
		max-height: 22px !important;
	}

	.dropdown-menu .dropdown-item {
		text-align: right !important;
	}

	tfoot{
	background-color:#36304a !important;
	}

	tfoot p{
		color: white !important;
		font-size: 12px !important;
		font-weight: 100 !important;
	}
    #addUserForm .error,
    #editUserForm .error{
        color: red;
        margin-top: 2px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card" id="content">
                <div class="card-header flex justify-between p-3 text-2xl text-blue-700">
                    الملف الشخصي
                </div>
                <div class="card-body col-8 m-auto">
                    
                    <form action="{{ route('user.profile.update') }}" method="post" enctype="multipart/form-data" id="editUserForm">
                        @csrf
                        @method('put')

                        <div class="row pt-3 pb-4">
                            <div class="col-12 flex justify-center text-center">
                                <img id="fileImage" src="{{ asset('files/users/' . $user->profileImage) }}" alt="" style="width: 200px; height: 200px;">
    
                                <label for="fileUpload" type="button">
                                    <i class="fas fa-edit text-primary rounded-1" style="position: relative; left: 38px; top: 3px; font-size: 20px; background-color: white; width: 35px; height: 23px;"></i>
                                </label>
                                <input type="file" name="file" id="fileUpload" class="hidden">
                                
                            </div>
                        </div>
                        
                        <input type="hidden" name="id" id="editId" value="{{ $user->id }}">
                        <input type="hidden" name="oldFile" value="{{ $user->profileImage }}">

                        <div class="row my-3">
                            <div class="col-2 pt-2">
                                اسم المستخدم
                            </div>
                            <div class="col-4">
                                <input type="text" name="name" id="userName"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    required
                                    value="{{ $user->name ?? '' }}" placeholder="اسم المستخدم">
                            </div>
                            
                            <div class="col-2 pt-2">
                                البريد الالكتروني
                            </div>
                            <div class="col-4">
                                <input type="text" name="email" id="userEmail"
                                    class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    placeholder="البريد الإلكتروني"
                                    required
                                    value="{{ $user->email ?? '' }}">
                            </div>
                        </div>

                        <div class="row my-3">
                            @if ($user->hasRole('registrar'))
                                <div class="col-2 pt-2">
                                    الكلية
                                </div>
                                <div class="col-4">
                                    <input type="text" name="college" id="userCollege"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                        value="{{ $user->college->name ?? '' }}" readonly placeholder="الكلية">
                                </div>
                            @else
                                <div class="col-2 pt-2"></div>
                                <div class="col-4"></div>
                            @endif
                            
                            <div class="col-2 pt-2">
                                الدور
                            </div>
                            <div class="col-4">
                                <input type="text" name="role" id="userRole"
                                    class=" bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    placeholder="الدور"
                                    readonly
                                    value="{{ $user->roleName ?? '' }}">
                            </div>
                        </div>
                        <hr class="mt-4">

                        <div class="row mt-5">
                            <div class="col-3"></div>
                            <div class="col-2 pt-2">
                                كلمة المرور الحالية
                            </div>
                            <div class="col-4">
                                <input type="password" name="password" id="userPassword"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    required
                                    placeholder="كلمة المرور الحالية">
                            </div>
                        </div>

                        <div class="row my-2">
                            <div class="col-3"></div>
                            <div class="col-2 pt-2">
                                كلمة المرور الجديدة
                            </div>
                            <div class="col-4">
                                <input type="password" name="new_password" id="userNewPassword"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    placeholder="كلمة المرور الجديدة">
                            </div>
                        </div>

                        <div class="row my-2 pb-5">
                            <div class="col-3"></div>
                            <div class="col-2 pt-2">
                                تاكيد كلمة المرور 
                            </div>
                            <div class="col-4">
                                <input type="password" name="confirm_password" id="userConfirmPassword"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1 text-center"
                                    placeholder="تاكيد كلمة المرور">
                            </div>
                        </div>

                        <div class="row my-2">
                            <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                                <button type="submit"
                                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                    تعديل
                                </button>
                                <button type="button"
                                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600 mx-2">
                                    الغاء
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function () {
        $("#editUserForm").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                },
                new_password: {
                    required: function(element){
                        return $("#userConfirmPassword").val().length > 0;
                    },
                },
                confirm_password: {
                    required: function(element){
                        return $("#userNewPassword").val().length > 0;
                    },
                    equalTo: '#userNewPassword',
                },
            },
            messages: {
                name: ".هذا الحقل مطلوب",
                email: {
                    required: ".هذا الحقل مطلوب",
                    email: "الرجاء ادخال بريد الكتروني صالح.",
                },
                password: {
                    required: ".هذا الحقل مطلوب",
                },
                new_password: {
                    required: ".هذا الحقل مطلوب",
                },
                confirm_password: {
                    required: ".هذا الحقل مطلوب",
                    equalTo: 'كلمة المرور غير مطابقة',
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        $('#fileUpload').change(function(){
            var input = this;
            var url = $(this).val();
            var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
            if (input.files && input.files[0]&& (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")) 
            {
                var reader = new FileReader();

                reader.onload = function (e) {
                $('#fileImage').attr('src', e.target.result);
                }
            reader.readAsDataURL(input.files[0]);

            }
            else
            {
                $('#fileImage').attr('src', '{{ asset('img/students/default-student-image.png') }}');
            }
        });
    });
</script>
@endsection