<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<link rel="shortcut icon" href="/vendor/laratrust/img/logo.png">
	<title> {{ __('home.uofs') }} - @yield('title')</title>
	{{-- <link href="{{ mix('laratrust.css', 'vendor/laratrust') }}" rel="stylesheet"> --}}
	<link rel="stylesheet" href="{{ asset('vendor/laratrust/laratrust.css') }}">
	<script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.min.js" defer></script>

	 <!-- DataTables -->
	 <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
	 <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
	 <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
 
	 <!-- Styles -->
	 <link href="{{ asset('css/app.css') }}" rel="stylesheet">
 
	 <link href="{{ asset('css/tailwind.min.css') }}" rel="stylesheet">
	 <link href="{{ asset('css/flowbite.min.css') }}" rel="stylesheet" />
 
	 <!-- fontawesome -->
	 <link rel="stylesheet" href="{{ asset('plugins/font-awesome/css/fontawesome.min.css') }}">
	 <link rel="stylesheet" href="{{ asset('plugins/font-awesome/css/all.min.css') }}">
 
	 <!-- Toaster -->
	 <link rel="stylesheet" href="{{ asset('plugins/toastr/css/toastr.min.css') }}">
 
	 <link rel="stylesheet" href="{{ asset('plugins/custom-table/css/main.css') }}">
 
	 <link href="{{ asset('plugins/preloader/preloader.css') }}" rel="stylesheet">

	 <style>
		nav img {
			max-width: 55px;
		}
	
		.home-custom {
			padding-left: 30px;
			padding-right: 30px;
		}
	
		.card {
			min-height: 500px;
		}
	
		.main-container {
			margin-top: 75px;
		}
	
		table th {
			text-align: center;
		}
	
		#studentsTable_filter label {
			word-spacing: 20px;
		}
	
		#studentsTable_filter input {
			border-radius: 6px;
			max-height: 35px;
		}
	
		.custom-filter .dropdown {
			max-width: 150px;
		}
	
		.custom-filter .dropdown-toggle {
			color: #000000;
			border: none;
		}
	
		.custom-filter .dropdown-toggle:hover {
			background-color: rgba(0, 0, 0, 0.1)
		}
	
		.custom-filter .dropdown-toggle:focus,
		.custom-filter .dropdown-toggle:active {
			background-color: rgb(166 27 48 / 83%);
			color: #ffffff;
		}
	
		.custom-filter .dropdown-toggle:focus {
			border: #ffffff;
		}
	</style>

	@yield('styles')
</head>

<body dir="rtl">
	<div>
		<nav
            class="bg-white px-2 sm:px-4 py-2.5 dark:bg-gray-900 fixed w-full z-20 top-0 left-0 border-b border-gray-200 dark:border-gray-600">
            <div class="container flex flex-wrap justify-between items-center mx-auto">
                <a href="{{ route('home') }}" id="dashboard" class="flex items-center">
                    <img src="{{ asset('img/') . env('SYSTEM_LOGO') }}" alt="">
                </a>
                <div class="flex md:order-2">
                    <div type="button" class="text-gray-700 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center mr-3 md:mr-0 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        <ul class="navbar-nav {{ App::isLocale('ar') ? '' : 'ms-auto' }}">
                            <!-- Authentication Links -->
                            @guest
                            @if (Route::has('login'))
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('login') }}">{{ __('login.login') }}</a>
                            </li>
                            @endif

                            @if (Route::has('register'))
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('register') }}">{{ __('login.registrar') }}</a>
                            </li>
                            @endif
                            @else
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    {{-- {{ Auth::user()->name == 'registrar' || Auth::user()->name == 'admin' ? __('login.'. Auth::user()->name) : Auth::user()->name }} --}}
                                    {{ Auth::user()->name }}
                                </a>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    @if (auth()->user()->hasRole('registrar'))
                                        <a class="dropdown-item text-right" href="{{ route('registration-management.index') }}">
                                            ادارة التسجيل
                                        </a>
                                    @endif
                                    <a class="dropdown-item text-right" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                        {{ __('login.logout') }}
                                    </a>
                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                            @endguest
                            
                        </ul>
                    </div>

                    <button data-collapse-toggle="navbar-sticky" type="button"
                        class="inline-flex items-center p-2 text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600"
                        aria-controls="navbar-sticky" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
                <div class="hidden justify-between items-center w-full md:flex md:w-auto md:order-1" id="navbar-sticky">
                    <ul class="flex flex-col bg-gray-50 rounded-lg border border-gray-100 md:flex-row md:space-x-8 md:mt-0 md:text-sm md:font-medium md:border-0 md:bg-white dark:bg-gray-800 md:dark:bg-gray-900 dark:border-gray-700"
                        dir="rtl">
						
						<li>
							<a href="{{ route('home') }}"
								class="block py-2 pr-4 pl-3 {{ Request::segment(1) == 'student' && Request::segment(2) == '' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700' }} bg-blue-700 rounded md:bg-transparent md:p-0 dark:text-white home-custom"
                                aria-current="page">
								الرئيسية
							</a>
						</li>

						<li>
							<a href="{{ route('user.index') }}"
								class="block py-2 pr-4 pl-3 {{ Request::segment(1) == 'user' && Request::segment(2) ? 'text-blue-500 md:text-blue-700' : 'text-gray-700' }} rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700"
                                aria-current="page">
								المستخدمين
							</a>
						</li>

						<li>
							<a href="{{route('laratrust.roles.index')}}"
								{{-- class="ml-4 {{ request()->is('*roles') ? 'nav-button-active' : 'nav-button' }}"> --}}
								class="block py-2 pr-4 pl-3 {{ Request::segment(1) == 'student' && Request::segment(2) == 'payments' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700' }} rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700"
                                aria-current="page">
								الادوار
							</a>
						</li>

						<li>
							<a href="{{ route('laratrust.permissions.index') }}"
								{{-- class="ml-4 {{ request()->is('*permissions*') ? 'nav-button-active' : 'nav-button' }}"> --}}
								class="block py-2 pr-4 pl-3 {{ Request::segment(1) == 'student' && Request::segment(2) == 'payments' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700' }} rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700"
                                aria-current="page">
								الصلاحيات
							</a>
						</li>

						<li>
							<a href="{{ route('laratrust.roles-assignment.index') }}"
								{{-- class="ml-4 {{ request()->is('*roles') ? 'nav-button-active' : 'nav-button' }}"> --}}
								class="block py-2 pr-4 pl-3 {{ Request::segment(1) == 'student' && Request::segment(2) == 'payments' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700' }} rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700"
                                aria-current="page">
								الادوار و اسناد الصلاحيات
							</a>
						</li>
                    </ul>
                </div>
            </div>
        </nav>

		{{-- <header class="bg-white shadow">
			<div class="max-w-6xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
				<h1 class="text-3xl font-bold leading-tight text-gray-900">
					@yield('title')
				</h1>
			</div>
		</header> --}}
		{{-- <main>
			<div class="max-w-6xl mx-auto py-6 sm:px-6 lg:px-8">
				@foreach (['error', 'warning', 'success'] as $msg)
				@if(Session::has('laratrust-' . $msg))
				<div class="alert-{{ $msg }}" role="alert">
					<p>{{ Session::get('laratrust-' . $msg) }}</p>
				</div>
				@endif
				@endforeach
				<div class="px-4 py-6 sm:px-0">
					@yield('content')
				</div>
			</div>
		</main> --}}
		<main class="py-4">
            @yield('content')
        </main>
	</div>

	<!-- jQuery -->
    <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button)
    </script>

    <!-- DataTables  & Plugins -->
    <script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/vfs_fonts.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>

    <!-- Toaster -->
    <script src="{{ asset('plugins/toastr/js/toastr.min.js') }}"></script>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="{{ asset('js/flowbite.js') }}"></script>

    <script src=" {{ asset('js/datepicker.js') }}"></script>

    <script src=" {{ asset('plugins/sweetalert2/js/sweetalert2.min.js') }}"></script>


    @yield('scripts')

    <script>
        window.onload= function(){
            $(".preloader").hide();
        }

        // $(document).ready(function () {
        //     $('.datepicker').click(function (e) { 
        //         e.preventDefault();

        //         $(this).hasClass('hidden') ? $(this).removeClass('hidden') : $($(this)).addClass('hidden');
        //     });
        // });
    </script>
</body>

</html>