@extends('laratrust::panel.layout')

@section('title')
{{ __('user-roles.permissions') }}
@endsection

@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
	.html5buttons{
		direction: ltr;
		position: absolute;
		top: -45px;
		left: 10px;
	}
	.html5buttons .btn-secondary{
		color:  #ffffff;
		background-color:#295694;
	}

	.html5buttons .buttons-print{
		background-color: rgb(167, 32, 53);
		color: white;
	}

	.dataTables_filter{
		margin: 20px 0px 20px;
	}
	#min, #max {
		max-width: 150px;
		min-width: unset;
		font-size: 12px;
		font-weight: 400;
		text-align: center;
		color: #495057;
		background-color: #fff;
		background-clip: padding-box;
		border: 1px solid #ced4da !important;
		border-radius: 0.25rem;
		min-height: calc(1.5em + 0.5rem + 2px);
		padding: 0.25rem 0.5rem;
	}
	.dt-datetime-year, .dt-datetime-month{
		min-width: unset !important;
		width: 50px !important;
		max-height: 22px !important;
	}

	.dropdown-menu .dropdown-item {
		text-align: right !important;
	}

	tfoot{
	background-color:#36304a !important;
	}

	tfoot p{
		color: white !important;
		font-size: 12px !important;
		font-weight: 100 !important;
	}
</style>
@endsection

@section('content')
<div class="container-fluid main-container">
	<div class="row justify-content-center">
		<div class="col-md-12">
			<div class="card" id="content">
				<div class="card-header flex justify-between p-3 text-2xl text-blue-700">
					{{ __('user-roles.permissions') }}

					<div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
						<a href="{{route('laratrust.permissions.create')}}"
							class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
							<i class="fa fa-plus-circle" aria-hidden="true" style="font-size: 20px; vertical-align: middle; margin-left: 5px;"></i>
							{{ __('user-roles.add-new-role') }}
						</a>
					</div>
				</div>

				<div class="card-body">
					<div class="overflow-x-auto relative shadow-md sm:rounded-lg mt-8">
						<table class="w-full text-sm text-left text-gray-500 dark:text-gray-400 responsive-table">
							<thead class="text-xs text-white uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
								<tr class="table100-head">
									<th scope="col" class="py-2 px-2">
										ID
									</th>
									<th scope="col" class="py-2 px-2">
										{{ __('user-roles.name') }} / {{ __('user-roles.code') }}
									</th>
									<th scope="col" class="py-2 px-2">
										{{ __('user-roles.display-name') }}
									</th>
									<th scope="col" class="py-2 px-2">
										{{ __('user-roles.description') }}
									</th>
									<th scope="col" class="py-2 px-2"></th>
								</tr>
							</thead>
							<tbody id="studentsList">
								@foreach ($permissions as $permission)
								<tr>
									<th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
										{{$permission->getKey()}}
									</th>

									<td class="py-2 text-center">
										{{$permission->name}}
									</td>

									<td class="py-2 text-center">
										{{$permission->display_name}}
									</td>

									<td class="py-2 text-center">
										{{$permission->description}}
									</td>

									<td class="py-2 text-center">
										<a href="{{route('laratrust.permissions.edit', $permission->getKey())}}">
											<i class="fas fa-edit text-primary mx-2" style="font-size: 20px;"></i>
										</a>
									</td>
								</tr>
								@endforeach
							</tbody>
							<tfoot>
								<tr>
									<th scope="col" class="py-1 px-1" colspan="2" style="direction: ltr;">
										{{-- {{ $permissions->links('laratrust::panel.pagination') }} --}}
									</th>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection