@extends('laratrust::panel.layout')

@section('title')
{{ __('user-roles.roles-assignment') }}
@endsection

@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
	.html5buttons{
		direction: ltr;
		position: absolute;
		top: -45px;
		left: 10px;
	}
	.html5buttons .btn-secondary{
		color:  #ffffff;
		background-color:#295694;
	}

	.html5buttons .buttons-print{
		background-color: rgb(167, 32, 53);
		color: white;
	}

	.dataTables_filter{
		margin: 20px 0px 20px;
	}
	#min, #max {
		max-width: 150px;
		min-width: unset;
		font-size: 12px;
		font-weight: 400;
		text-align: center;
		color: #495057;
		background-color: #fff;
		background-clip: padding-box;
		border: 1px solid #ced4da !important;
		border-radius: 0.25rem;
		min-height: calc(1.5em + 0.5rem + 2px);
		padding: 0.25rem 0.5rem;
	}
	.dt-datetime-year, .dt-datetime-month{
		min-width: unset !important;
		width: 50px !important;
		max-height: 22px !important;
	}

	.dropdown-menu .dropdown-item {
		text-align: right !important;
	}

	tfoot{
	background-color:#36304a !important;
	}

	tfoot p{
		color: white !important;
		font-size: 12px !important;
		font-weight: 100 !important;
	}
</style>
@endsection
@section('content')
	<div class="container-fluid main-container">
		<div class="row justify-content-center">
			<div class="col-md-12">
				<div class="card" id="content">
					<div class="card-header flex justify-between p-3 text-2xl text-blue-700">
						{{ __('user-roles.roles-assignment') }}
					</div>
					<div class="card-body pb-16">
						<div id="studentsListTable" class="mt-4">
							<table class="table" id="studentsTable" style="width: 100%;">
								<thead>
									<tr>
										<th scope="col" class="py-2 px-2 text-white">
											Id
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											{{ __('user-roles.name') }}
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											# {{ __('user-roles.roles') }}
										</th>
										@if(config('laratrust.panel.assign_permissions_to_user'))
										<th scope="col" class="py-2 px-2 text-white">
											# {{ __('user-roles.permissions') }}
										</th>
										@endif
										<th scope="col" class="py-2 px-2 text-white">
											الكلية
										</th>
										<th scope="col" class="py-2 px-2 text-white"></th>
									</tr>
								</thead>
								<tbody>
									@foreach ($users as $user)
									<tr>
										<th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
											{{$user->getKey()}}
										</th>
	
										<td class="py-2 text-center">
											{{$user->name ?? 'The model doesn\'t have a `name` attribute'}}
										</td>
	
										<td class="py-2 text-center">
											{{$user->roles_count}}
										</td>
	
										@if(config('laratrust.panel.assign_permissions_to_user'))
										<td class="py-2 text-center">
											{{$user->permissions_count}}
										</td>
										@endif

										<td class="py-2 text-center">
											{{$user->college->name ?? ''}}
										</td>

										<td class="py-2 text-center">
											<a href="{{route('laratrust.roles-assignment.edit', ['roles_assignment' => $user->getKey(), 'model' => $modelKey])}}">
												<i class="fas fa-edit text-primary" style="font-size: 20px;"></i>
											</a>
										</td>
									</tr>
									@endforeach
								</tbody>
								<tfoot>
									<tr>
										<th scope="col" class="py-2 px-2 text-white">
											Id
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											{{ __('user-roles.name') }}
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											# {{ __('user-roles.roles') }}
										</th>
										@if(config('laratrust.panel.assign_permissions_to_user'))
										<th scope="col" class="py-2 px-2 text-white">
											# {{ __('user-roles.permissions') }}
										</th>
										@endif

										<th scope="col" class="py-2 px-2 text-white">
											الكلية
										</th>
										
										<th scope="col" class="py-2 px-2 text-white"></th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>


				</div>
			</div>
		</div>
	</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });
    
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });
    }); // End of $(document).ready
</script>

<script>
    $(document).ready(function () {
        $('#college, #section, #program, #batch').each( function (){
            $(this).change(function (e) { 
                e.preventDefault();
                
                $('#studentFilter').click();
            });
        });
    });
</script>
@endsection
