@extends('laratrust::panel.layout')

@section('title')
{{ __('user-roles.users') }}
@endsection

@section('styles')
<link rel="stylesheet" href="{{ asset('css/custom-student-style.css') }}">
<style>
	.html5buttons{
		direction: ltr;
		position: absolute;
		top: -45px;
		left: 10px;
	}
	.html5buttons .btn-secondary{
		color:  #ffffff;
		background-color:#295694;
	}

	.html5buttons .buttons-print{
		background-color: rgb(167, 32, 53);
		color: white;
	}

	.dataTables_filter{
		margin: 20px 0px 20px;
	}
	#min, #max {
		max-width: 150px;
		min-width: unset;
		font-size: 12px;
		font-weight: 400;
		text-align: center;
		color: #495057;
		background-color: #fff;
		background-clip: padding-box;
		border: 1px solid #ced4da !important;
		border-radius: 0.25rem;
		min-height: calc(1.5em + 0.5rem + 2px);
		padding: 0.25rem 0.5rem;
	}
	.dt-datetime-year, .dt-datetime-month{
		min-width: unset !important;
		width: 50px !important;
		max-height: 22px !important;
	}

	.dropdown-menu .dropdown-item {
		text-align: right !important;
	}

	tfoot{
	background-color:#36304a !important;
	}

	tfoot p{
		color: white !important;
		font-size: 12px !important;
		font-weight: 100 !important;
	}
    #addUserForm .error,
    #editUserForm .error{
        color: red;
        margin-top: 2px;
    }
</style>
@endsection
@section('content')
	<div class="container-fluid main-container">
		<div class="row justify-content-center">
			<div class="col-md-12">
				<div class="card" id="content">
					<div class="card-header flex justify-between p-3 text-2xl text-blue-700">
						{{ __('user-roles.users') }}

                        {{-- <a href="{{ route('user.create') }}"> --}}
                        <a data-modal-toggle="createUserModal">
                            <div class="add-student  {{ app()->getLocale() == 'ar' ? 'float-left' : 'float-right'}}">
                                <button type="button"
                                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                                    <i class="fa fa-user-plus" aria-hidden="true"></i>
                                    إضافة مستخدم جديد
                                </button>
                            </div>
                        </a>
                        
					</div>
					<div class="card-body pb-16">
						<div id="studentsListTable" class="mt-4">
							<table class="table" id="studentsTable" style="width: 100%;">
								<thead>
									<tr>
										<th scope="col" class="py-2 px-2 text-white">
											رقم
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											إسم المستخدم
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											البريد الإلكتروني
										</th>
                                        <th scope="col" class="py-2 px-2 text-white">
                                            الإجراء
                                        </th>
									</tr>
								</thead>
								<tbody>
                                    <?php $no = 1 ?>
									@foreach ($users as $user)
									<tr>
										<th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
											{{ $no }}
										</th>

										<td class="py-2 text-center">
											{{ $user->name ?? 'لم يتم التحديد' }}
										</td>

										<td class="py-2 text-center">
											{{ $user->email ?? 'لم يتم التحديد'}}
										</td>

										<td class="py-2 text-center">
                                            <div class="flex justify-center user-actions">
                                                <a id="editUser" data-id="{{ $user->id }}" class="mx-2" data-modal-toggle="editUserModal">
                                                    <i class="fas fa-edit text-primary" style="font-size: 20px;"></i>
                                                </a>

                                                {{-- <a href="{{ route('user.destroy', $user->id )}}" class="mx-2"> --}}
                                                <a id="deleteUser" data-id="{{ $user->id }}">
                                                    <i class="fas fa-trash text-danger" style="font-size: 20px;"></i>
                                                </a>
                                            </div>
										</td>
									</tr>

                                    <?php $no += 1 ?>
									@endforeach
								</tbody>
								<tfoot>
									<tr>
                                        <th scope="col" class="py-2 px-2 text-white">
											رقم
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											إسم المستخدم
										</th>
										<th scope="col" class="py-2 px-2 text-white">
											البريد الإلكتروني
										</th>
                                        <th scope="col" class="py-2 px-2 text-white">
                                            الإجراء
                                        </th>
                                    </tr>
								</tfoot>
							</table>
						</div>
					</div>


				</div>
			</div>
		</div>
	</div>


{{-- modals --}}
{{-- create user --}}
<div id="createUserModal" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full md:h-screen">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    اضافة مستخدم جديد
                </h3>
                <button type="button"
                    class="bg-gray-300 text-danger"
                    data-modal-toggle="createUserModal">
                    <svg aria-hidden="true" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <form method="post" action="{{ route('user.store') }}" enctype="multipart/form-data" id="addUserForm">
                    @csrf
                    <div class="p-6 space-y-6">
                        <div class="row my-2">
                            <div class="col-2 pt-2">اسم المستخدم</div>
                            <div class="col-4">
                                <input type="text" name="name" id="userName"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="اسم المستخدم" required>
                            </div>
    
                            <div class="col-2 pt-2">البريد الإلكتروني</div>
                            <div class="col-4">
                                <input type="text" name="email" id="userEmail"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="البريد الإلكتروني" required>
                            </div>
                        </div>

                        <div class="row my-2">
                            <div class="col-2 pt-2">كلمة المرور</div>
                            <div class="col-4">
                                <input type="password" name="password" id="userPassword" style="max-width: 240px;"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="******" required>
                            </div>
    
                            <div class="col-2 pt-2">تاكيد كلمة المرور</div>
                            <div class="col-4">
                                <input type="password" name="confirm_password" id="userConfirmPassword" style="max-width: 240px;"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="******" required>
                            </div>
                        </div>
                    </div>
                    <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                        <button type="submit" id="createNewUser"
                            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            حفظ
                        </button>
                        <button data-modal-toggle="createUserModal" type="button"
                            class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                            الغاء
                        </button>
                    </div>
                </form>
            </div>
            <!-- Modal footer -->
        </div>
    </div>
</div>

<div id="editUserModal" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-modal md:h-full">
    <div class="relative w-full h-full md:h-screen">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    تعديل بيانات المستخدم
                </h3>
                <button type="button"
                    class="bg-gray-300 text-danger"
                    data-modal-toggle="editUserModal">
                    <svg aria-hidden="true" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <form method="post" action="{{ route('user.update', $user->id) }}" enctype="multipart/form-data" id="editUserForm">
                    @csrf
                    @method('put')
                        <div class="p-6 space-y-6" id="showUserList"></div>
                    <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                        <button type="submit" id="createNewUser"
                            class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                            حفظ
                        </button>
                        <button data-modal-toggle="editUserModal" type="button"
                            class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">
                            الغاء
                        </button>
                    </div>
                </form>
            </div>
            <!-- Modal footer -->
        </div>
    </div>
</div>
@endsection

@section('scripts')
{!! Toastr::message() !!}

<script src="{{ asset('plugins/jquery-validate/js/jquery.validate.min.js') }}"></script>

<!-- datatable custimzation -->
<script>
    $("#printStudentData").click(function(){
        $('#editStudentForm').print();
    });
    
    $(document).ready(function () {
        dataTable = $("#studentsTable").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });
    }); // End of $(document).ready
</script>

<script>
    $(document).ready(function () {
        $("#addUserForm").validate({
            rules: {
                name: "required",
                email: {
                    required: false,
                    email: true
                },
                password: {
                    required: true,
                },
                confirm_password: {
                    required: true,
                    equalTo: '#userPassword',
                },
            },
            messages: {
                name: ".هذا الحقل مطلوب",
                email: {
                    required: ".هذا الحقل مطلوب",
                    email: "الرجاء ادخال بريد الكتروني صالح.",
                },
                password: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                confirm_password: {
                    required: ".هذا الحقل مطلوب",
                    equalTo: 'كلمة المرور غير مطابقة',
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        $("#editUserForm").validate({
            rules: {
                name: "required",
                email: {
                    required: false,
                    email: true
                },
                password: {
                    required: function(element){
                        return $("#editUserConfirmPassword").val().length > 0;
                    },
                },
                confirm_password: {
                    required: function(element){
                        return $("#editUserPassword").val().length > 0;
                    },
                    equalTo: '#editUserPassword',
                },
            },
            messages: {
                name: ".هذا الحقل مطلوب",
                email: {
                    required: ".هذا الحقل مطلوب",
                    email: "الرجاء ادخال بريد الكتروني صالح.",
                },
                password: {
                    required: ".هذا الحقل مطلوب",
                    number: "هذاالحقل ارقام فقط",
                },
                confirm_password: {
                    required: ".هذا الحقل مطلوب",
                    equalTo: 'كلمة المرور غير مطابقة',
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        $('#studentsTable tbody').on('click', '#editUser', function () {
            let id = $(this).data('id');
            console.log(id);
            $.ajax({
                type: "get",
                url: "user" + "/" + id,
                success: function (response) {
                    console.log(response);
                    $('#showUserList').html('');
                    $('#showUserList').append(`
                        <input type="hidden" name="user_id" value="${response.id}">
                        <div class="row my-2">
                            <div class="col-2 pt-2">اسم المستخدم</div>
                            <div class="col-4">
                                <input type="text" name="name" id="userName"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="اسم المستخدم" required value="${response.name}">
                            </div>
    
                            <div class="col-2 pt-2">البريد الإلكتروني</div>
                            <div class="col-4">
                                <input type="text" name="email" id="userEmail"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="البريد الإلكتروني" required value="${response.email}">
                            </div>
                        </div>
    
                        <div class="row my-2">
                            <div class="col-2 pt-2">كلمة المرور</div>
                            <div class="col-4">
                                <input type="password" name="password" id="editUserPassword" style="max-width: 240px;"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="******" required>
                            </div>
    
                            <div class="col-2 pt-2">تاكيد كلمة المرور</div>
                            <div class="col-4">
                                <input type="password" name="confirm_password" id="editUserConfirmPassword" style="max-width: 240px;"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1"
                                    placeholder="******" required>
                            </div>
                        </div>
                    `);               
                }
            });
        });

        $('#studentsTable tbody').on('click', '#deleteUser', function () {
            let id = $(this).data('id');
            $.ajax({
                type: "DELETE",
                url: "{{ url('user') }}" + '/' + id,
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'عملية ناجحة!',
                        text: response,
                    }).then( function(){
                        location.reload();
                    });
                },
                error: function(response){
                    Swal.fire({
                        icon: 'error',
                        title: 'عملية غير ناجحة!',
                        text: response,
                    }).then( function(){
                        location.reload();
                    });
                }
            });
        });
    });
</script>
@endsection
